/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.construction.ConstSupport;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.valid.IsValidOp;

public class DrawCircleTool
extends NClickTool {
    protected Coordinate modelDestination = null;
    private Shape selectedFeaturesShape;
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private boolean valuesWereSet = false;
    private double radius = 50.0;
    private Point mp = null;
    private int points = 8;
    private int deactivateCount = 0;
    private final ActionListener valueChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DrawCircleTool.this.radius = (Double)GetValuePanel.instanceOf().getValue();
            }
            catch (Throwable t) {
                DrawCircleTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };

    private DrawCircleTool() {
        super(1);
        this.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f));
        this.allowSnapping();
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        return FeatureDrawingUtil.prepare(new DrawCircleTool(), true);
    }

    @Override
    public boolean isUndoable() {
        return FeatureDrawingUtil.insertsUndoable();
    }

    @Override
    protected void gestureFinished() throws Exception {
        double tmp;
        int pts;
        Point p;
        this.mp = p = new GeometryFactory().createPoint(this.getModelDestination());
        double tmpRadius = this.radius;
        Task task = this.getTaskFrame().getTask();
        if (task.isProjectionReductionActive() && (this.getTentativeCoordinate().equals((Object)this.getModelDestination()) || !this.getTentativeCoordinate().equals((Object)this.getModelDestination()) && !this.getSnapManager().wasSnapCoordinateFound())) {
            CRSDefinition crsDef = task.getCRSDefinition();
            DrawingUnit unit = task.getDrawingUnit();
            tmpRadius = crsDef.getProjectedDistance(tmpRadius, task.getHeightReduction(), this.getModelDestination(), unit);
        }
        if ((pts = (int)Math.floor(Math.PI / (tmp = Math.acos((tmpRadius - tmpRadius * 0.002) / tmpRadius)) / 4.0)) < 3) {
            pts = 3;
        }
        this.points = pts;
        Geometry circle = BufferOp.bufferOp((Geometry)p, (double)tmpRadius, (int)(this.points - 1));
        if (p.getCoordinate().z != Double.NaN) {
            for (Coordinate coordinate : circle.getCoordinates()) {
                coordinate.z = p.getCoordinate().z;
            }
        }
        this.checkCircle(circle);
        if (circle instanceof Polygon) {
            FeatureDrawingUtil.drawRing((Polygon)circle, this.isRollingBackInvalidEdits(), this, this.getPanel());
        }
        SaveLayerFeatureChangesPlugIn.commitLayer(FeatureDrawingUtil.layer(), true, false, false);
    }

    protected boolean checkCircle(Geometry circle) throws NoninvertibleTransformException {
        IsValidOp isValidOp = new IsValidOp(circle);
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        try {
            Envelope viewportEnvelope = layerViewPanel.getViewport().getEnvelopeInModelCoordinates();
            double x = viewportEnvelope.getMinX() + viewportEnvelope.getWidth() / 2.0;
            double y = viewportEnvelope.getMinY() + viewportEnvelope.getHeight() / 2.0;
            Coordinate initCoords = new Coordinate(x, y, 0.0);
            this.calcuateCircle(initCoords, layerViewPanel);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        ++this.deactivateCount;
        if (this.deactivateCount == 2) {
            this.valuesWereSet = false;
            this.deactivateCount = 0;
        }
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.DrawCircleTool.name");
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_add_circle.svg");
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        try {
            this.setViewDestination(e.getPoint());
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        try {
            super.mouseDragged(e);
            if (!this.getCoordinates().isEmpty()) {
                Coordinate coord = this.snap(e.getPoint());
                double length = ConstSupport.getLength((Coordinate)this.getCoordinates().get(0), (Coordinate)coord);
                GetValuePanel.instanceOf().setValue(new Double(length));
                this.valueChangedListener.actionPerformed(null);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        this.calcuateCircle(this.modelDestination, this.getPanel());
        GeneralPath path = new GeneralPath(this.selectedFeaturesShape);
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        return path;
    }

    private void calcuateCircle(Coordinate middlePoint, LayerViewPanel panel) {
        Point p;
        this.mp = p = new GeometryFactory().createPoint(middlePoint);
        Geometry buffer = p.buffer(this.radius);
        Geometry[] geomArray = new Geometry[]{buffer};
        GeometryCollection gc = this.geometryFactory.createGeometryCollection(geomArray);
        try {
            this.selectedFeaturesShape = panel.getJava2DConverter().toShape((Geometry)gc);
        }
        catch (NoninvertibleTransformException e) {
            System.out.println("DrawCircleWithGivenRadiusTool:Exception " + String.valueOf(e));
        }
    }

    protected void setViewDestination(Point2D destination) throws NoninvertibleTransformException {
        this.setModelDestination(this.getPanel().getViewport().toModelCoordinate(destination));
    }

    protected void setModelDestination(Coordinate destination) {
        this.modelDestination = this.snap(destination);
    }

    @Override
    public JPanel getAssistentPanel() {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        valPanel.resetPanel();
        valPanel.setValueFormat(0);
        valPanel.setDescription(I18N.get("ui.cursortool.editing.DrawCircleTool.radius-description"));
        valPanel.setValueLabelListener(I18N.get("ui.cursortool.editing.DrawCircleTool.radius"), this.valueChangedListener);
        valPanel.setValue(new Double(this.radius));
        return valPanel;
    }
}

