/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.cursortool.Animations;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import com.vividsolutions.jump.workbench.ui.plugin.VerticesInFencePlugIn;
import de.riwagis.icons.IconLoader;
import java.awt.Color;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class DeleteVertexTool
extends SpecifyFeaturesTool {
    private final EnableCheckFactory checkFactory;
    private final GeometryEditor geometryEditor = new GeometryEditor();

    public DeleteVertexTool(EnableCheckFactory checkFactory) {
        this.checkFactory = checkFactory;
        this.setViewClickBuffer(5);
        this.allowSnapping();
    }

    @Override
    protected void gestureFinished() {
        if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
            return;
        }
        ArrayList<Coordinate> verticesDeleted = new ArrayList<Coordinate>();
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layer : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
            if (!layer.isEditable()) continue;
            transactions.add(this.createTransaction(layer, verticesDeleted));
        }
        int emptyGeometryCount = EditTransaction.emptyGeometryCount(transactions);
        if (emptyGeometryCount > 0) {
            this.getPanel().getContext().warnUser(I18N.get("ui.cursortool.editing.DeleteVertexTool.cancelled-deletion-would-result-in-empty-geometry"));
            return;
        }
        if (verticesDeleted.isEmpty()) {
            this.getPanel().getContext().warnUser(I18N.get("ui.cursortool.editing.DeleteVertexTool.no-selection-handles-here"));
            return;
        }
        EditTransaction.commit(transactions, () -> {
            try {
                Animations.drawExpandingRings(this.getPanel().getViewport().toViewPoints(verticesDeleted), true, Color.red, this.getPanel(), new float[]{15.0f, 15.0f});
            }
            catch (Throwable t) {
                this.getPanel().getContext().warnUser(t.toString());
            }
        });
    }

    protected EditTransaction createTransaction(Layer layer, ArrayList<Coordinate> verticesDeleted) {
        Geometry box = EnvelopeUtil.toGeometry(this.getBoxInModelCoordinates());
        return EditTransaction.createTransactionOnSelection((geometryWithSelectedItems, selectedItems) -> {
            if (!box.getEnvelopeInternal().intersects(geometryWithSelectedItems.getEnvelopeInternal())) {
                return geometryWithSelectedItems;
            }
            Collection<Coordinate> verticesInBox = VerticesInFencePlugIn.verticesInFence(selectedItems, box, true);
            if (this.wasClick() && !verticesInBox.isEmpty()) {
                verticesDeleted.add(verticesInBox.iterator().next());
            } else {
                verticesDeleted.addAll(verticesInBox);
            }
            return this.geometryEditor.deleteVertices(geometryWithSelectedItems, verticesInBox);
        }, this.getPanel(), this.getPanel().getContext(), this.getName(), layer, this.isRollingBackInvalidEdits(), false);
    }

    @Override
    public Cursor createCursor() {
        return DeleteVertexTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_remove.svg").getImage());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_delete_vertex.svg");
    }
}

