/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.PolygonTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.jts.JTSSupport;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;

public class AppendPolygonTool
extends PolygonTool {
    private static final GeometryFactory gfac = new GeometryFactory();
    private static final String strArea = I18N.get("ui.cursortool.MeasureTool.area");
    private final DecimalFormat dfArea = new DecimalFormat();
    private String strUnit = "";
    private DrawingUnit unit = null;
    private final ActionListener valueChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AppendPolygonTool.this.setAngle((Double)GetValuePanel.instanceOf().getValue());
            }
            catch (Throwable t) {
                AppendPolygonTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };
    private final ActionListener value1ChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AppendPolygonTool.this.setLength((Double)GetValuePanel.instanceOf().getValue1());
            }
            catch (Throwable t) {
                AppendPolygonTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };
    private final ActionListener cbo1Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GetValuePanel valPanel = GetValuePanel.instanceOf();
            AppendPolygonTool.this.setUseAngleConstraint(valPanel.getCbo1Value());
            AppendPolygonTool.this.getAssistentPanel();
        }
    };
    private final ActionListener cbo2Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GetValuePanel valPanel = GetValuePanel.instanceOf();
            AppendPolygonTool.this.setUseLengthConstraint(valPanel.getCbo2Value());
            AppendPolygonTool.this.getAssistentPanel();
        }
    };
    private Layer ly = null;
    private SimpleFeature f = null;
    private boolean bolAutoCommit = false;

    public AppendPolygonTool(Layer _ly, SimpleFeature _f) {
        this.ly = _ly;
        this.f = _f;
        this.allowSnapping();
    }

    public void setAutoCommit(boolean _bolAutoCommit) {
        this.bolAutoCommit = _bolAutoCommit;
    }

    @Override
    public Cursor createCursor() {
        return FeatureDrawingUtil.createEditCursor();
    }

    @Override
    public boolean useTooltip() {
        return true;
    }

    @Override
    public String getTooltip(Point2D mouseLocation) {
        try {
            ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
            currentCoordinates.add(this.getTentativeCoordinate());
            return this.getTooltipHtml(currentCoordinates);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_add_polygon.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.DrawPolygonTool.name");
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (!this.checkPolygon()) {
            return;
        }
        Polygon poly = this.getPolygon();
        Object objGeom = this.f.getDefaultGeometry();
        Object geom = null;
        geom = objGeom == null ? poly : JTSSupport.mergeGeom((Geometry)((Geometry)this.f.getDefaultGeometry()), (Geometry)poly);
        this.f = FeatureUtil.cloneFeature((SimpleFeature)this.f);
        EditTransaction transaction = new EditTransaction(Arrays.asList(this.f), this.getName(), this.ly, true, false, this.getPanel());
        transaction.setGeometry(0, (Geometry)geom);
        transaction.commit();
        if (this.bolAutoCommit) {
            SaveLayerFeatureChangesPlugIn.commitLayer(this.ly, false, true, false);
        }
    }

    @Override
    public JPanel getAssistentPanel() {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        valPanel.resetPanel();
        valPanel.setCbo1LabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.draw-constrained-angle"), this.cbo1Listener);
        valPanel.setCbo1Value(this.getUseAngleConstraint());
        valPanel.setCbo2LabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.draw-constrained-length"), this.cbo2Listener);
        valPanel.setCbo2Value(this.getUseLengthConstraint());
        if (this.getUseAngleConstraint()) {
            valPanel.setValueFormat(0);
            valPanel.setValueLabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.angle"), this.valueChangedListener);
            valPanel.setValue(new Double(this.getAngle()));
        }
        if (this.getUseLengthConstraint()) {
            valPanel.setValue1Format(0);
            valPanel.setValue1LabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.length"), this.value1ChangedListener);
            valPanel.setValue1(new Double(this.getLength()));
        }
        valPanel.setLeftButton(I18N.get("common.back"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppendPolygonTool.this.back();
            }
        });
        return valPanel;
    }

    @Override
    public void mouseLocationChanged(MouseEvent e) {
        super.mouseLocationChanged(e);
        try {
            List<Coordinate> lstCoord = this.getCoordinates();
            if (this.isShapeOnScreen() && lstCoord.size() > 0) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(lstCoord);
                currentCoordinates.add(this.getTentativeCoordinate());
                this.display(currentCoordinates);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private void display(List coordinates) throws NoninvertibleTransformException {
        double area = -1.0;
        if (coordinates.size() > 2) {
            ArrayList lstRing = new ArrayList(coordinates);
            lstRing.add(coordinates.get(0));
            LinearRing lring = gfac.createLinearRing(lstRing.toArray(new Coordinate[0]));
            area = gfac.createPolygon(lring, null).getArea();
        } else {
            area = 0.0;
        }
        this.display(area);
    }

    private void display(double area) {
        WorkbenchContext.getFrame().setMemoryMessage("<html><nobr>" + strArea + ": <b color='blue'>" + this.dfArea.format(area) + this.strUnit + "\u00b2</b></nobr></html>");
    }

    private String getTooltipHtml(List coordinates) throws NoninvertibleTransformException {
        double area = -1.0;
        if (coordinates.size() > 2) {
            ArrayList lstRing = new ArrayList(coordinates);
            lstRing.add(coordinates.get(0));
            LinearRing lring = gfac.createLinearRing(lstRing.toArray(new Coordinate[0]));
            area = gfac.createPolygon(lring, null).getArea();
        } else {
            area = 0.0;
        }
        return this.getTooltipHtml(area);
    }

    private String getTooltipHtml(double area) {
        return "<html>" + strArea + ": <b color='blue'>" + this.dfArea.format(area) + this.strUnit + "\u00b2</b></html>";
    }

    @Override
    public void activate(LayerViewPanel panel) {
        super.activate(panel);
        this.unit = panel.getLayerManager().getTask().getDrawingUnit();
        this.strUnit = this.unit.getUnitAbbreviation();
        double dblUnitInMeter = this.unit.getUnitInMeter();
        double dblUnitInCentimeter = dblUnitInMeter * 100.0;
        int intDecPlaces = ("" + (int)dblUnitInCentimeter).length() - 1;
        this.dfArea.setGroupingUsed(false);
        this.dfArea.setMaximumFractionDigits((intDecPlaces - 1) * 2);
    }
}

