/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.AppendPointPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.RotateSelectedItemPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.RotateSymbolAndTextTool;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.jts.JTSSupport;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;

public class AppendPointTool
extends NClickTool {
    private Layer ly = null;
    private SimpleFeature f = null;
    private boolean bolAutoCommit = false;
    private AppendPointPanel editPointPanel = null;

    public AppendPointTool(Layer _ly, SimpleFeature _f) {
        super(1);
        this.ly = _ly;
        this.f = _f;
        this.allowSnapping();
        this.editPointPanel = new AppendPointPanel(this.ly);
    }

    public void setAutoCommit(boolean _bolAutoCommit) {
        this.bolAutoCommit = _bolAutoCommit;
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.DrawPointTool.name");
    }

    @Override
    public Cursor createCursor() {
        return FeatureDrawingUtil.createEditCursor();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_add_point.svg");
    }

    @Override
    protected void gestureFinished() throws Exception {
        Point point = this.getPoint();
        Object objGeom = this.f.getDefaultGeometry();
        Object geom = null;
        geom = objGeom == null ? point : JTSSupport.mergeGeom((Geometry)((Geometry)objGeom), (Geometry)point);
        this.f = FeatureUtil.cloneFeature((SimpleFeature)this.f);
        List<SimpleFeature> features = Arrays.asList(this.f);
        EditTransaction transaction = new EditTransaction(features, this.getName(), this.ly, this.isRollingBackInvalidEdits(), false, this.getPanel());
        transaction.setGeometry(0, (Geometry)geom);
        transaction.commit();
        if (this.editPointPanel.isSetRotationSelected()) {
            this.getPanel().getSelectionManager().clear();
            this.getPanel().getSelectionManager().getFeatureSelection().selectItems(this.ly, features);
            EditingPanel.instanceOf().activatePanel(RotateSelectedItemPanel.instanceOf());
            RotateSelectedItemPanel.instanceOf().activateRotateSymbolAndTextTool(this.getPanel());
            if (this.editPointPanel.isSetRotationPointSelected()) {
                java.awt.Point pt = this.getPanel().getLastClickedPoint();
                this.getPanel().dispatchEvent(new MouseEvent(this.getPanel(), 501, System.currentTimeMillis(), 0, pt.x, pt.y, 1, false, 1));
            }
            AbstractCursorTool.Listener listener = new AbstractCursorTool.Listener(){

                @Override
                public void gestureFinished() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.doSomething();
                        }
                    });
                }

                @Override
                public void gestureCanceled() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.doSomething();
                        }
                    });
                }

                private void doSomething() {
                    if (AppendPointTool.this.bolAutoCommit) {
                        SaveLayerFeatureChangesPlugIn.commitLayer(AppendPointTool.this.ly, false, true, false);
                    }
                    RotateSymbolAndTextTool.getInstance().remove(this);
                    WorkbenchContext.getInstance().getLayerViewPanel().setCurrentCursorTool(QuasimodeTool.addStandardQuasimodes(AppendPointTool.this));
                    WorkbenchContext.getInstance().getLayerViewPanel().requestFocus();
                }
            };
            RotateSymbolAndTextTool.getInstance().add(listener);
        } else if (this.bolAutoCommit) {
            SaveLayerFeatureChangesPlugIn.commitLayer(this.ly, false, true, false);
        }
    }

    protected Point getPoint() throws NoninvertibleTransformException {
        return new GeometryFactory().createPoint(this.getCoordinates().get(0));
    }

    @Override
    public JPanel getAssistentPanel() {
        return this.editPointPanel;
    }
}

