/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckable;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditPointPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendPointPanel
extends JPanel
implements EnableCheckable {
    private static final Logger LOG = LoggerFactory.getLogger(AppendPointPanel.class);
    public static final EnableCheck chkLyUseSymbolOrientation = new EnableCheck(){

        @Override
        public String check(JComponent component) {
            Layer layer = ((AppendPointPanel)component).getLayer();
            if (layer == null || layer.getFMD() == null || layer instanceof DimLayer) {
                return "No editable layer";
            }
            if (layer.getFMD().getOriAtt() == null || layer.getFMD().getOriAtt().isEmpty()) {
                return "No symbol orientation";
            }
            return null;
        }
    };
    public static final EnableCheck chkLyUseLabelOrientation = new EnableCheck(){

        @Override
        public String check(JComponent component) {
            Layer layer = ((AppendPointPanel)component).getLayer();
            if (layer == null || layer.getFMD() == null || layer instanceof DimLayer) {
                return "No editable layer";
            }
            if (!layer.getFMD().getUseText()) {
                return "Labeling disabled.";
            }
            if (layer.getFMD().getTextOriAtt() == null || layer.getFMD().getTextOriAtt().isEmpty()) {
                return "No label orientation";
            }
            return null;
        }
    };
    private final ToolboxPanel pnlToolbox = new ToolboxPanel();
    private Layer ly = null;
    private JCheckBox cbSetRotation;
    private JCheckBox cbSetRotationPoint;
    private JPanel pnlTools;

    protected AppendPointPanel(Layer ly) {
        this.ly = ly;
        this.initComponents();
        this.i18n();
        this.init();
    }

    public final void i18n() {
        this.cbSetRotation.setText(I18N.get("ui.cursortool.editing.EditPointPanel.set-rotation"));
        this.cbSetRotationPoint.setText(I18N.get("ui.cursortool.editing.EditPointPanel.set-rotation-point"));
    }

    public final void init() {
        this.pnlTools.add((Component)this.pnlToolbox, "Center");
        Boolean boolSetRotation = PersistentBlackboardPlugIn.get().getBoolean(EditPointPanel.KEY_SET_ROTATION);
        if (boolSetRotation != null) {
            this.cbSetRotation.setSelected(boolSetRotation);
            this.cbSetRotationPoint.setEnabled(this.cbSetRotation.isEnabled() && boolSetRotation != false);
        }
        this.cbSetRotation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                PersistentBlackboardPlugIn.get().put(EditPointPanel.KEY_SET_ROTATION, selected);
                AppendPointPanel.this.cbSetRotationPoint.setEnabled(selected);
            }
        });
        Boolean boolSetRotationPoint = PersistentBlackboardPlugIn.get().getBoolean(EditPointPanel.KEY_SET_ROTATION_POINT);
        if (boolSetRotationPoint != null) {
            this.cbSetRotationPoint.setSelected(boolSetRotationPoint);
        }
        this.cbSetRotationPoint.addItemListener(new ItemListener(this){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                PersistentBlackboardPlugIn.get().put(EditPointPanel.KEY_SET_ROTATION_POINT, selected);
            }
        });
    }

    @Override
    public void updateEnabledState() {
        this.cbSetRotation.setEnabled(chkLyUseSymbolOrientation.check(this) == null || chkLyUseLabelOrientation.check(this) == null);
        this.cbSetRotationPoint.setEnabled(this.cbSetRotation.isEnabled() && this.cbSetRotation.isSelected());
        this.pnlToolbox.updateEnabledState();
    }

    public boolean isSetRotationSelected() {
        return this.cbSetRotation.isEnabled() && this.cbSetRotation.isSelected();
    }

    public boolean isSetRotationPointSelected() {
        return this.cbSetRotationPoint.isEnabled() && this.cbSetRotationPoint.isSelected();
    }

    public Layer getLayer() {
        return this.ly;
    }

    private void initComponents() {
        this.pnlTools = new JPanel();
        this.cbSetRotation = new JCheckBox();
        this.cbSetRotationPoint = new JCheckBox();
        this.setEnabled(false);
        this.setPreferredSize(new Dimension(180, 200));
        this.setLayout(new GridBagLayout());
        this.pnlTools.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlTools, gridBagConstraints);
        this.cbSetRotation.setText("Drehung erfassen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbSetRotation, gridBagConstraints);
        this.cbSetRotationPoint.setText("Drehpunkt automatisch setzen");
        this.cbSetRotationPoint.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cbSetRotationPoint, gridBagConstraints);
    }
}

