/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.GetValuePanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.jts.JTSSupport;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.opengis.feature.simple.SimpleFeature;

public class AppendLineStringTool
extends MultiClickTool {
    private static final String strDist = I18N.get("ui.cursortool.MeasureTool.dist");
    private DrawingUnit unit = null;
    private final DecimalFormat dfLength = new DecimalFormat();
    private String strUnit = "";
    private final KeyListener klstEnter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 10) {
                try {
                    AppendLineStringTool.this.finishGesture();
                }
                catch (Exception e1) {
                    WorkbenchContext.getFrame().handleThrowable(e1);
                }
            }
        }
    };
    private final ActionListener valueChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AppendLineStringTool.this.setAngle((Double)GetValuePanel.instanceOf().getValue());
            }
            catch (Throwable t) {
                AppendLineStringTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };
    private final ActionListener value1ChangedListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AppendLineStringTool.this.setLength((Double)GetValuePanel.instanceOf().getValue1());
            }
            catch (Throwable t) {
                AppendLineStringTool.this.getPanel().getContext().handleThrowable(t);
            }
        }
    };
    private final ActionListener cbo1Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GetValuePanel valPanel = GetValuePanel.instanceOf();
            AppendLineStringTool.this.setUseAngleConstraint(valPanel.getCbo1Value());
            AppendLineStringTool.this.getAssistentPanel();
        }
    };
    private final ActionListener cbo2Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            GetValuePanel valPanel = GetValuePanel.instanceOf();
            AppendLineStringTool.this.setUseLengthConstraint(valPanel.getCbo2Value());
            AppendLineStringTool.this.getAssistentPanel();
        }
    };
    private Layer ly = null;
    private SimpleFeature f = null;
    private boolean bolAutoCommit = false;

    public AppendLineStringTool(Layer _ly, SimpleFeature _f) {
        this.ly = _ly;
        this.f = _f;
        this.allowSnapping();
    }

    public void setAutoCommit(boolean _bolAutoCommit) {
        this.bolAutoCommit = _bolAutoCommit;
    }

    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.DrawLineString.draw-linestring");
    }

    @Override
    public boolean useTooltip() {
        return true;
    }

    @Override
    public String getTooltip(Point2D mouseLocation) {
        try {
            ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
            currentCoordinates.add(this.getTentativeCoordinate());
            return this.getTooltipHtml(currentCoordinates);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Cursor createCursor() {
        return FeatureDrawingUtil.createEditCursor();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_add_line.svg");
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (!this.checkLineString()) {
            return;
        }
        LineString line = this.getLineString();
        Object objGeom = this.f.getDefaultGeometry();
        Object geom = null;
        geom = objGeom == null ? line : JTSSupport.mergeGeom((Geometry)((Geometry)objGeom), (Geometry)line);
        this.f = FeatureUtil.cloneFeature((SimpleFeature)this.f);
        EditTransaction transaction = new EditTransaction(Arrays.asList(this.f), this.getName(), this.ly, this.isRollingBackInvalidEdits(), false, this.getPanel());
        transaction.setGeometry(0, (Geometry)geom);
        transaction.commit();
        if (this.bolAutoCommit) {
            SaveLayerFeatureChangesPlugIn.commitLayer(this.ly, false, true, false);
        }
    }

    protected LineString getLineString() throws NoninvertibleTransformException {
        return new GeometryFactory().createLineString(AppendLineStringTool.toArray(this.getCoordinates()));
    }

    protected boolean checkLineString() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 2) {
            this.getPanel().getContext().warnUser(I18N.get("ui.cursortool.editing.DrawLineString.the-linestring-must-have-at-least-2-points"));
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getLineString());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public JPanel getAssistentPanel() {
        GetValuePanel valPanel = GetValuePanel.instanceOf();
        valPanel.resetPanel();
        valPanel.setCbo1LabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.draw-constrained-angle"), this.cbo1Listener);
        valPanel.setCbo1Value(this.getUseAngleConstraint());
        valPanel.setCbo2LabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.draw-constrained-length"), this.cbo2Listener);
        valPanel.setCbo2Value(this.getUseLengthConstraint());
        if (this.getUseAngleConstraint()) {
            valPanel.setValueFormat(0);
            valPanel.setValueLabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.angle"), this.valueChangedListener);
            valPanel.setValue(new Double(this.getAngle()));
        }
        if (this.getUseLengthConstraint()) {
            valPanel.setValue1Format(0);
            valPanel.setValue1LabelListener(I18N.get("ui.cursortool.editing.DrawPolygonTool.length"), this.value1ChangedListener);
            valPanel.setValue1(new Double(this.getLength()));
        }
        valPanel.setLeftButton(I18N.get("common.back"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppendLineStringTool.this.back();
            }
        });
        return valPanel;
    }

    @Override
    public void mouseLocationChanged(MouseEvent e) {
        super.mouseLocationChanged(e);
        try {
            List<Coordinate> lstCoord = this.getCoordinates();
            if (this.isShapeOnScreen() && lstCoord.size() > 0) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(lstCoord);
                currentCoordinates.add(this.getTentativeCoordinate());
                this.display(currentCoordinates);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private double distance(List coordinates) {
        double distance = 0.0;
        for (int i = 1; i < coordinates.size(); ++i) {
            distance += ((Coordinate)coordinates.get(i - 1)).distance((Coordinate)coordinates.get(i));
        }
        return distance;
    }

    private void display(List coordinates) throws NoninvertibleTransformException {
        ArrayList lstLastCoords = new ArrayList();
        lstLastCoords.add(coordinates.get(coordinates.size() - 2));
        lstLastCoords.add(coordinates.get(coordinates.size() - 1));
        this.display(this.distance(coordinates), this.distance(lstLastCoords));
    }

    private void display(double distance, double lastDistance) {
        WorkbenchContext.getFrame().setMemoryMessage("<html><nobr>" + strDist + ": <b color='blue'>" + this.dfLength.format(distance) + this.strUnit + " / " + this.dfLength.format(lastDistance) + this.strUnit + "</b></nobr></html>");
    }

    private String getTooltipHtml(List coordinates) throws NoninvertibleTransformException {
        ArrayList lstLastCoords = new ArrayList();
        lstLastCoords.add(coordinates.get(coordinates.size() - 2));
        lstLastCoords.add(coordinates.get(coordinates.size() - 1));
        return this.getTooltipHtml(this.distance(coordinates), this.distance(lstLastCoords));
    }

    private String getTooltipHtml(double distance, double lastDistance) {
        return "<html>" + strDist + ": <b color='blue'>" + this.dfLength.format(distance) + this.strUnit + " / " + this.dfLength.format(lastDistance) + this.strUnit + "</b></html>";
    }

    @Override
    public void activate(LayerViewPanel panel) {
        super.activate(panel);
        this.unit = panel.getLayerManager().getTask().getDrawingUnit();
        this.strUnit = this.unit.getUnitAbbreviation();
        double dblUnitInMeter = this.unit.getUnitInMeter();
        double dblUnitInCentimeter = dblUnitInMeter * 100.0;
        int intDecPlaces = ("" + (int)dblUnitInCentimeter).length() - 1;
    }

    @Override
    public KeyListener getKeyListener() {
        return this.klstEnter;
    }
}

