/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.AppendLineStringTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.AppendPointTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.AppendPolygonTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.SaveLayerFeatureChangesPlugIn;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.jts.JTSSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;

public class AddFeatureGeomDialog
extends JDialog {
    private Layer layer = null;
    private String strFID = null;
    private SimpleFeature f = null;
    private boolean bolAutoCommit = false;
    private boolean blockEvents = false;
    private boolean featureIsNotPersistedYet = false;
    private JButton butCancel;
    private JButton butDeleteGeometry;
    private JButton butLine;
    private JButton butPoint;
    private JButton butPolygon;
    private JButton butUseSelection;
    private JComboBox cmbTheme;
    private JLabel lblFid;
    private JLabel lblHeader;
    private JLabel lblLayer;
    private JLabel lblTheme;

    public AddFeatureGeomDialog(Frame parent, Layer _layer, String _strFID, boolean _bolAutoCommit) {
        super(parent, false);
        this.initComponents();
        this.i18n();
        this.layer = _layer;
        this.strFID = _strFID;
        this.bolAutoCommit = _bolAutoCommit;
        this.init();
    }

    public AddFeatureGeomDialog(Frame parent, Layer _layer, SimpleFeature _feature, boolean _bolAutoCommit, boolean _featureIsNotPersistedYet) {
        super(parent, false);
        this.initComponents();
        this.i18n();
        this.layer = _layer;
        this.f = _feature;
        this.strFID = this.f.getID();
        this.bolAutoCommit = _bolAutoCommit;
        this.featureIsNotPersistedYet = _featureIsNotPersistedYet;
        this.init();
    }

    public void setAutoCommit(boolean _bolAutoCommit) {
        this.bolAutoCommit = _bolAutoCommit;
    }

    private void i18n() {
        this.lblHeader.setText(I18N.get("ui.cursortool.editing.AddFeatureGeomDialog.header"));
        this.butPoint.setText(I18N.get("ui.cursortool.editing.AddFeatureGeomDialog.point"));
        this.butLine.setText(I18N.get("ui.cursortool.editing.AddFeatureGeomDialog.line"));
        this.butPolygon.setText(I18N.get("ui.cursortool.editing.AddFeatureGeomDialog.polygon"));
        this.butUseSelection.setText(I18N.get("ui.cursortool.editing.AddFeatureGeomDialog.use-selection"));
        this.butDeleteGeometry.setText(I18N.get("ui.cursortool.editing.AddFeatureGeomDialog.delete-geometry"));
        this.butDeleteGeometry.setToolTipText(I18N.get("ui.cursortool.editing.AddFeatureGeomDialog.delete-geometry-tooltip"));
        this.butCancel.setText(I18N.get("common.close"));
        this.lblTheme.setText(I18N.get("common.theme"));
        this.setTitle(I18N.get("ui.cursortool.editing.AddFeatureGeomDialog.title"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.setLocation(this.getParent().getLocation().x + 10, this.getParent().getLocation().y + 100);
        this.blockEvents = true;
        try {
            this.butUseSelection.setIcon(IconLoader.svgIcon((String)"geometry_use_selection.svg"));
            this.butDeleteGeometry.setIcon(IconLoader.svgIcon((String)"geometry_remove.svg"));
            this.lblLayer.setText(this.layer.getName());
            this.lblFid.setText(I18N.get("common.feature") + ": " + (this.f == null ? this.strFID : this.f.getID()));
            if (!this.layer.isEditable()) {
                GUISupport.msgbox((Component)this, (String)I18N.get("ui.cursortool.editing.AddFeatureGeomDialog.layer-not-editable"), (String)I18N.get("common.error"));
                this.setVisible(false);
            }
            if (this.layer instanceof CadLayer) {
                CadLayer cly = (CadLayer)this.layer;
                List<CadLayer.InternalLayer> lstIntLayers = cly.getInternalLayers();
                this.cmbTheme.removeAllItems();
                for (CadLayer.InternalLayer intLy : lstIntLayers) {
                    this.cmbTheme.addItem(intLy);
                }
                if (this.renewFeature()) {
                    this.cmbTheme.setSelectedItem(CadLayer.internalLayer4Feature(this.f));
                }
            } else {
                this.lblTheme.setVisible(false);
                this.cmbTheme.setVisible(false);
            }
            if (this.layer instanceof RedlineLayer) {
                this.butDeleteGeometry.setVisible(false);
            }
            int count = 0;
            if (this.layer.getFMD().getRestrictGeomType()) {
                Class<?>[] arrTypes;
                this.butPoint.setVisible(false);
                this.butLine.setVisible(false);
                this.butPolygon.setVisible(false);
                for (Class<?> arrType : arrTypes = this.layer.getFMD().getGeomTypes()) {
                    if (arrType.equals(Point.class) || arrType.equals(MultiPoint.class)) {
                        this.butPoint.setVisible(true);
                        ++count;
                    }
                    if (arrType.equals(LineString.class) || arrType.equals(MultiLineString.class)) {
                        this.butLine.setVisible(true);
                        count += 3;
                    }
                    if (!arrType.equals(Polygon.class) && !arrType.equals(MultiPolygon.class)) continue;
                    this.butPolygon.setVisible(true);
                    count += 7;
                }
            }
            this.pack();
            if (!this.renewFeature()) {
                this.setVisible(false);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AddFeatureGeomDialog.this.butPoint.isVisible()) {
                            AddFeatureGeomDialog.this.butPoint_onActionPerformed(null);
                        } else if (AddFeatureGeomDialog.this.butLine.isVisible()) {
                            AddFeatureGeomDialog.this.butLine_onActionPerformed(null);
                        } else if (AddFeatureGeomDialog.this.butPolygon.isVisible()) {
                            AddFeatureGeomDialog.this.butPolygon_onActionPerformed(null);
                        } else {
                            WorkbenchContext.getFrame().activateDefaultCT();
                        }
                    }
                });
                this.setVisible(true);
            }
        }
        finally {
            this.blockEvents = false;
        }
    }

    private boolean renewFeature() {
        try {
            this.f = this.featureIsNotPersistedYet ? this.layer.getFeatureAddedByKey(this.f.getID()) : this.layer.getFeatureByKey(this.strFID);
            if (this.f == null) {
                GUISupport.msgbox((Component)this, (String)I18N.get("ui.cursortool.editing.AddFeatureGeomDialog.feature-not-found"), (String)I18N.get("common.error"));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)I18N.get("common.error"));
            return false;
        }
    }

    private void initComponents() {
        this.lblHeader = new JLabel();
        this.lblFid = new JLabel();
        this.butPoint = new JButton();
        this.butLine = new JButton();
        this.butPolygon = new JButton();
        this.butCancel = new JButton();
        this.lblLayer = new JLabel();
        this.butUseSelection = new JButton();
        this.butDeleteGeometry = new JButton();
        this.lblTheme = new JLabel();
        this.cmbTheme = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(230, 214));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                AddFeatureGeomDialog.this.this_onWindowClosed(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblHeader.setText("Geometrie zu Feature hinzuf\u00fcgen:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.getContentPane().add((Component)this.lblHeader, gridBagConstraints);
        this.lblFid.setFont(this.lblFid.getFont().deriveFont(this.lblFid.getFont().getStyle() | 1));
        this.lblFid.setText("Element: 25");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.lblFid, gridBagConstraints);
        this.butPoint.setIcon(IconLoader.svgIcon((String)"geometry_add_point.svg"));
        this.butPoint.setText("Punkt");
        this.butPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddFeatureGeomDialog.this.butPoint_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.butPoint, gridBagConstraints);
        this.butLine.setIcon(IconLoader.svgIcon((String)"geometry_add_line.svg"));
        this.butLine.setText("Linie");
        this.butLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddFeatureGeomDialog.this.butLine_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.butLine, gridBagConstraints);
        this.butPolygon.setIcon(IconLoader.svgIcon((String)"geometry_add_polygon.svg"));
        this.butPolygon.setText("Polygon");
        this.butPolygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddFeatureGeomDialog.this.butPolygon_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.butPolygon, gridBagConstraints);
        this.butCancel.setText("abbrechen");
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddFeatureGeomDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.getContentPane().add((Component)this.butCancel, gridBagConstraints);
        this.lblLayer.setFont(this.lblLayer.getFont().deriveFont(this.lblLayer.getFont().getStyle() | 1));
        this.lblLayer.setText("Ebene");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 9, 3, 9);
        this.getContentPane().add((Component)this.lblLayer, gridBagConstraints);
        this.butUseSelection.setText("Auswahl verwenden");
        this.butUseSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddFeatureGeomDialog.this.butUseSelection_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.butUseSelection, gridBagConstraints);
        this.butDeleteGeometry.setText("Geometrie l\u00f6schen");
        this.butDeleteGeometry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddFeatureGeomDialog.this.butDeleteGeometry_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.getContentPane().add((Component)this.butDeleteGeometry, gridBagConstraints);
        this.lblTheme.setText("Thema");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.lblTheme, gridBagConstraints);
        this.cmbTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddFeatureGeomDialog.this.cmbTheme_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.cmbTheme, gridBagConstraints);
        this.pack();
    }

    private void butPoint_onActionPerformed(ActionEvent evt) {
        if (this.bolAutoCommit && this.layer.hasUncommitedData()) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("de.riwagis.gis.context.jump.VectorLayerContextImpl.uncommited-features"), (String)I18N.get("common.message"));
            return;
        }
        if (!this.renewFeature()) {
            return;
        }
        AppendPointTool appPointTool = new AppendPointTool(this.layer, this.f);
        if (this.bolAutoCommit) {
            appPointTool.setAutoCommit(true);
        }
        WorkbenchContext.getInstance().getLayerViewPanel().setCurrentCursorTool(QuasimodeTool.addStandardQuasimodes(appPointTool));
        WorkbenchContext.getInstance().getLayerViewPanel().requestFocus();
    }

    private void butLine_onActionPerformed(ActionEvent evt) {
        if (this.bolAutoCommit && this.layer.hasUncommitedData()) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("de.riwagis.gis.context.jump.VectorLayerContextImpl.uncommited-features"), (String)I18N.get("common.message"));
            return;
        }
        if (!this.renewFeature()) {
            return;
        }
        AppendLineStringTool appLineStringTool = new AppendLineStringTool(this.layer, this.f);
        if (this.bolAutoCommit) {
            appLineStringTool.setAutoCommit(true);
        }
        WorkbenchContext.getInstance().getLayerViewPanel().setCurrentCursorTool(QuasimodeTool.addStandardQuasimodes(appLineStringTool));
        WorkbenchContext.getInstance().getLayerViewPanel().requestFocus();
    }

    private void butPolygon_onActionPerformed(ActionEvent evt) {
        if (this.bolAutoCommit && this.layer.hasUncommitedData()) {
            GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("de.riwagis.gis.context.jump.VectorLayerContextImpl.uncommited-features"), (String)I18N.get("common.message"));
            return;
        }
        if (!this.renewFeature()) {
            return;
        }
        AppendPolygonTool appPolygonTool = new AppendPolygonTool(this.layer, this.f);
        if (this.bolAutoCommit) {
            appPolygonTool.setAutoCommit(true);
        }
        WorkbenchContext.getInstance().getLayerViewPanel().setCurrentCursorTool(QuasimodeTool.addStandardQuasimodes(appPolygonTool));
        WorkbenchContext.getInstance().getLayerViewPanel().requestFocus();
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        EditingPanel.instanceOf().activateDefaultCT();
        this.setVisible(false);
    }

    private void this_onWindowClosed(WindowEvent evt) {
        EditingPanel.instanceOf().activateDefaultCT();
    }

    private void butUseSelection_onActionPerformed(ActionEvent evt) {
        try {
            if (this.bolAutoCommit && this.layer.hasUncommitedData()) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("de.riwagis.gis.context.jump.VectorLayerContextImpl.uncommited-features"), (String)I18N.get("common.message"));
                return;
            }
            if (!this.renewFeature()) {
                return;
            }
            LayerViewPanel lvPanel = WorkbenchContext.getInstance().getLayerViewPanel();
            Collection<Geometry> col = lvPanel.getSelectionManager().getSelectedItems();
            Iterator<Geometry> i = col.iterator();
            Geometry geom = null;
            while (i.hasNext()) {
                Geometry g = i.next();
                if (g == null || g.isEmpty()) continue;
                if (geom == null) {
                    geom = g;
                    continue;
                }
                geom = JTSSupport.mergeGeom((Geometry)geom, (Geometry)g);
            }
            if (geom != null) {
                Object objGeom = this.f.getDefaultGeometry();
                Geometry fgeom = null;
                fgeom = objGeom == null ? geom : JTSSupport.mergeGeom((Geometry)((Geometry)objGeom), (Geometry)geom);
                EditTransaction transaction = new EditTransaction(Arrays.asList(FeatureUtil.cloneFeature((SimpleFeature)this.f)), this.getName(), this.layer, true, false, lvPanel);
                transaction.setGeometry(0, fgeom);
                transaction.commit();
                if (this.bolAutoCommit) {
                    SaveLayerFeatureChangesPlugIn.commitLayer(this.layer, false, true, false);
                }
                EditingPanel.instanceOf().activateDefaultCT();
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)WorkbenchContext.getFrame(), (Throwable)e, (String)I18N.get("common.error"));
        }
    }

    private void butDeleteGeometry_onActionPerformed(ActionEvent evt) {
        try {
            if (this.bolAutoCommit && this.layer.hasUncommitedData()) {
                GUISupport.msgbox((Component)WorkbenchContext.getFrame(), (String)I18N.get("de.riwagis.gis.context.jump.VectorLayerContextImpl.uncommited-features"), (String)I18N.get("common.message"));
                return;
            }
            if (!this.renewFeature()) {
                return;
            }
            LayerViewPanel lvPanel = WorkbenchContext.getInstance().getLayerViewPanel();
            EditTransaction transaction = new EditTransaction(Arrays.asList(FeatureUtil.cloneFeature((SimpleFeature)this.f)), this.getName(), this.layer, true, false, lvPanel);
            transaction.setGeometry(0, null);
            transaction.commit();
            if (this.bolAutoCommit) {
                SaveLayerFeatureChangesPlugIn.commitLayer(this.layer, false, true, false);
            }
            EditingPanel.instanceOf().activateDefaultCT();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)WorkbenchContext.getFrame(), (Throwable)e, (String)I18N.get("common.error"));
        }
    }

    private void cmbTheme_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.layer instanceof CadLayer) {
            if (!this.renewFeature()) {
                return;
            }
            CadLayer.InternalLayer intLay = (CadLayer.InternalLayer)this.cmbTheme.getSelectedItem();
            SimpleFeature newf = FeatureUtil.cloneFeature((SimpleFeature)this.f, (boolean)false);
            CadLayer.setInternalLayer2Feature(newf, intLay);
            LayerViewPanel lvPanel = WorkbenchContext.getInstance().getLayerViewPanel();
            EditTransaction transaction = new EditTransaction(Arrays.asList(newf), this.getName(), this.layer, true, false, lvPanel);
            transaction.commit();
            if (this.bolAutoCommit) {
                SaveLayerFeatureChangesPlugIn.commitLayer(this.layer, false, true, false);
            }
        }
    }
}

