/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.algorithm.LengthSubstring;
import com.vividsolutions.jump.algorithm.LengthToPoint;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.Animations;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;

public class SplitLineStringsOp {
    private final Color colour;
    private final Collection<Split> splits = new ArrayList<Split>();

    public SplitLineStringsOp addSplit(SimpleFeature feature, Coordinate target, Layer layer, boolean moveSplitToTarget) {
        this.splits.add(new Split(feature, this.split((LineString)feature.getDefaultGeometry(), target, moveSplitToTarget), layer));
        return this;
    }

    public SplitLineStringsOp(Color colour) {
        this.colour = colour;
    }

    public void execute(String name, boolean rollingBackInvalidEdits, LayerViewPanel panel) {
        this.execute(this.splits, name, rollingBackInvalidEdits, panel);
    }

    private void assertIndependent(Collection<Split> splits) {
        ArrayList<Split> splitsEncountered = new ArrayList<Split>();
        for (Split split : splits) {
            Assert.isTrue((!splitsEncountered.contains(split) ? 1 : 0) != 0);
            splitsEncountered.add(split);
        }
    }

    private EditTransaction transaction(final Split split, final String name, boolean rollingBackInvalidEdits, LayerViewPanel panel) {
        final SelectionManager selectionManager = panel.getSelectionManager();
        EditTransaction transaction = new EditTransaction(this, Collections.emptyList(), name, split.layer, rollingBackInvalidEdits, true, panel){

            @Override
            protected UndoableCommand createInternalCommand() {
                final UndoableCommand command = super.createInternalCommand();
                return new UndoableCommand(name){

                    @Override
                    public void execute() {
                        boolean oldFeatureWasSelected = selectionManager.getFeaturesWithSelectedItems().contains(split.oldFeature);
                        command.execute();
                        if (oldFeatureWasSelected) {
                            selectionManager.getFeatureSelection().selectItems(split.layer, Arrays.asList(split.newFeatures));
                        }
                    }

                    @Override
                    public void unexecute() {
                        boolean newFeatureWasSelected = selectionManager.getFeaturesWithSelectedItems().contains(split.newFeatures[0]) || selectionManager.getFeaturesWithSelectedItems().contains(split.newFeatures[1]);
                        command.unexecute();
                        if (newFeatureWasSelected) {
                            selectionManager.getFeatureSelection().selectItems(split.layer, Collections.singleton(split.oldFeature));
                        }
                    }
                };
            }
        };
        transaction.deleteFeature(split.oldFeature);
        transaction.createFeature(split.newFeatures[0]);
        transaction.createFeature(split.newFeatures[1]);
        return transaction;
    }

    private void execute(Collection<Split> splits, String name, boolean rollingBackInvalidEdits, LayerViewPanel panel) {
        this.assertIndependent(splits);
        EditTransaction.commit(CollectionUtil.collect(splits, split -> this.transaction((Split)split, name, rollingBackInvalidEdits, panel)), () -> {
            try {
                Animations.drawExpandingRings(new HashSet<Point2D>(CollectionUtil.collect(splits, split -> panel.getViewport().toViewPoint(split.newLineStrings[0].getEndPoint().getCoordinate()))), true, this.colour, panel, new float[]{5.0f, 5.0f});
            }
            catch (Throwable t) {
                panel.getContext().warnUser(t.toString());
            }
        });
    }

    protected LineString[] split(LineString lineString, Coordinate target, boolean moveSplitToTarget) {
        LineString[] lineStrings = new LineString[]{LengthSubstring.getSubstring(lineString, 0.0, LengthToPoint.length(lineString, target)), LengthSubstring.getSubstring(lineString, LengthToPoint.length(lineString, target), lineString.getLength())};
        if (moveSplitToTarget) {
            this.last(lineStrings[0]).setCoordinate(target);
            this.first(lineStrings[1]).setCoordinate(target);
        }
        if (Double.isNaN(this.last(lineStrings[0]).getZ())) {
            this.last(lineStrings[0]).setZ(this.interpolateZ(lineStrings));
        }
        if (Double.isNaN(this.first(lineStrings[1]).getZ())) {
            this.first(lineStrings[1]).setZ(this.interpolateZ(lineStrings));
        }
        return lineStrings;
    }

    private double interpolateZ(LineString[] lineStrings) {
        Coordinate a = this.secondToLast(lineStrings[0]);
        Coordinate b = this.last(lineStrings[0]);
        Coordinate c = this.second(lineStrings[1]);
        if (Double.isNaN(a.getZ())) {
            return Double.NaN;
        }
        if (Double.isNaN(c.getZ())) {
            return Double.NaN;
        }
        return a.getZ() + (c.getZ() - a.getZ()) * a.distance(b) / (a.distance(b) + b.distance(c));
    }

    private Coordinate first(LineString lineString) {
        return lineString.getCoordinateN(0);
    }

    private Coordinate second(LineString lineString) {
        return lineString.getCoordinateN(1);
    }

    private Coordinate last(LineString lineString) {
        return lineString.getCoordinateN(lineString.getNumPoints() - 1);
    }

    private Coordinate secondToLast(LineString lineString) {
        return lineString.getCoordinateN(lineString.getNumPoints() - 2);
    }

    private static class Split {
        private final SimpleFeature[] newFeatures;
        private final SimpleFeature oldFeature;
        private final LineString[] newLineStrings;
        private final Layer layer;

        public Split(SimpleFeature oldFeature, LineString[] newLineStrings, Layer layer) {
            this.oldFeature = oldFeature;
            this.newLineStrings = newLineStrings;
            this.layer = layer;
            this.newFeatures = new SimpleFeature[]{this.clone(oldFeature, newLineStrings[0]), this.clone(oldFeature, newLineStrings[1])};
        }

        private SimpleFeature clone(SimpleFeature feature, LineString lineString) {
            try {
                SimpleFeature clone = FeatureUtil.cloneFeature((SimpleFeature)feature, (boolean)true);
                clone.setDefaultGeometry((Object)lineString);
                return clone;
            }
            catch (IllegalAttributeException e) {
                Assert.shouldNeverReachHere();
                return null;
            }
        }
    }
}

