/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractClickSelectedLineStringsTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SplitLineStringsOp;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import de.riwagis.icons.IconLoader;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.opengis.feature.simple.SimpleFeature;

public class SplitLineStringTool
extends AbstractClickSelectedLineStringsTool {
    Coordinate snapCoord = null;

    @Override
    public String getName() {
        return I18N.get("com.vividsolutions.jump.workbench.ui.cursortool.SplitLineStringTool.Split-LinesStrings");
    }

    @Override
    protected void gestureFinished(Collection<SimpleFeature> nearbyLineStringFeatures) throws NoninvertibleTransformException {
        SimpleFeature closestFeature = this.closest(nearbyLineStringFeatures, this.getModelClickPoint());
        LineString lineString = (LineString)closestFeature.getDefaultGeometry();
        if (List.of(lineString.getStartPoint().getCoordinate(), lineString.getEndPoint().getCoordinate()).contains(DistanceOp.nearestPoints((Geometry)lineString, (Geometry)this.getModelClickPoint())[0])) {
            JUMPWorkbench.getFrame().warnUser("No selected LineStrings here");
            return;
        }
        if (!this.layer(closestFeature, this.layerToSpecifiedFeaturesMap()).isEditable()) {
            this.warnLayerNotEditable(this.layer(closestFeature, this.layerToSpecifiedFeaturesMap()));
            return;
        }
        if (this.snapCoord != null) {
            this.split(closestFeature, this.snapCoord, this.layer(closestFeature, this.layerToSpecifiedFeaturesMap()));
        } else {
            this.split(closestFeature, this.getModelDestination(), this.layer(closestFeature, this.layerToSpecifiedFeaturesMap()));
        }
    }

    private void split(SimpleFeature feature, Coordinate coordinate, Layer layer) {
        new SplitLineStringsOp(Color.blue).addSplit(feature, coordinate, layer, false).execute(this.getName(), this.isRollingBackInvalidEdits(), this.getPanel());
    }

    private SimpleFeature closest(Collection<SimpleFeature> features, Point point) {
        double tol;
        SimpleFeature closestFeature = null;
        this.snapCoord = null;
        double closestDistance = tol = (double)SnapManager.getToleranceInPixels(JUMPWorkbench.getBlackboard()) / this.getPanel().getViewport().getScale();
        for (SimpleFeature feature : features) {
            double distance = ((Geometry)feature.getDefaultGeometry()).distance((Geometry)point);
            if (!(distance < closestDistance)) continue;
            closestFeature = feature;
            closestDistance = distance;
        }
        this.snapCoord = this.getVertexToSnap((Geometry)closestFeature.getDefaultGeometry(), point, tol);
        return closestFeature;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_cut_line.svg");
    }

    @Override
    public Cursor createCursor() {
        return SplitLineStringTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_cut.svg").getImage());
    }

    private Coordinate getVertexToSnap(Geometry g, Point p, double tolerance) {
        Coordinate coord = null;
        if (g instanceof LineString) {
            LineString ls = (LineString)g;
            double minDist = tolerance;
            for (int i = 0; i < ls.getNumPoints(); ++i) {
                Point pT = ls.getPointN(i);
                double dist = pT.distance((Geometry)p);
                if (!(dist < minDist)) continue;
                minDist = dist;
                coord = (Coordinate)pT.getCoordinate().clone();
            }
        }
        return coord;
    }
}

