/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.geom.EnvelopeIntersector;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import de.riwagis.geotools.feature.RenderPointSpec;
import de.riwagis.geotools.feature.RenderType;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpecifyFeaturesTool
extends DragTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpecifyFeaturesTool.class);
    private static final Map<Class<? extends Geometry>, Integer> COMPARATOR_GEOMETRY_TYPE_PRIORITY = Map.of(Point.class, 10, LineString.class, 100, Polygon.class, 1000, MultiPoint.class, 10000, MultiLineString.class, 10005, MultiPolygon.class, 10010, GeometryCollection.class, 10015);

    private static Collection<SimpleFeature> intersectingFeatures(Layer layer, Envelope envelope) {
        return SpecifyFeaturesTool.intersectedRenderings(layer, envelope).map(renderData -> (SimpleFeature)renderData[1]).collect(Collectors.toSet());
    }

    public static Optional<SimpleFeature> getIntersectingFeatureWithHighestPriority(Layer layer, Envelope envelope) {
        return SpecifyFeaturesTool.intersectedRenderings(layer, envelope).min(Comparator.comparingInt(data -> SpecifyFeaturesTool.getPriorityForRenderData(data)).thenComparingInt(data -> SpecifyFeaturesTool.getPriorityForSubGeometries(envelope, data))).map(renderData -> (SimpleFeature)renderData[1]);
    }

    public static int getPriorityForSubGeometries(Envelope envelope, Object[] data) {
        SimpleFeature feature = (SimpleFeature)data[1];
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        if (geometry.getNumGeometries() <= 1) {
            return Integer.MAX_VALUE;
        }
        int minPriority = SpecifyFeaturesTool.getPriorityForFeature(feature.getDefaultGeometry());
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry subGeometry = geometry.getGeometryN(i);
            if (!EnvelopeIntersector.intersects(subGeometry, envelope)) continue;
            minPriority = Math.min(minPriority, SpecifyFeaturesTool.getPriorityForFeature(subGeometry));
        }
        return minPriority;
    }

    public static int getPriorityForRenderData(Object[] data) {
        if (data[0] == null) {
            return SpecifyFeaturesTool.getPriorityForFeature(((SimpleFeature)data[1]).getDefaultGeometry());
        }
        RenderPointSpec renderPointSpec = (RenderPointSpec)data[2];
        if (renderPointSpec == null) {
            return Integer.MAX_VALUE;
        }
        RenderType renderType = renderPointSpec.getRenderType();
        switch (renderType) {
            case SYMBOL: {
                return COMPARATOR_GEOMETRY_TYPE_PRIORITY.get(Point.class);
            }
            case TEXT: {
                return COMPARATOR_GEOMETRY_TYPE_PRIORITY.get(Point.class) - 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    private static Integer getPriorityForFeature(Object defaultGeometry) {
        return COMPARATOR_GEOMETRY_TYPE_PRIORITY.get(defaultGeometry.getClass());
    }

    private static Stream<Object[]> intersectedRenderings(Layer layer, Envelope envelope) {
        try {
            Viewport vp = WorkbenchContext.getInstance().getLayerViewPanel().getViewport();
            Rectangle2D rect = vp.toViewRectangle(envelope);
            return layer.getRenderedIndex(rect).stream().map(renderIndex -> (Object[])renderIndex).filter(arrObj -> SpecifyFeaturesTool.isIntersecting(arrObj, envelope, rect));
        }
        catch (Exception e) {
            log.warn("Error while intersecting features", (Throwable)e);
            return Stream.empty();
        }
    }

    private static boolean isIntersecting(Object[] arrObj, Envelope envelope, Rectangle2D rect) {
        Shape[] arrShp;
        SimpleFeature f = (SimpleFeature)arrObj[1];
        if (arrObj[0] == null) {
            Geometry geom = (Geometry)f.getDefaultGeometry();
            return EnvelopeIntersector.intersects(geom, envelope);
        }
        for (Shape arrShp1 : arrShp = (Shape[])arrObj[0]) {
            if (!arrShp1.intersects(rect)) continue;
            return true;
        }
        return false;
    }

    public static Map<Layer, Collection<SimpleFeature>> layerToSpecifiedFeaturesMap(Collection<Layer> layers, Envelope boxInModelCoordinates) {
        HashMap<Layer, Collection<SimpleFeature>> layerToFeaturesMap = new HashMap<Layer, Collection<SimpleFeature>>();
        for (Layer layer : layers) {
            Collection<SimpleFeature> intersectingFeatures;
            if (!layer.isVisibleOnScreen() || (intersectingFeatures = SpecifyFeaturesTool.intersectingFeatures(layer, boxInModelCoordinates)).isEmpty()) continue;
            layerToFeaturesMap.put(layer, intersectingFeatures);
            if (boxInModelCoordinates.getHeight() != 0.0 || boxInModelCoordinates.getWidth() != 0.0 || layerToFeaturesMap.size() <= 0) continue;
            break;
        }
        return layerToFeaturesMap;
    }

    public static Map<Layer, Collection<SimpleFeature>> firstLayerToSpecifiedFeaturesMap(Collection<Layer> layers, Envelope boxInModelCoordinates, boolean onlySelectableLayerables) {
        HashMap<Layer, Collection<SimpleFeature>> layerToFeaturesMap = new HashMap<Layer, Collection<SimpleFeature>>();
        for (Layer layer : layers) {
            Collection<SimpleFeature> intersectingFeatures;
            if (onlySelectableLayerables && !layer.isSelectable() || !layer.isVisibleOnScreen() || (intersectingFeatures = SpecifyFeaturesTool.intersectingFeatures(layer, boxInModelCoordinates)).isEmpty()) continue;
            layerToFeaturesMap.put(layer, intersectingFeatures);
            if (layerToFeaturesMap.size() <= 0) continue;
            break;
        }
        return layerToFeaturesMap;
    }

    protected Collection<Layer> candidateLayers() {
        return this.getPanel().getLayerManager().getLayers();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            super.mouseClicked(e);
            this.setViewSource(e.getPoint());
            this.setViewDestination(e.getPoint());
            this.fireGestureFinished();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected Map<Layer, Collection<SimpleFeature>> layerToSpecifiedFeaturesMap() {
        return SpecifyFeaturesTool.layerToSpecifiedFeaturesMap(this.candidateLayers(), this.getBoxInModelCoordinates());
    }
}

