/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditAttTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectFeaturesPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.bsh.BshCalculator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.type.Types;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.type.AttributeDescriptor;

public class SetFeaturePropertiesPlugIn
extends AbstractPlugIn {
    @Override
    public String getName() {
        return I18N.get("ui.cursortool.editing.SetFeaturePropertiesPlugIn.name");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"label_set_attributes.svg");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Collection<Layer> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        for (Layer ly : colSelLy) {
            EditAttTransaction trans = this.createTransaction(ly);
            String strOri = ly.getFMD().getOriAtt();
            String strOriTrans = ly.getFMD().getOriTrans();
            if (ly.getFMD().getUseText()) {
                Object objText;
                String strText = ly.getFMD().getTextAtt();
                String strTextOri = ly.getFMD().getTextOriAtt();
                String strTextDXAtt = ly.getFMD().getTextDXAtt();
                String strTextDYAtt = ly.getFMD().getTextDYAtt();
                if (SelectFeaturesPanel.instanceOf().isChanged("txaText") && SelectFeaturesPanel.instanceOf().isTextAttControlsEnabled() && this.containsAtt(ly, strText)) {
                    objText = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strText), (Object)SelectFeaturesPanel.instanceOf().getText());
                    trans.addAttribute(strText, objText);
                }
                if (SelectFeaturesPanel.instanceOf().isChanged("txtOri") && SelectFeaturesPanel.instanceOf().isOriControlsEnabled() && this.containsAtt(ly, strTextOri)) {
                    if (strOriTrans == null || strOriTrans.trim().length() == 0) {
                        Object objOri = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strTextOri), (Object)SelectFeaturesPanel.instanceOf().getOri());
                        trans.addAttribute(strTextOri, objOri);
                    } else {
                        BshCalculator calc = ly.getFMD().getOriTransCalc();
                        calc.setValue(SelectFeaturesPanel.instanceOf().getOri());
                        Object objOri = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strTextOri), (Object)calc.getDouble());
                        trans.addAttribute(strTextOri, objOri);
                    }
                }
                if (SelectFeaturesPanel.instanceOf().isChanged("txtDX") && SelectFeaturesPanel.instanceOf().isDXControlsEnabled() && this.containsAtt(ly, strTextDXAtt)) {
                    objText = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strTextDXAtt), (Object)SelectFeaturesPanel.instanceOf().getDX());
                    trans.addAttribute(strTextDXAtt, objText);
                }
                if (SelectFeaturesPanel.instanceOf().isChanged("txtDY") && SelectFeaturesPanel.instanceOf().isDYControlsEnabled() && this.containsAtt(ly, strTextDYAtt)) {
                    objText = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strTextDYAtt), (Object)SelectFeaturesPanel.instanceOf().getDY());
                    trans.addAttribute(strTextDYAtt, objText);
                }
            }
            if (SelectFeaturesPanel.instanceOf().isChanged("txtOri") && SelectFeaturesPanel.instanceOf().isOriControlsEnabled() && this.containsAtt(ly, strOri)) {
                if (strOriTrans == null || strOriTrans.trim().length() == 0) {
                    Object objOri = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strOri), (Object)SelectFeaturesPanel.instanceOf().getOri());
                    trans.addAttribute(strOri, objOri);
                } else {
                    BshCalculator calc = ly.getFMD().getOriTransCalc();
                    calc.setValue(SelectFeaturesPanel.instanceOf().getOri());
                    Object objOri = Types.parse((AttributeDescriptor)ly.getFeatureType().getDescriptor(strOri), (Object)calc.getDouble());
                    trans.addAttribute(strOri, objOri);
                }
            }
            if ((SelectFeaturesPanel.instanceOf().isChanged("txtX") || SelectFeaturesPanel.instanceOf().isChanged("txtY")) && SelectFeaturesPanel.instanceOf().isCoordinateControlsEnabled()) {
                GeometryFactory gf = new GeometryFactory();
                Point pt = gf.createPoint(new Coordinate(SelectFeaturesPanel.instanceOf().getXCoord(), SelectFeaturesPanel.instanceOf().getYCoord()));
                trans.addAttribute(ly.getFeatureType().getGeometryDescriptor().getLocalName(), pt);
            }
            List<EditAttTransaction> lstTrans = Arrays.asList(trans);
            EditAttTransaction.commit(lstTrans);
        }
        return true;
    }

    private EditAttTransaction createTransaction(Layer layer) {
        return EditAttTransaction.createTransactionOnSelection(WorkbenchContext.getInstance().getLayerViewPanel(), WorkbenchContext.getInstance().getLayerViewPanel().getContext(), this.getName(), layer);
    }

    @Override
    public EnableCheck createEnableCheck() {
        return new MultiEnableCheck().add(EnableCheckFactory.getInstance().createSelectedItemsLayersMustBeEditableCheck()).add(EnableCheckFactory.getInstance().createAtLeastNFeaturesMustBeSelectedCheck(1)).add(EditingPanel.instanceOf().getInternalFrameActiveCheck()).add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                return SelectFeaturesPanel.instanceOf().hasChanges() ? null : "no changes";
            }
        }).add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                Collection<Layer> colSelLy = WorkbenchContext.getInstance().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
                if (colSelLy.isEmpty()) {
                    return "Minimum one feature of one layer should be selected.";
                }
                for (Layer ly : colSelLy) {
                    if (ly.getFMD().getUseText() || !StringUtils.isEmpty((CharSequence)ly.getFMD().getOriAtt())) continue;
                    return "The layers must use labels or symbol orientation.";
                }
                return null;
            }
        });
    }

    private boolean containsAtt(Layer ly, String strText) {
        return StringUtils.isNotEmpty((CharSequence)strText) && ly.getFeatureType().indexOf(strText) > -1;
    }
}

