/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import com.vividsolutions.jump.workbench.ui.selection.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public abstract class SelectTool
extends DragTool {
    protected Cursor cursor = Cursor.getDefaultCursor();
    private int spatialOperation = 0;
    private final KeyListener selectionKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 67) {
                SelectTool.this.spatialOperation = 1;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 67) {
                SelectTool.this.spatialOperation = 0;
            }
        }
    };
    private final String rendererID;
    protected AbstractSelection selection;

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    protected void activateCursorOnPanel(Cursor cursor) {
        this.cursor = cursor;
        if (this.isActive()) {
            this.getPanel().setCursor(this.cursor);
        }
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        this.spatialOperation = 0;
    }

    @Override
    public KeyListener getKeyListener() {
        return this.selectionKeyListener;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            if (this.checkMouseButton(e)) {
                if (e.getClickCount() > 1) {
                    return;
                }
                super.mouseClicked(e);
                this.setViewSource(e.getPoint());
                this.setViewDestination(e.getPoint());
                this.fireGestureFinished();
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        Map<Layer, Collection<SimpleFeature>> layerToFeaturesInFenceMap;
        SelectionManager selectionManager = this.getPanel().getSelectionManager();
        if (!this.wasShiftPressed()) {
            selectionManager.runWithoutUpdates(selectionManager::clear);
        }
        Envelope env = this.getBoxInModelCoordinates();
        Collection<Layer> candidateLayers = this.getCandidateLayers();
        if (this.wasClick()) {
            layerToFeaturesInFenceMap = SpecifyFeaturesTool.firstLayerToSpecifiedFeaturesMap(candidateLayers, env, true);
            if (layerToFeaturesInFenceMap.size() > 0) {
                Iterator<Layer> it = layerToFeaturesInFenceMap.keySet().iterator();
                Layer layer = it.next();
                SpecifyFeaturesTool.getIntersectingFeatureWithHighestPriority(layer, env).ifPresent(feature -> {
                    Collection featureSet = (Collection)layerToFeaturesInFenceMap.get(layer);
                    featureSet.clear();
                    featureSet.add(feature);
                });
            }
        } else {
            layerToFeaturesInFenceMap = SpecifyFeaturesTool.layerToSpecifiedFeaturesMap(candidateLayers, env);
        }
        Set<Layer> layers = layerToFeaturesInFenceMap.keySet();
        for (Layer layer : layers) {
            this.updateLayerSelection(selectionManager, layerToFeaturesInFenceMap, layer);
        }
        selectionManager.updatePanel();
    }

    private void updateLayerSelection(SelectionManager selectionManager, Map<Layer, Collection<SimpleFeature>> layerToFeaturesInFenceMap, Layer layer) {
        selectionManager.runWithoutUpdates(() -> {
            CollectionMap<SimpleFeature, Geometry> featureToItemsToSelectMap = this.featureToItemsInFenceMap((Collection)layerToFeaturesInFenceMap.get(layer), layer, false);
            CollectionMap<SimpleFeature, Geometry> featureToItemsToUnselectMap = this.featureToItemsInFenceMap((Collection)layerToFeaturesInFenceMap.get(layer), layer, true);
            this.selection.selectItems(layer, featureToItemsToSelectMap);
            if (this.wasShiftPressed()) {
                this.selection.unselectItems(layer, featureToItemsToUnselectMap);
            }
        });
    }

    private Collection<Layer> getCandidateLayers() {
        if (!this.selectedLayersOnly()) {
            return this.getPanel().getLayerManager().getLayers();
        }
        Object[] arrLayers = this.getTaskFrame().getLayerNamePanel().getSelectedLayers();
        Arrays.sort(arrLayers);
        ArrayList<Layer> tmpLayers = new ArrayList<Layer>();
        for (int i = arrLayers.length - 1; i >= 0; --i) {
            tmpLayers.add((Layer)arrLayers[i]);
        }
        for (Category cat : this.getTaskFrame().getLayerNamePanel().getSelectedCategories()) {
            for (Layerable objLy : cat.getAllLayerables()) {
                Layer currLayer;
                if (!(objLy instanceof Layer) || tmpLayers.contains(currLayer = (Layer)objLy)) continue;
                tmpLayers.add(currLayer);
            }
        }
        return tmpLayers;
    }

    protected boolean selectedLayersOnly() {
        return this.wasControlPressed();
    }

    protected SelectTool(String rendererID) {
        this.rendererID = rendererID;
    }

    private CollectionMap<SimpleFeature, Geometry> featureToItemsInFenceMap(Collection<SimpleFeature> features, Layer layer, boolean selected) {
        CollectionMap<SimpleFeature, Geometry> featureToSelectedItemsMap = this.selection.getFeatureToSelectedItemCollectionMap(layer);
        CollectionMap<SimpleFeature, Geometry> featureToItemsInFenceMap = new CollectionMap<SimpleFeature, Geometry>();
        for (SimpleFeature feature : features) {
            SimpleFeature selFeature = this.selection.getSelectionFeature(layer, feature);
            Collection<Geometry> selectedItems = featureToSelectedItemsMap.getItems(selFeature);
            Collection<Geometry> itemsToReturn = this.itemsInFence(selFeature);
            if (selected) {
                itemsToReturn.retainAll(selectedItems);
            } else {
                itemsToReturn.removeAll(selectedItems);
            }
            featureToItemsInFenceMap.put(selFeature, itemsToReturn);
        }
        return featureToItemsInFenceMap;
    }

    private Collection<Geometry> itemsInFence(SimpleFeature feature) {
        ArrayList<Geometry> itemsInFence = new ArrayList<Geometry>();
        Geometry fence = EnvelopeUtil.toGeometry(this.getBoxInModelCoordinates());
        for (Geometry selectedItem : this.selection.items((Geometry)feature.getDefaultGeometry())) {
            if (this.spatialOperation == 1) {
                if (selectedItem == null || !fence.contains(selectedItem)) continue;
                itemsInFence.add(selectedItem);
                continue;
            }
            if (!LayerViewPanel.intersects(selectedItem, fence)) continue;
            itemsInFence.add(selectedItem);
        }
        if (this.spatialOperation == 0 && itemsInFence.isEmpty()) {
            return this.selection.items((Geometry)feature.getDefaultGeometry());
        }
        return itemsInFence;
    }

    @Override
    public Icon getIcon() {
        return null;
    }
}

