/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectFeaturesPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.FeatureInfoPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.UrlFeatureInfoPlugIn;
import com.vividsolutions.jump.workbench.ui.selection.SelectionListener;
import de.riwagis.icons.IconLoader;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectFeaturesTool
extends SelectTool {
    public static final String OPEN_URL_ON_DOUBLECLICK = SelectTool.class.getName() + "_OPEN_URL_ON_DOUBLECLICK";
    private static final Logger LOG = LoggerFactory.getLogger(SelectTool.class);
    private static final int DELAYED_CURSORCHANGE = 250;
    private WeakReference<LayerViewPanel> lastActiveViewPanel = new WeakReference<Object>(null);
    private boolean openUrlAtAll = false;
    private Point2D mousePosition = null;
    private final Timer delayedCursorChangeTimer = new Timer(250, e -> {
        CursorTool currentCursorTool = this.getPanel().getCurrentCursorTool();
        if (AbstractCursorTool.getDelegate(currentCursorTool) == this) {
            this.updateCursorByMousePosition();
        }
    });
    private final SelectionListener selectionListener = () -> {
        if (this.isActive()) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((SelectFeaturesPanel)this.getAssistentPanel()).updateControls();
            } else {
                SwingUtilities.invokeLater(() -> ((SelectFeaturesPanel)this.getAssistentPanel()).updateControls());
            }
        }
    };

    public SelectFeaturesTool(boolean openUrl) {
        super("SELECTED_FEATURES");
        this.openUrlAtAll = openUrl;
        this.delayedCursorChangeTimer.setRepeats(false);
    }

    public static EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = new EnableCheckFactory(WorkbenchContext.getInstance());
        return checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"selection_select.svg");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            if (this.checkMouseButton(e)) {
                super.mouseClicked(e);
                this.executePlugins(e);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected void executePlugins(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        PlugIn featureInfoPlugIn = JUMPWorkbench.getBuiltInPlugIn(FeatureInfoPlugIn.class);
        AbstractPlugIn.executePlugin(featureInfoPlugIn, WorkbenchContext.getInstance(), null);
        if (this.isOpenUrlOnDblClickByOptions() && this.openUrlAtAll) {
            PlugIn urlFeatureInfoPlugIn = JUMPWorkbench.getBuiltInPlugIn(UrlFeatureInfoPlugIn.class);
            AbstractPlugIn.executePlugin(urlFeatureInfoPlugIn, WorkbenchContext.getInstance(), null);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        this.mousePosition = e.getPoint();
        if (this.openUrlAtAll && !this.delayedCursorChangeTimer.isRunning()) {
            this.delayedCursorChangeTimer.start();
        }
    }

    private void updateCursorByMousePosition() {
        try {
            if (this.mousePosition == null) {
                return;
            }
            if (!this.isOpenUrlOnDblClickByOptions()) {
                return;
            }
            Coordinate coord = this.getPanel().getViewport().toModelCoordinate(this.mousePosition);
            double envWidth = 2.0 / this.getPanel().getViewport().getScale();
            Envelope env = EnvelopeUtil.expand(new Envelope(coord), envWidth);
            Map<Layer, Collection<SimpleFeature>> layerToSpecifiedFeaturesMap = SpecifyFeaturesTool.firstLayerToSpecifiedFeaturesMap(this.getPanel().getLayerManager().getLayers(), env, true);
            Iterator<Layer> keyIterator = layerToSpecifiedFeaturesMap.keySet().iterator();
            if (keyIterator.hasNext()) {
                Layer ly = keyIterator.next();
                LayerStyleCollection sCol = (LayerStyleCollection)ly.getStyleCollectionByScale(ly.getLayerManager().getScreenScale());
                if (sCol != null && sCol.getBasicStyle() != null && sCol.getBasicStyle().isUseUrl()) {
                    this.cursor = Cursor.getPredefinedCursor(12);
                    if (this.isActive()) {
                        this.getPanel().setCursor(this.cursor);
                    }
                } else {
                    this.activateCursorOnPanel(Cursor.getDefaultCursor());
                }
            } else {
                this.activateCursorOnPanel(Cursor.getDefaultCursor());
            }
        }
        catch (Exception ex) {
            try {
                this.activateCursorOnPanel(Cursor.getDefaultCursor());
            }
            catch (Throwable e) {
                LOG.warn("Could not activate cursor.", e);
            }
            LOG.warn("Error finding out if url link is under mouse position.", (Throwable)ex);
        }
    }

    private boolean isOpenUrlOnDblClickByOptions() {
        return PersistentBlackboardPlugIn.get().get(OPEN_URL_ON_DOUBLECLICK, true);
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        if (this.isActive()) {
            return;
        }
        super.activate(layerViewPanel);
        this.selection = layerViewPanel.getSelectionManager().getFeatureSelection();
        this.updateControlsIfLayerViewPanelWasChanged(layerViewPanel);
        this.getPanel().getSelectionManager().addSelectionListener(this.selectionListener);
    }

    private void updateControlsIfLayerViewPanelWasChanged(LayerViewPanel layerViewPanel) {
        if (!layerViewPanel.equals(this.lastActiveViewPanel.get())) {
            ((SelectFeaturesPanel)this.getAssistentPanel()).updateControls();
            this.lastActiveViewPanel = new WeakReference<LayerViewPanel>(layerViewPanel);
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
    }

    @Override
    public JPanel getAssistentPanel() {
        return SelectFeaturesPanel.instanceOf();
    }
}

