/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckable;
import com.vividsolutions.jump.workbench.ui.CoordinateFieldsDocumentListener;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.cursortool.SetFeaturePropertiesPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyle;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.ExportStyleFactory;
import com.vividsolutions.jump.workbench.ui.selection.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPanel;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.util.gui.GUISupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;

public class SelectFeaturesPanel
extends JPanel
implements EnableCheckable {
    public static final String FIELD_X = "txtX";
    public static final String FIELD_Y = "txtY";
    public static final String FIELD_DX = "txtDX";
    public static final String FIELD_DY = "txtDY";
    public static final String FIELD_ORI = "txtOri";
    public static final String FIELD_TEXT = "txaText";
    private static SelectFeaturesPanel selectPanel = null;
    private ToolboxPanel pnlToolbox = new ToolboxPanel();
    private DecimalFormat df = new DecimalFormat("#,##0.00####");
    private Collection<String> changes = new HashSet<String>();
    private final EnableCheck changeCheck = component -> this.changes.isEmpty() ? "no changes" : null;
    private JScrollPane jScrollPane1;
    private JLabel lblDX;
    private JLabel lblDY;
    private JLabel lblOffset;
    private JLabel lblOri;
    private JLabel lblText;
    private JLabel lblTitle;
    private JLabel lblX;
    private JLabel lblY;
    private JPanel pnlFiller;
    private JPanel pnlTools;
    private JTextArea txaText;
    private JFormattedTextField txtDX;
    private JFormattedTextField txtDY;
    private JFormattedTextField txtOri;
    private JFormattedTextField txtX;
    private JFormattedTextField txtY;

    private SelectFeaturesPanel() {
        this.initComponents();
        this.i18n();
        this.init();
    }

    public static SelectFeaturesPanel instanceOf() {
        if (selectPanel == null) {
            selectPanel = new SelectFeaturesPanel();
        }
        return selectPanel;
    }

    public final void i18n() {
        this.lblTitle.setText(I18N.get("ui.cursortool.editing.SelectFeaturesPanel.title"));
        this.lblOri.setText(I18N.get("ui.cursortool.editing.label.EditingLabelPanel.ori"));
        this.lblText.setText(I18N.get("ui.cursortool.editing.label.EditingLabelPanel.text"));
        this.lblY.setText(I18N.get("ui.cursortool.editing.EditPointPanel.X"));
        this.lblX.setText(I18N.get("ui.cursortool.editing.EditPointPanel.Y"));
        this.lblOffset.setText(I18N.get("ui.cursortool.editing.SelectFeaturesPanel.offset"));
        this.lblDY.setText(I18N.get("ui.cursortool.editing.SelectFeaturesPanel.dx"));
        this.lblDX.setText(I18N.get("ui.cursortool.editing.SelectFeaturesPanel.dy"));
    }

    public final void init() {
        this.pnlTools.add((Component)this.pnlToolbox, "Center");
        SetFeaturePropertiesPlugIn sfpPlugIn = new SetFeaturePropertiesPlugIn();
        this.pnlToolbox.addPlugIn(sfpPlugIn, sfpPlugIn.createEnableCheck(), sfpPlugIn.getIcon());
        GUISupport.addCopyInsertPopup((JTextComponent)this.txaText);
        GUISupport.addCopyInsertPopup((JTextComponent)this.txtOri);
        GUISupport.addCopyInsertPopup((JTextComponent)this.txtX);
        GUISupport.addCopyInsertPopup((JTextComponent)this.txtY);
        GUISupport.addCopyInsertPopup((JTextComponent)this.txtDX);
        GUISupport.addCopyInsertPopup((JTextComponent)this.txtDY);
        this.txtX.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtY.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtX.setHorizontalAlignment(4);
        this.txtY.setHorizontalAlignment(4);
        this.txtX.getDocument().addDocumentListener(new CoordinateFieldsDocumentListener(this.txtX, this.txtX, this.txtY));
        this.txtY.getDocument().addDocumentListener(new CoordinateFieldsDocumentListener(this.txtY, this.txtX, this.txtY));
        this.txtDX.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtDY.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
        this.txtDX.setHorizontalAlignment(4);
        this.txtDY.setHorizontalAlignment(4);
        this.txtOri.setHorizontalAlignment(4);
        this.txaText.setFont(this.txtOri.getFont());
        this.setMinimumSize(new Dimension(180, 300));
        this.txtX.getDocument().addDocumentListener(new DocumentChangeListener(FIELD_X));
        this.txtY.getDocument().addDocumentListener(new DocumentChangeListener(FIELD_Y));
        this.txtDX.getDocument().addDocumentListener(new DocumentChangeListener(FIELD_DX));
        this.txtDY.getDocument().addDocumentListener(new DocumentChangeListener(FIELD_DY));
        this.txtOri.getDocument().addDocumentListener(new DocumentChangeListener(FIELD_ORI));
        this.txaText.getDocument().addDocumentListener(new DocumentChangeListener(FIELD_TEXT));
        CommitActionListener commitActionListener = new CommitActionListener();
        this.txtX.addKeyListener(commitActionListener);
        this.txtY.addKeyListener(commitActionListener);
        this.txtDX.addKeyListener(commitActionListener);
        this.txtDY.addKeyListener(commitActionListener);
        this.txtOri.addKeyListener(commitActionListener);
        this.txaText.addKeyListener(commitActionListener);
        this.txtX.setFocusLostBehavior(3);
        this.txtY.setFocusLostBehavior(3);
        this.txtDX.setFocusLostBehavior(3);
        this.txtDY.setFocusLostBehavior(3);
        this.txtOri.setFocusLostBehavior(3);
    }

    @Override
    public void updateEnabledState() {
        this.pnlToolbox.updateEnabledState();
    }

    public void updateControls() {
        this.resetControls();
        SelectionManager selectionManager = JUMPWorkbench.getContext().getSelectionManager();
        if (selectionManager == null) {
            this.setControlsEnabled(false);
            this.setControlsVisible(false);
            return;
        }
        FeatureSelection featureSelection = selectionManager.getFeatureSelection();
        Collection<Layer> layers = featureSelection.getLayersWithSelectedItems();
        if (layers.isEmpty()) {
            this.setControlsEnabled(false);
            this.setControlsVisible(false);
        } else if (layers.size() == 1) {
            this.updateControlsForSingleLayer(featureSelection, layers);
        } else {
            this.updateControlsForMultipleLayers(layers);
        }
        if (!(this.txtX.isVisible() || this.txtY.isVisible() || this.txaText.isVisible() || this.txtOri.isVisible() || this.txtDX.isVisible() || this.txtDY.isVisible())) {
            this.pnlToolbox.setVisible(false);
            this.lblTitle.setVisible(false);
        }
        this.changes.clear();
        this.updateEnabledState();
    }

    private void updateControlsForSingleLayer(FeatureSelection featureSelection, Collection<Layer> layers) {
        block41: {
            Collection<SimpleFeature> features;
            LabelLayer labelLayer;
            Layer layer = layers.iterator().next();
            FeaturestoreMetadata fmd = layer.getFMD();
            if (fmd == null) {
                return;
            }
            this.setControlsEnabled(true);
            this.setControlsVisible(true);
            if (!layer.isEditable()) {
                this.setControlsEditable(false);
            }
            if (layer instanceof LabelLayer && !(labelLayer = (LabelLayer)layer).isLabelTextEditable()) {
                this.txaText.setEditable(false);
            }
            if ((features = featureSelection.getFeaturesWithSelectedItems(layer)).size() == 1) {
                SimpleFeature feature = features.iterator().next();
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                if (geom instanceof Point) {
                    this.setCoordinateControlsVisible(true);
                    this.setXCoord(geom.getCoordinate().x);
                    this.setYCoord(geom.getCoordinate().y);
                } else {
                    this.setCoordinateControlsVisible(false);
                }
                if (fmd.getUseText()) {
                    String att;
                    if (StringUtils.isEmpty((CharSequence)fmd.getTextAtt())) {
                        this.setTextAttControlsEnabled(false);
                        this.setTextAttControlsVisible(false);
                        try {
                            ExportStyle exportStyle = ExportStyleFactory.createExportStyle(layer, feature, JUMPWorkbench.getContext().getLayerViewPanel().getViewport().getScale());
                            String text = exportStyle.getText();
                            if (StringUtils.isNotEmpty((CharSequence)text)) {
                                this.setText(text);
                                this.setTextAttControlsVisible(true);
                                this.setTextAttControlsEnabled(true);
                                this.setTextAttControlsEditable(false);
                            }
                        }
                        catch (Exception e) {
                            this.setText("");
                        }
                    } else {
                        this.setText(Objects.toString(feature.getAttribute(fmd.getTextAtt()), null));
                    }
                    if (StringUtils.isEmpty((CharSequence)fmd.getTextDXAtt())) {
                        this.setDXControlsEnabled(false);
                        this.setDXControlsVisible(false);
                    } else {
                        att = Objects.toString(feature.getAttribute(fmd.getTextDXAtt()), null);
                        if (StringUtils.isNotEmpty((CharSequence)att)) {
                            this.setDX(Double.parseDouble(att));
                        }
                    }
                    if (StringUtils.isEmpty((CharSequence)fmd.getTextDYAtt())) {
                        this.setDYControlsEnabled(false);
                        this.setDYControlsVisible(false);
                    } else {
                        att = Objects.toString(feature.getAttribute(fmd.getTextDYAtt()), null);
                        if (StringUtils.isNotEmpty((CharSequence)att)) {
                            this.setDY(Double.parseDouble(att));
                        }
                    }
                    if (StringUtils.isEmpty((CharSequence)fmd.getOriAtt()) && StringUtils.isEmpty((CharSequence)fmd.getTextOriAtt())) {
                        this.setOriControlsEnabled(false);
                        this.setOriControlsVisible(false);
                    } else {
                        try {
                            this.setOriControlsEnabled(true);
                            att = Objects.toString(feature.getAttribute(fmd.getOriAtt()), null);
                            if (StringUtils.isNotEmpty((CharSequence)att)) {
                                exportStyle = ExportStyleFactory.createExportStyle(layer, feature, JUMPWorkbench.getContext().getLayerViewPanel().getViewport().getScale());
                                ExportStyle.InsertionPoint[] symInsertPoints = exportStyle.getSymInsertPoints();
                                if (symInsertPoints != null && symInsertPoints.length > 0) {
                                    this.setOri(symInsertPoints[0].getOrientation());
                                }
                            } else {
                                ExportStyle.InsertionPoint[] symInsertPoints;
                                att = Objects.toString(feature.getAttribute(fmd.getTextOriAtt()), null);
                                if (StringUtils.isNotEmpty((CharSequence)att) && (symInsertPoints = (exportStyle = ExportStyleFactory.createExportStyle(layer, feature, JUMPWorkbench.getContext().getLayerViewPanel().getViewport().getScale())).getTextInsertPoints()) != null && symInsertPoints.length > 0) {
                                    this.setOri(symInsertPoints[0].getOrientation());
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.setOriControlsVisible(false);
                        }
                    }
                } else {
                    this.setTextControlsEnabled(false);
                    this.setTextControlsVisible(false);
                    try {
                        ExportStyle exportStyle = ExportStyleFactory.createExportStyle(layer, feature, JUMPWorkbench.getContext().getLayerViewPanel().getViewport().getScale());
                        String text = exportStyle.getText();
                        if (StringUtils.isNotEmpty((CharSequence)text)) {
                            this.setText(text);
                            this.setTextAttControlsVisible(true);
                            this.setTextAttControlsEnabled(true);
                            this.setTextAttControlsEditable(false);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)fmd.getOriAtt())) {
                            ExportStyle.InsertionPoint[] symInsertPoints;
                            this.setOriControlsEnabled(true);
                            String att = Objects.toString(feature.getAttribute(fmd.getOriAtt()), null);
                            if (StringUtils.isNotEmpty((CharSequence)att) && (symInsertPoints = exportStyle.getSymInsertPoints()) != null && symInsertPoints.length > 0) {
                                this.setOri(symInsertPoints[0].getOrientation());
                            }
                            break block41;
                        }
                        this.setOriControlsEnabled(false);
                        this.setOriControlsVisible(false);
                    }
                    catch (Exception e) {
                        this.setText("");
                        this.setOriControlsVisible(false);
                    }
                }
            } else {
                this.setCoordinateControlsEnabled(false);
                this.setCoordinateControlsVisible(false);
                if (fmd.getUseText()) {
                    if (StringUtils.isEmpty((CharSequence)fmd.getTextAtt())) {
                        this.setTextAttControlsEnabled(false);
                        this.setTextAttControlsVisible(false);
                    }
                    if (StringUtils.isEmpty((CharSequence)fmd.getTextDXAtt())) {
                        this.setDXControlsEnabled(false);
                        this.setDXControlsVisible(false);
                    }
                    if (StringUtils.isEmpty((CharSequence)fmd.getTextDYAtt())) {
                        this.setDYControlsEnabled(false);
                        this.setDYControlsVisible(false);
                    }
                    if (StringUtils.isEmpty((CharSequence)fmd.getOriAtt()) && StringUtils.isEmpty((CharSequence)fmd.getTextOriAtt())) {
                        this.setOriControlsEnabled(false);
                        this.setOriControlsVisible(false);
                    }
                } else {
                    this.setTextControlsEnabled(false);
                    this.setTextControlsVisible(false);
                    if (StringUtils.isEmpty((CharSequence)fmd.getOriAtt())) {
                        this.setOriControlsEnabled(false);
                        this.setOriControlsVisible(false);
                    }
                }
            }
        }
    }

    private void updateControlsForMultipleLayers(Collection<Layer> layers) {
        this.setControlsEnabled(true);
        this.setControlsVisible(true);
        this.setCoordinateControlsVisible(false);
        for (Layer layer : layers) {
            FeaturestoreMetadata fmd;
            if (!layer.isEditable()) {
                this.setControlsEditable(false);
            }
            if ((fmd = layer.getFMD()).getUseText()) {
                if (StringUtils.isEmpty((CharSequence)fmd.getTextAtt())) {
                    this.setTextAttControlsEnabled(false);
                    this.setTextAttControlsVisible(false);
                }
                if (StringUtils.isEmpty((CharSequence)fmd.getTextDXAtt())) {
                    this.setDXControlsEnabled(false);
                    this.setDXControlsVisible(false);
                }
                if (StringUtils.isEmpty((CharSequence)fmd.getTextDYAtt())) {
                    this.setDYControlsEnabled(false);
                    this.setDYControlsVisible(false);
                }
                if (!StringUtils.isEmpty((CharSequence)fmd.getOriAtt()) || !StringUtils.isEmpty((CharSequence)fmd.getTextOriAtt())) continue;
                this.setOriControlsEnabled(false);
                this.setOriControlsVisible(false);
                continue;
            }
            this.setTextControlsEnabled(false);
            this.setTextControlsVisible(false);
            if (!StringUtils.isEmpty((CharSequence)fmd.getOriAtt())) continue;
            this.setOriControlsEnabled(false);
            this.setOriControlsVisible(false);
        }
    }

    public void setControlsVisible(boolean visible) {
        this.setControlsEnabled(visible);
        this.pnlToolbox.setVisible(visible);
        this.txtX.setVisible(visible);
        this.txtY.setVisible(visible);
        this.txtDX.setVisible(visible);
        this.txtDY.setVisible(visible);
        this.txtOri.setVisible(visible);
        this.txaText.setVisible(visible);
        this.jScrollPane1.setVisible(visible);
        this.lblTitle.setVisible(visible);
        this.lblOri.setVisible(visible);
        this.lblText.setVisible(visible);
        this.lblY.setVisible(visible);
        this.lblX.setVisible(visible);
        this.lblOffset.setVisible(visible);
        this.lblDY.setVisible(visible);
        this.lblDX.setVisible(visible);
    }

    public void setCoordinateControlsVisible(boolean visible) {
        this.setCoordinateControlsEnabled(visible);
        this.txtX.setVisible(visible);
        this.txtY.setVisible(visible);
        this.lblY.setVisible(visible);
        this.lblX.setVisible(visible);
    }

    public void setCoordinateControlsEnabled(boolean enabled) {
        this.txtX.setEnabled(enabled);
        this.txtY.setEnabled(enabled);
        this.lblY.setEnabled(enabled);
        this.lblX.setEnabled(enabled);
        if (!enabled) {
            this.txtX.setEditable(enabled);
            this.txtY.setEditable(enabled);
        }
    }

    public boolean isCoordinateControlsEnabled() {
        return this.txtX.isEnabled() && this.txtY.isEnabled();
    }

    public void setTextControlsVisible(boolean visible) {
        this.txtDX.setVisible(visible);
        this.txtDY.setVisible(visible);
        this.txaText.setVisible(visible);
        this.jScrollPane1.setVisible(visible);
        this.lblText.setVisible(visible);
        this.lblOffset.setVisible(visible);
        this.lblDY.setVisible(visible);
        this.lblDX.setVisible(visible);
    }

    public void setTextControlsEnabled(boolean enabled) {
        this.txtDX.setEnabled(enabled);
        this.txtDY.setEnabled(enabled);
        this.txaText.setEnabled(enabled);
        this.jScrollPane1.setEnabled(enabled);
        this.lblText.setEnabled(enabled);
        this.lblOffset.setEnabled(enabled);
        this.lblDY.setEnabled(enabled);
        this.lblDX.setEnabled(enabled);
        if (!enabled) {
            this.txtDX.setEditable(enabled);
            this.txtDY.setEditable(enabled);
            this.txaText.setEditable(enabled);
        }
    }

    public void setOriControlsEnabled(boolean enabled) {
        this.txtOri.setEnabled(enabled);
        this.lblOri.setEnabled(enabled);
        if (!enabled) {
            this.txtOri.setEditable(enabled);
        }
    }

    public void setOriControlsVisible(boolean visible) {
        this.txtOri.setVisible(visible);
        this.lblOri.setVisible(visible);
    }

    public boolean isOriControlsEnabled() {
        return this.txtOri.isEnabled();
    }

    public void setTextAttControlsEnabled(boolean enabled) {
        this.txaText.setEnabled(enabled);
        this.lblText.setEnabled(enabled);
        if (!enabled) {
            this.txaText.setEditable(enabled);
        }
    }

    public void setTextAttControlsEditable(boolean editable) {
        this.txaText.setEditable(editable);
    }

    public void setTextAttControlsVisible(boolean visible) {
        this.txaText.setVisible(visible);
        this.jScrollPane1.setVisible(visible);
        this.lblText.setVisible(visible);
    }

    public boolean isTextAttControlsEnabled() {
        return this.txaText.isEnabled();
    }

    public void setDXControlsEnabled(boolean enabled) {
        this.lblOffset.setEnabled(this.lblDY.isEnabled() || enabled);
        this.txtDX.setEnabled(enabled);
        this.lblDX.setEnabled(enabled);
        if (!enabled) {
            this.txtDX.setEditable(enabled);
        }
    }

    public void setDXControlsVisible(boolean visible) {
        this.lblOffset.setVisible(this.lblDY.isVisible() || visible);
        this.txtDX.setVisible(visible);
        this.lblDX.setVisible(visible);
    }

    public boolean isDXControlsEnabled() {
        return this.txtDX.isEnabled();
    }

    public void setDYControlsVisible(boolean visible) {
        this.lblOffset.setVisible(this.lblDX.isVisible() || visible);
        this.txtDY.setVisible(visible);
        this.lblDY.setVisible(visible);
    }

    public void setDYControlsEnabled(boolean enabled) {
        this.lblOffset.setEnabled(this.lblDX.isEnabled() || enabled);
        this.txtDY.setEnabled(enabled);
        this.lblDY.setEnabled(enabled);
        if (!enabled) {
            this.txtDY.setEditable(enabled);
        }
    }

    public boolean isDYControlsEnabled() {
        return this.txtDY.isEnabled();
    }

    public void setControlsEnabled(boolean enabled) {
        this.txtX.setEnabled(enabled);
        this.txtY.setEnabled(enabled);
        this.txtDX.setEnabled(enabled);
        this.txtDY.setEnabled(enabled);
        this.txtOri.setEnabled(enabled);
        this.txaText.setEnabled(enabled);
        this.jScrollPane1.setEnabled(enabled);
        this.lblTitle.setEnabled(enabled);
        this.lblOri.setEnabled(enabled);
        this.lblText.setEnabled(enabled);
        this.lblY.setEnabled(enabled);
        this.lblX.setEnabled(enabled);
        this.lblOffset.setEnabled(enabled);
        this.lblDY.setEnabled(enabled);
        this.lblDX.setEnabled(enabled);
    }

    public void setControlsEditable(boolean editable) {
        this.txtX.setEditable(editable);
        this.txtY.setEditable(editable);
        this.txtDX.setEditable(editable);
        this.txtDY.setEditable(editable);
        this.txtOri.setEditable(editable);
        this.txaText.setEditable(editable);
    }

    public void resetControls() {
        this.changes.clear();
        this.setControlsVisible(true);
        this.setControlsEnabled(true);
        this.setControlsEditable(true);
        this.txtX.setText("");
        this.txtY.setText("");
        this.txtDX.setText("");
        this.txtDY.setText("");
        this.txtOri.setText("");
        this.txaText.setText("");
    }

    public boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    public boolean isChanged(String field) {
        return this.changes.contains(field);
    }

    public double getXCoord() throws ParseException {
        String strValue = this.txtX.getText().trim();
        if (strValue.equals("-") || strValue.length() == 0) {
            strValue = "0";
        }
        return this.df.parse(strValue).doubleValue();
    }

    public void setXCoord(double dblX) {
        this.txtX.setText(this.df.format(dblX));
    }

    public double getYCoord() throws ParseException {
        String strValue = this.txtY.getText().trim();
        if (strValue.equals("-") || strValue.length() == 0) {
            strValue = "0";
        }
        return this.df.parse(strValue).doubleValue();
    }

    public void setYCoord(double dblY) {
        this.txtY.setText(this.df.format(dblY));
    }

    public void setDY(double dblY) {
        this.txtDY.setText(this.df.format(dblY));
    }

    public double getDX() throws ParseException {
        String strValue = this.txtDX.getText().trim();
        if (strValue.equals("-") || strValue.length() == 0) {
            strValue = "0";
        }
        return this.df.parse(strValue).doubleValue();
    }

    public void setDX(double dblX) {
        this.txtDX.setText(this.df.format(dblX));
    }

    public double getDY() throws ParseException {
        String strValue = this.txtDY.getText().trim();
        if (strValue.equals("-") || strValue.length() == 0) {
            strValue = "0";
        }
        return this.df.parse(strValue).doubleValue();
    }

    public String getText() {
        return this.txaText.getText();
    }

    public void setText(String strText) {
        this.txaText.setText(strText);
    }

    public double getOri() {
        try {
            return this.df.parse(this.txtOri.getText()).doubleValue();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void setOri(double dblOri) {
        this.txtOri.setText(this.df.format(dblOri));
    }

    private void initComponents() {
        this.pnlTools = new JPanel();
        this.lblTitle = new JLabel();
        this.lblText = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txaText = new JTextArea();
        this.txtOri = new JFormattedTextField();
        this.lblOri = new JLabel();
        this.lblX = new JLabel();
        this.txtY = new JFormattedTextField();
        this.lblY = new JLabel();
        this.txtX = new JFormattedTextField();
        this.txtDX = new JFormattedTextField();
        this.lblOffset = new JLabel();
        this.lblDY = new JLabel();
        this.txtDY = new JFormattedTextField();
        this.lblDX = new JLabel();
        this.pnlFiller = new JPanel();
        this.setEnabled(false);
        this.setLayout(new GridBagLayout());
        this.pnlTools.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlTools, gridBagConstraints);
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(this.lblTitle.getFont().getStyle() | 1));
        this.lblTitle.setText("Objekteigenschaften");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 5, 3);
        this.add((Component)this.lblTitle, gridBagConstraints);
        this.lblText.setText("Text:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblText, gridBagConstraints);
        this.jScrollPane1.setDoubleBuffered(true);
        this.jScrollPane1.setMinimumSize(new Dimension(50, 70));
        this.jScrollPane1.setPreferredSize(new Dimension(140, 70));
        this.txaText.setFont(UIManager.getFont("TextField.font").deriveFont(12.0f));
        this.jScrollPane1.setViewportView(this.txaText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtOri, gridBagConstraints);
        this.lblOri.setText("Orientierung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblOri, gridBagConstraints);
        this.lblX.setHorizontalAlignment(4);
        this.lblX.setText("X:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblX, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtY, gridBagConstraints);
        this.lblY.setHorizontalAlignment(4);
        this.lblY.setText("Y:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblY, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtX, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtDX, gridBagConstraints);
        this.lblOffset.setText("Versatz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblOffset, gridBagConstraints);
        this.lblDY.setHorizontalAlignment(4);
        this.lblDY.setText("links:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblDY, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtDY, gridBagConstraints);
        this.lblDX.setHorizontalAlignment(4);
        this.lblDX.setText("rechts:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblDX, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlFiller, gridBagConstraints);
    }

    private class DocumentChangeListener
    implements DocumentListener {
        private final String name;

        public DocumentChangeListener(String name) {
            this.name = name;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changed();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changed();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.changed();
        }

        private void changed() {
            SelectFeaturesPanel.this.changes.add(this.name);
            SelectFeaturesPanel.this.updateEnabledState();
        }
    }

    private class CommitActionListener
    extends KeyAdapter
    implements ActionListener {
        private CommitActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.commit();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isActionKey()) {
                int keyCode = e.getKeyCode();
                switch (keyCode) {
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        break;
                    }
                    default: {
                        this.commit();
                        break;
                    }
                }
            } else if (e.getKeyCode() == 10) {
                if (e.getComponent() instanceof JTextArea) {
                    if (e.isControlDown()) {
                        this.commit();
                    }
                } else {
                    this.commit();
                }
            }
        }

        private void commit() {
            if (SelectFeaturesPanel.this.changeCheck.check(null) == null) {
                SelectFeaturesPanel.this.pnlToolbox.getToolBar().getButton(0).doClick();
            }
        }
    }
}

