/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.ContextualHoverTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DelegatingCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DelegatingTool;
import com.vividsolutions.jump.workbench.ui.cursortool.MiddleMouseButtonDelegator;
import com.vividsolutions.jump.workbench.ui.cursortool.ModifierKeySpec;
import com.vividsolutions.jump.workbench.ui.cursortool.RightClickFilter;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectFeaturesTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectTool;
import com.vividsolutions.jump.workbench.ui.zoom.PanTool;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomOutTool;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomTool;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuasimodeTool
extends DelegatingTool {
    private static final Logger LOG = LoggerFactory.getLogger(QuasimodeTool.class);
    private boolean mouseDown = false;
    private final HashMap<ModifierKeySpec, CursorTool> keySpecToToolMap = new HashMap();
    private Cursor cursor;
    private LayerViewPanel panel;
    private WorkbenchFrame frame;
    private final CursorTool defaultTool;
    private final boolean isSmart;
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.keyStateChanged(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.keyStateChanged(e);
        }

        private void keyStateChanged(KeyEvent e) {
            QuasimodeTool.this.setTool(e);
        }
    };
    private final WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowActivated(WindowEvent e) {
            super.windowActivated(e);
            QuasimodeTool.this.setTool(new KeyEvent(QuasimodeTool.this.panel, 401, 0L, 0, 0, '\uffff'));
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            QuasimodeTool.this.cursor = QuasimodeTool.this.defaultTool.getCursor();
            QuasimodeTool.this.panel.setCursor(QuasimodeTool.this.cursor);
            QuasimodeTool.this.setDelegate(QuasimodeTool.this.defaultTool);
        }
    };

    public QuasimodeTool(CursorTool _defaultTool) {
        this(_defaultTool, false);
    }

    public QuasimodeTool(CursorTool _defaultTool, boolean isSmart) {
        super(_defaultTool);
        this.isSmart = isSmart;
        if (isSmart) {
            _defaultTool = new ContextualHoverTool(_defaultTool);
            super.setDelegate(_defaultTool);
        }
        if (!_defaultTool.isMiddleMouseButtonUsed()) {
            _defaultTool = new MiddleMouseButtonDelegator(_defaultTool);
        }
        _defaultTool = QuasimodeTool.filterRightClickIfNecessary(_defaultTool);
        super.setDelegate(_defaultTool);
        this.defaultTool = _defaultTool;
        this.add(new ModifierKeySpec(false, false, false), this.defaultTool);
        this.cursor = this.defaultTool.getCursor();
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    private CursorTool getTool(KeyEvent e) {
        CursorTool tool = this.keySpecToToolMap.get(new ModifierKeySpec(e));
        return tool != null ? tool : this.defaultTool;
    }

    private void setTool(KeyEvent e) {
        if (!this.mouseDown) {
            CursorTool tool = this.getTool(e);
            this.cursor = tool.getCursor();
            this.panel.setCursor(this.cursor);
            this.setDelegate(tool);
        }
    }

    @Override
    public void activate(LayerViewPanel panel) {
        if (this.defaultTool != this.getDelegate()) {
            this.defaultTool.activate(panel);
        }
        super.activate(panel);
        this.panel = panel;
        this.frame = AbstractCursorTool.workbenchFrame(panel);
        if (this.frame != null) {
            this.frame.addEasyKeyListener(this.keyListener);
            this.frame.addWindowListener(this.windowListener);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.mouseDown = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.mouseDown = false;
    }

    @Override
    public CursorTool getInnerDelegate() {
        if (this.defaultTool instanceof DelegatingCursorTool) {
            return ((DelegatingCursorTool)this.defaultTool).getInnerDelegate();
        }
        return this.defaultTool;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.defaultTool != this.getDelegate()) {
            this.defaultTool.deactivate();
        }
        this.setDelegate(this.defaultTool);
        for (CursorTool quasiTool : this.keySpecToToolMap.values()) {
            if (quasiTool == null || !quasiTool.isActive()) continue;
            quasiTool.deactivate();
        }
        if (this.frame != null) {
            this.frame.removeEasyKeyListener(this.keyListener);
            this.frame.removeWindowListener(this.windowListener);
        }
    }

    public final QuasimodeTool add(ModifierKeySpec keySpec, CursorTool tool) {
        if (this.keySpecToToolMap.containsKey(keySpec)) {
            return this;
        }
        this.keySpecToToolMap.put(keySpec, QuasimodeTool.filterRightClickIfNecessary(tool));
        return this;
    }

    private static CursorTool filterRightClickIfNecessary(CursorTool tool) {
        if (tool == null || tool instanceof RightClickFilter) {
            return tool;
        }
        return new RightClickFilter(tool);
    }

    public static QuasimodeTool addStandardQuasimodes(CursorTool tool) {
        QuasimodeTool quasimodeTool = tool instanceof QuasimodeTool ? (QuasimodeTool)tool : new QuasimodeTool(tool);
        CursorTool innerTool = quasimodeTool.getInnerDelegate();
        if (!(tool instanceof QuasimodeTool) || !((QuasimodeTool)tool).isSmart) {
            if (!(tool instanceof ZoomTool)) {
                quasimodeTool.add(new ModifierKeySpec(false, false, true), new ZoomTool());
            } else if (!(tool instanceof ZoomOutTool)) {
                quasimodeTool.add(new ModifierKeySpec(false, false, true), new ZoomOutTool());
            }
            if (!(tool instanceof PanTool)) {
                quasimodeTool.add(new ModifierKeySpec(true, false, true), new PanTool());
            }
        }
        if (!(innerTool instanceof SelectTool)) {
            SelectFeaturesTool selectFeaturesTool = new SelectFeaturesTool(false){

                @Override
                protected boolean selectedLayersOnly() {
                    return false;
                }

                @Override
                public String getName() {
                    try {
                        return I18N.get(SelectFeaturesTool.class.getName());
                    }
                    catch (MissingResourceException e) {
                        LOG.error(e.getMessage() + " " + SelectFeaturesTool.class.getName());
                        return StringUtil.toFriendlyName(SelectFeaturesTool.class.getName(), I18N.get("ui.cursortool.AbstractCursorTool.tool"));
                    }
                }
            };
            quasimodeTool.add(new ModifierKeySpec(true, false, false), selectFeaturesTool);
            quasimodeTool.add(new ModifierKeySpec(true, true, false), selectFeaturesTool);
        }
        return quasimodeTool;
    }
}

