/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import java.awt.Shape;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.valid.IsValidOp;

public abstract class PolygonTool
extends MultiClickTool {
    private final KeyListener klstEnter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 10) {
                try {
                    PolygonTool.this.finishGesture();
                }
                catch (Exception e1) {
                    WorkbenchContext.getFrame().handleThrowable(e1);
                }
            }
        }
    };

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        GeneralPath path = (GeneralPath)super.getShape();
        if (path == null) {
            path = new GeneralPath();
        }
        if (this.getCoordinates().size() > 0) {
            Point2D firstPoint = this.getPanel().getViewport().toViewPoint(this.getCoordinates().get(0));
            path.lineTo((float)firstPoint.getX(), (float)firstPoint.getY());
        }
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        return path;
    }

    protected Polygon getPolygon() throws NoninvertibleTransformException {
        ArrayList<Coordinate> closedPoints = new ArrayList<Coordinate>(this.getCoordinates());
        if (!closedPoints.get(0).equals(closedPoints.get(closedPoints.size() - 1))) {
            closedPoints.add(new Coordinate(closedPoints.get(0)));
        }
        return new GeometryFactory().createPolygon(new GeometryFactory().createLinearRing(PolygonTool.toArray(closedPoints)), null);
    }

    protected boolean checkPolygon() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 3) {
            this.getPanel().getContext().warnUser(I18N.get("ui.cursortool.PolygonTool.the-polygon-must-have-at-least-3-points"));
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getPolygon());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public KeyListener getKeyListener() {
        return this.klstEnter;
    }
}

