/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractClickSelectedLineStringsTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SplitLineStringsOp;
import de.riwagis.icons.IconLoader;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;

public class NodeLineStringsTool
extends AbstractClickSelectedLineStringsTool {
    private static final String sNoIntersectionsHere = I18N.get("com.vividsolutions.jump.workbench.ui.cursortool.NodeLineStringsTool.No-intersections-here");

    @Override
    public String getName() {
        return I18N.get("com.vividsolutions.jump.workbench.ui.cursortool.NodeLineStringsTool.Node-LineStrings");
    }

    @Override
    protected void gestureFinished(Collection<SimpleFeature> nearbyLineStringFeatures) throws NoninvertibleTransformException {
        Intersection intersection = this.closest(this.getModelClickPoint(), CollectionUtil.select(this.properIntersections(nearbyLineStringFeatures, this.layerToSpecifiedFeaturesMap()), intersection1 -> this.getBoxInModelCoordinates().contains(intersection1.coordinate) ? Boolean.TRUE : Boolean.FALSE));
        if (intersection == null) {
            JUMPWorkbench.getFrame().warnUser(sNoIntersectionsHere);
            return;
        }
        if (!intersection.layerA.isEditable()) {
            this.warnLayerNotEditable(intersection.layerA);
            return;
        }
        if (!intersection.layerB.isEditable()) {
            this.warnLayerNotEditable(intersection.layerB);
            return;
        }
        new SplitLineStringsOp(Color.magenta).addSplit(intersection.featureA, intersection.coordinate, intersection.layerA, true).addSplit(intersection.featureB, intersection.coordinate, intersection.layerB, true).execute(this.getName(), this.isRollingBackInvalidEdits(), this.getPanel());
    }

    private Intersection closest(Point p, Collection<Intersection> intersections) {
        Intersection closestIntersection = null;
        double closestDistance = Double.MAX_VALUE;
        for (Intersection intersection : intersections) {
            double distance = intersection.coordinate.distance(p.getCoordinate());
            if (!(distance < closestDistance)) continue;
            closestIntersection = intersection;
            closestDistance = distance;
        }
        return closestIntersection;
    }

    private Collection<Intersection> properIntersections(Collection<SimpleFeature> nearbyLineStringFeatures, Map<Layer, Collection<SimpleFeature>> layerToFeaturesMap) {
        TreeSet<Intersection> intersections = new TreeSet<Intersection>();
        for (SimpleFeature a : nearbyLineStringFeatures) {
            for (SimpleFeature b : nearbyLineStringFeatures) {
                if (a == b) continue;
                for (Coordinate coordinate : ((Geometry)a.getDefaultGeometry()).intersection((Geometry)b.getDefaultGeometry()).getCoordinates()) {
                    if (coordinate.equals2D(this.first(a)) || coordinate.equals2D(this.last(a)) || coordinate.equals2D(this.first(b)) || coordinate.equals2D(this.last(b))) continue;
                    intersections.add(new Intersection(coordinate, a, this.layer(a, layerToFeaturesMap), b, this.layer(b, layerToFeaturesMap)));
                }
            }
        }
        return intersections;
    }

    private Coordinate first(SimpleFeature lineStringFeature) {
        return this.lineString(lineStringFeature).getCoordinateN(0);
    }

    private LineString lineString(SimpleFeature feature) {
        return (LineString)feature.getDefaultGeometry();
    }

    private Coordinate last(SimpleFeature lineStringFeature) {
        return this.lineString(lineStringFeature).getCoordinateN(this.lineString(lineStringFeature).getNumPoints() - 1);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon((String)"SplitLinestringsAtIntersection.gif");
    }

    private static class Intersection
    implements Comparable<Intersection> {
        final Coordinate coordinate;
        final SimpleFeature featureA;
        final SimpleFeature featureB;
        final Layer layerA;
        final Layer layerB;

        Intersection(Coordinate coordinate, SimpleFeature featureA, Layer layerA, SimpleFeature featureB, Layer layerB) {
            this.coordinate = coordinate;
            this.featureA = featureA;
            this.layerA = layerA;
            this.featureB = featureB;
            this.layerB = layerB;
        }

        @Override
        public int compareTo(Intersection o) {
            return this.coordinate.compareTo(o.coordinate);
        }
    }
}

