/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiClickTool
extends AbstractCursorTool {
    private static final Logger LOG = LoggerFactory.getLogger(MultiClickTool.class);
    private final List<Coordinate> coordinates = new ArrayList<Coordinate>();
    private Coordinate tentativeCoordinate;
    private boolean useAngleConstraint = false;
    private double dblAngle = 90.0;
    private boolean useLengthConstraint = false;
    private double dblLength = 20.0;

    public boolean getUseAngleConstraint() {
        return this.useAngleConstraint;
    }

    public void setUseAngleConstraint(boolean _useAngleConstraint) {
        this.useAngleConstraint = _useAngleConstraint;
    }

    public boolean getUseLengthConstraint() {
        return this.useLengthConstraint;
    }

    public double getAngle() {
        return this.dblAngle;
    }

    public void setAngle(double _dblAngle) {
        this.dblAngle = _dblAngle;
    }

    public void setUseLengthConstraint(boolean _useLengthConstraint) {
        this.useLengthConstraint = _useLengthConstraint;
    }

    public double getLength() {
        return this.dblLength;
    }

    public void setLength(double _dblLength) {
        this.dblLength = _dblLength;
    }

    protected Coordinate applyConstraints(Coordinate coord) throws NoninvertibleTransformException {
        double dblOri;
        int l;
        Coordinate coordTmp = coord;
        Coordinate[] coordPoly = MultiClickTool.toArray(this.coordinates);
        if (this.getUseAngleConstraint() && (l = coordPoly.length) > 1) {
            dblOri = ConstSupport.getOrientation((Coordinate)coordPoly[l - 2], (Coordinate)coordPoly[l - 1], (int)2);
            double dblSnapOri = ConstSupport.getOrientation((Coordinate)coordPoly[l - 1], (Coordinate)coordTmp, (int)2);
            double dblSnapAngle = dblSnapOri - dblOri;
            if (dblSnapAngle < 0.0) {
                dblSnapAngle += Math.PI * 2;
            }
            int intQ = (int)(dblSnapAngle / 1.5707963267948966) + 1;
            double dblQ = intQ;
            double fac = 1.0;
            if (dblQ % 2.0 == 0.0) {
                fac = -1.0;
            }
            double dblLastDist = ConstSupport.getLength((Coordinate)coordPoly[l - 1], (Coordinate)coordPoly[l - 2]);
            Coordinate oriCoord = ConstSupport.getPolarCoord((Coordinate)coordPoly[l - 1], (double)dblLastDist, (double)(dblOri += Math.toRadians(this.getAngle()) * fac));
            coordTmp = ConstSupport.getOrthoSection((Coordinate)coordPoly[l - 1], (Coordinate)oriCoord, (Coordinate)coordTmp);
        }
        if (this.getUseLengthConstraint() && (l = coordPoly.length) > 0) {
            dblOri = ConstSupport.getOrientation((Coordinate)coordPoly[l - 1], (Coordinate)coordTmp, (int)2);
            coordTmp = ConstSupport.getPolarCoord((Coordinate)coordPoly[l - 1], (double)this.getLength(), (double)dblOri);
        }
        return coordTmp;
    }

    public List<Coordinate> getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    public Coordinate getTentativeCoordinate() {
        if (this.tentativeCoordinate == null) {
            return null;
        }
        return (Coordinate)this.tentativeCoordinate.clone();
    }

    public void back() {
        if (this.coordinates.size() > 0) {
            this.coordinates.remove(this.coordinates.size() - 1);
        }
        try {
            this.redrawShape();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canBack() {
        return this.coordinates.size() > 0;
    }

    public void changeDirection() {
        if (this.coordinates.size() > 0) {
            Collections.reverse(this.coordinates);
        }
        try {
            this.redrawShape();
        }
        catch (Exception e) {
            LOG.trace(String.format("Error redrawing: %s", e.getMessage()), (Throwable)e);
        }
    }

    public void resetCoordinates() {
        this.coordinates.clear();
        try {
            this.clearShape();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void cancelGesture() {
        super.cancelGesture();
        this.coordinates.clear();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        try {
            if (e.getButton() == 1) {
                if (e.getClickCount() == 1) {
                    this.tentativeCoordinate = this.applyConstraints(this.snap(e.getPoint()));
                    this.redrawShape();
                }
                super.mouseReleased(e);
                if (this.isFinishingRelease(e)) {
                    this.finishGesture();
                }
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected void mouseLocationChanged(MouseEvent e) {
        try {
            this.tentativeCoordinate = this.applyConstraints(this.snap(e.getPoint()));
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseLocationChanged(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseLocationChanged(e);
    }

    protected void add(Coordinate c) {
        this.coordinates.add(c);
    }

    protected void addAll(Coordinate[] arrCoord) {
        this.coordinates.addAll(Arrays.asList(arrCoord));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            super.mousePressed(e);
            if (e.getButton() == 1) {
                Assert.isTrue((e.getClickCount() > 0 ? 1 : 0) != 0);
                if (e.getClickCount() != 1) {
                    return;
                }
                this.add(this.applyConstraints(this.snap(e.getPoint())));
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        if (this.coordinates.isEmpty()) {
            GeneralPath path = new GeneralPath();
            this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
            return path;
        }
        Point2D firstPoint = this.getPanel().getViewport().toViewPoint(this.coordinates.get(0));
        GeneralPath path = new GeneralPath();
        path.moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
        for (int i = 1; i < this.coordinates.size(); ++i) {
            Coordinate nextCoordinate = this.coordinates.get(i);
            Point2D nextPoint = this.getPanel().getViewport().toViewPoint(nextCoordinate);
            path.lineTo((int)nextPoint.getX(), (int)nextPoint.getY());
        }
        Point2D tentativePoint = this.getPanel().getViewport().toViewPoint(this.tentativeCoordinate);
        path.lineTo((int)tentativePoint.getX(), (int)tentativePoint.getY());
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        return path;
    }

    protected boolean isFinishingRelease(MouseEvent e) {
        return e.getClickCount() == 2;
    }

    public static final Coordinate[] toArray(List<Coordinate> coordinates) {
        return coordinates.toArray(new Coordinate[coordinates.size()]);
    }

    protected void finishGesture() throws Exception {
        this.clearShape();
        try {
            this.fireGestureFinished();
        }
        finally {
            this.coordinates.clear();
        }
    }
}

