/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DelegatingTool;
import com.vividsolutions.jump.workbench.ui.zoom.PanTool;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class MiddleMouseButtonDelegator
extends DelegatingTool {
    private final PanTool panTool = new PanTool();
    private CursorTool cursorTool = null;
    private LayerViewPanel panel;

    public MiddleMouseButtonDelegator(CursorTool _cursorTool) {
        super(_cursorTool);
        this.cursorTool = _cursorTool;
    }

    @Override
    public void activate(LayerViewPanel panel) {
        super.activate(panel);
        this.panel = panel;
        this.panTool.activate(panel);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            if (this.isOnlyMiddleMouseButton(e)) {
                this.setTool(this.panTool);
            }
            super.mousePressed(e);
        }
        catch (Exception ex) {
            this.setTool(this.cursorTool);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        try {
            super.mouseReleased(e);
        }
        finally {
            this.setTool(this.cursorTool);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isOnlyMiddleMouseButton(e) && !this.cursorTool.isMiddleMouseButtonUsed()) {
            this.panTool.mouseClicked(e);
        } else {
            super.mouseClicked(e);
        }
    }

    private boolean isOnlyMiddleMouseButton(MouseEvent e) {
        return !SwingUtilities.isLeftMouseButton(e) && SwingUtilities.isMiddleMouseButton(e) && !SwingUtilities.isRightMouseButton(e);
    }

    private void setTool(CursorTool tool) {
        if (tool == this.cursorTool) {
            // empty if block
        }
        this.panel.setCursor(tool.getCursor());
        super.setDelegate(tool);
    }
}

