/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class MeasureTool
extends MultiClickTool {
    private static final GeometryFactory gfac = new GeometryFactory();
    private static final String strDist = I18N.get("ui.cursortool.MeasureTool.dist");
    private static final String strArea = I18N.get("ui.cursortool.MeasureTool.area");
    private static final String DISPLAY_HTML = "<html><nobr>%s: <b color='blue'>%s%s / %s%s</b> %s: <b color='blue'>%s%s\u00b2</b></nobr></html>";
    private static final String TOOLTIP_HTML = "<html>%s: <b color='blue'>%s%s / %s%s</b><br>%s: <b color='blue'>%s%s\u00b2</b></html>";
    private DrawingUnit unit = null;
    private final DecimalFormat dfLength = new DecimalFormat();
    private final DecimalFormat dfArea = new DecimalFormat();
    private String strUnit = "";
    private double dblDistanceTotal;
    private double dblLastDistance;
    private double dblArea;

    public MeasureTool() {
        this.allowSnapping();
    }

    public static EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = new EnableCheckFactory(WorkbenchContext.getInstance());
        return checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck();
    }

    @Override
    public boolean useTooltip() {
        return true;
    }

    @Override
    public String getTooltip(Point2D mouseLocation) {
        return this.getHtmlMessage(TOOLTIP_HTML, this.dblDistanceTotal, this.dblLastDistance, this.dblArea);
    }

    @Override
    public void activate(LayerViewPanel panel) {
        super.activate(panel);
        this.unit = panel.getLayerManager().getTask().getDrawingUnit();
        this.strUnit = this.unit.getUnitAbbreviation();
        double dblUnitInMeter = this.unit.getUnitInMeter();
        double dblUnitInCentimeter = dblUnitInMeter * 100.0;
        int intDecPlaces = (int)Math.log10(dblUnitInCentimeter);
        this.dfLength.setGroupingUsed(false);
        this.dfLength.setMaximumFractionDigits(intDecPlaces);
        this.dfArea.setGroupingUsed(false);
        this.dfArea.setMaximumFractionDigits((intDecPlaces - 1) * 2);
        this.dblDistanceTotal = 0.0;
        this.dblDistanceTotal = 0.0;
        this.dblArea = 0.0;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"common_measure.svg");
    }

    @Override
    public Cursor createCursor() {
        return MeasureTool.createCursor(IconLoader.svgIconCursortool((String)"cursor_measure.svg").getImage());
    }

    @Override
    public void mouseLocationChanged(MouseEvent e) {
        super.mouseLocationChanged(e);
        try {
            List<Coordinate> lstCoord = this.getCoordinates();
            if (this.isShapeOnScreen() && lstCoord.size() > 0) {
                ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(lstCoord);
                currentCoordinates.add(this.getTentativeCoordinate());
                this.display(currentCoordinates);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        this.display(this.getCoordinates());
    }

    private void display(List coordinates) throws NoninvertibleTransformException {
        if (coordinates.size() < 2) {
            return;
        }
        this.display(this.getDisplayHtml(coordinates));
    }

    private String getDisplayHtml(List coordinates) throws NoninvertibleTransformException {
        Task task = this.getTaskFrame().getTask();
        CRSDefinition crsDef = task.getCRSDefinition();
        ArrayList lstLastCoords = new ArrayList();
        lstLastCoords.add(coordinates.get(coordinates.size() - 2));
        lstLastCoords.add(coordinates.get(coordinates.size() - 1));
        double tmpArea = -1.0;
        if (coordinates.size() > 2) {
            ArrayList lstRing = new ArrayList(coordinates);
            lstRing.add(coordinates.get(0));
            LinearRing lring = gfac.createLinearRing(lstRing.toArray(new Coordinate[0]));
            Polygon poly = gfac.createPolygon(lring, null);
            tmpArea = poly.getArea();
            if (task.isProjectionReductionActive()) {
                Point centerPoint = poly.getCentroid();
                Coordinate centerAreaCoord = new Coordinate(centerPoint.getX(), centerPoint.getY());
                tmpArea = crsDef.getRealWorldArea(poly.getArea(), task.getHeightReduction(), centerAreaCoord, this.unit);
            }
        } else {
            tmpArea = 0.0;
        }
        this.dblArea = tmpArea;
        double tmpLastDistance = ConstSupport.getLength(lstLastCoords);
        if (task.isProjectionReductionActive()) {
            double tmpDistanceTotal = 0.0;
            Coordinate coordLastCenter = CoordUtil.average(lstLastCoords);
            double height = task.getHeightReduction();
            double lastDistanceConverted = crsDef.getRealWorldDistance(tmpLastDistance, height, coordLastCenter, this.unit);
            for (int i = 1; i < coordinates.size(); ++i) {
                Coordinate coord1 = (Coordinate)coordinates.get(i - 1);
                Coordinate coord2 = (Coordinate)coordinates.get(i);
                Coordinate coordCenter = CoordUtil.average(coord1, coord2);
                double dist = coord1.distance(coord2);
                double distanceConverted = crsDef.getRealWorldDistance(dist, height, coordCenter, this.unit);
                tmpDistanceTotal += distanceConverted;
            }
            this.dblDistanceTotal = tmpDistanceTotal;
            this.dblLastDistance = lastDistanceConverted;
        } else {
            this.dblDistanceTotal = ConstSupport.getLength((List)coordinates);
            this.dblLastDistance = ConstSupport.getLength(lstLastCoords);
        }
        return this.getHtmlMessage(DISPLAY_HTML, this.dblDistanceTotal, this.dblLastDistance, this.dblArea);
    }

    private String getHtmlMessage(String msg, double distance, double lastDistance, double area) {
        StringBuilder sb = new StringBuilder();
        try (Formatter fmt = new Formatter(sb);){
            fmt.format(msg, strDist, this.dfLength.format(distance), this.strUnit, this.dfLength.format(lastDistance), this.strUnit, strArea, this.dfArea.format(area), this.strUnit);
        }
        return sb.toString();
    }

    private void display(String strDisplay) {
        WorkbenchContext.getFrame().setMemoryMessage(strDisplay);
    }
}

