/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import de.riwagis.geotools.feature.RenderPointSpec;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DragTool
extends AbstractCursorTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DragTool.class);
    public static final int DEFAULT_VIEW_CLICK_BUFFER = 2;
    private final GeometryEditor geometryEditor = new GeometryEditor();
    private int viewClickBuffer = 2;
    protected Coordinate modelSource = null;
    protected Coordinate modelDestination = null;
    private boolean dragApproved = false;

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.checkMouseButton(e)) {
            super.mousePressed(e);
            this.dragApproved = true;
            try {
                this.setViewSource(e.getPoint());
            }
            catch (NoninvertibleTransformException x) {
                this.getPanel().getContext().handleThrowable(x);
            }
        }
    }

    protected boolean checkMouseButton(MouseEvent e) {
        if (e.getButton() == 1) {
            return true;
        }
        if (this.isRightMouseButtonUsed() && e.getButton() == 3) {
            return true;
        }
        return this.isMiddleMouseButtonUsed() && e.getButton() == 2;
    }

    protected boolean isDragApproved() {
        return this.dragApproved;
    }

    protected void setViewClickBuffer(int clickBuffer) {
        this.viewClickBuffer = clickBuffer;
    }

    protected boolean wasClick() {
        try {
            return this.getViewSource().distance(this.getViewDestination()) <= 2.0;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Envelope getBoxInModelCoordinates() {
        double minX = Math.min(this.getModelSource().x, this.getModelDestination().x);
        double maxX = Math.max(this.getModelSource().x, this.getModelDestination().x);
        double minY = Math.min(this.getModelSource().y, this.getModelDestination().y);
        double maxY = Math.max(this.getModelSource().y, this.getModelDestination().y);
        if (this.wasClick()) {
            minX -= this.modelClickBuffer();
            maxX += this.modelClickBuffer();
            minY -= this.modelClickBuffer();
            maxY += this.modelClickBuffer();
        }
        return new Envelope(minX, maxX, minY, maxY);
    }

    protected double modelClickBuffer() {
        return (double)this.viewClickBuffer / this.getPanel().getViewport().getScale();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        try {
            if (!this.dragApproved) {
                return;
            }
            this.setViewDestination(e.getPoint());
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected Coordinate getModelSource() {
        return this.modelSource;
    }

    protected Coordinate getModelDestination() {
        return this.modelDestination;
    }

    protected void setModelSource(Coordinate source) {
        this.modelSource = source;
    }

    protected void setViewSource(Point2D source) throws NoninvertibleTransformException {
        this.setModelSource(this.getPanel().getViewport().toModelCoordinate(source));
    }

    protected void setViewDestination(Point2D destination) throws NoninvertibleTransformException {
        this.setModelDestination(this.getPanel().getViewport().toModelCoordinate(destination));
    }

    protected void setModelDestination(Coordinate destination) {
        this.modelDestination = this.snap(destination);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        try {
            if (this.checkMouseButton(e)) {
                boolean dragComplete = this.isShapeOnScreen();
                this.clearShape();
                if (dragComplete) {
                    this.fireGestureFinished();
                }
                this.dragApproved = false;
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected Shape getShape() throws Exception {
        return this.getShape(this.getViewSource(), this.getViewDestination());
    }

    protected Point2D getViewSource() throws NoninvertibleTransformException {
        return this.getPanel().getViewport().toViewPoint(this.getModelSource());
    }

    protected Point2D getViewDestination() throws NoninvertibleTransformException {
        return this.getPanel().getViewport().toViewPoint(this.getModelDestination());
    }

    protected Shape getShape(Point2D source, Point2D destination) throws Exception {
        double minX = Math.min(source.getX(), destination.getX());
        double minY = Math.min(source.getY(), destination.getY());
        double maxX = Math.max(source.getX(), destination.getX());
        double maxY = Math.max(source.getY(), destination.getY());
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    protected void processIfSelected(RenderPointSpec spec, Shape[] shapes, Geometry filteredGeometry, Consumer<Shape> consumer) {
        List<Geometry> plainGeos = this.geometryEditor.flatten(filteredGeometry);
        if (spec == null) {
            return;
        }
        for (Shape sape : shapes) {
            if (sape == null || !plainGeos.contains(spec.getSource())) continue;
            consumer.accept(sape);
        }
    }
}

