/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DelegatingCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.ModifierKeySpec;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DeleteVertexTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.InsertVertexTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.MoveVertexTool;
import com.vividsolutions.jump.workbench.ui.cursortool.hovering.HoverType;
import com.vividsolutions.jump.workbench.ui.cursortool.hovering.HoveredElement;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingListener;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.Java2DConverter;
import com.vividsolutions.jump.workbench.ui.selection.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.zoom.PanTool;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextualHoverTool
extends AbstractCursorTool
implements DelegatingCursorTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextualHoverTool.class);
    private static final String ENABLE_CONTEXTUAL_HOVERING = "enable_contextual_hovering";
    private static final int HOTSPOT_RANGE = 5;
    private final CursorTool wrappedTool;
    private final MoveVertexTool moveVertexTool = new MoveVertexTool(EnableCheckFactory.getInstance());
    private final InsertVertexTool insertVertexTool = new InsertVertexTool(EnableCheckFactory.getInstance());
    private final DeleteVertexTool deleteVertexTool = new DeleteVertexTool(EnableCheckFactory.getInstance());
    private final Set<CursorTool> editorTools = Set.of(this.moveVertexTool, this.insertVertexTool, this.deleteVertexTool);
    private final ZoomTool zoomTool = new ZoomTool();
    private final PanTool panTool = new PanTool();
    private final Map<Pair<ModifierKeySpec, HoverType>, CursorTool> hoverContextTools = new HashMap<Pair<ModifierKeySpec, HoverType>, CursorTool>();
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final ModifierKeySpec defaultModifiers = new ModifierKeySpec(false, false, false);
    private final Coordinate hoveredCoordinate = new Coordinate(0.0, 0.0);
    private final InsertVertexTool.SegmentUtilities segmentUtilities = new InsertVertexTool.SegmentUtilities();
    private final RenderingListener renderingListener = new RenderingListener(){

        @Override
        public void renderingStarted(LayerViewPanel panel) {
        }

        @Override
        public void renderingStopped(LayerViewPanel panel) {
            SwingUtilities.invokeLater(() -> ContextualHoverTool.this.updateHoveringsAndRedraw(panel.getMousePosition()));
        }
    };
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.keyStateChanged(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.keyStateChanged(e);
        }

        private void keyStateChanged(KeyEvent e) {
            ContextualHoverTool.this.lastModifierState = new ModifierKeySpec(e);
            if (!ContextualHoverTool.this.mouseDown) {
                ContextualHoverTool.this.updateToolAndRedraw();
            }
        }
    };
    private final WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowDeactivated(WindowEvent e) {
            ContextualHoverTool.this.lastModifierState = ContextualHoverTool.this.defaultModifiers;
            ContextualHoverTool.this.updateTool();
        }
    };
    private WorkbenchFrame currentFrame;
    private ModifierKeySpec lastModifierState = new ModifierKeySpec(false, false, false);
    private CursorTool currentTool;
    private boolean mouseDown = false;
    private boolean enabled = true;
    private Set<HoveredElement> hoveredElements = new HashSet<HoveredElement>();
    private final WrappedAssistantPanel wrappedAssistantPanel;

    public ContextualHoverTool(CursorTool wrappedTool) {
        this.wrappedTool = wrappedTool;
        this.currentTool = wrappedTool;
        this.wrappedAssistantPanel = new WrappedAssistantPanel();
        Optional<Boolean> _false = Optional.of(false);
        Optional<Boolean> _true = Optional.of(true);
        Optional<Boolean> _all = Optional.empty();
        this.addHoverContextTool(_false, _all, _false, HoverType.VERTEX, this.moveVertexTool);
        this.addHoverContextTool(_true, _all, _all, HoverType.VERTEX, this.deleteVertexTool);
        this.addHoverContextTool(_all, _all, _true, HoverType.LINE, this.insertVertexTool);
        this.addHoverContextTool(_all, _all, _true, null, this.zoomTool);
        this.addHoverContextTool(_true, _all, _true, null, this.panTool);
        this.setColor(new Color(58, 197, 232, 255));
        this.allowSnapping();
        this.enabled = PersistentBlackboardPlugIn.get().get(ENABLE_CONTEXTUAL_HOVERING, false);
    }

    private void addHoverContextTool(Optional<Boolean> ctrlPressed, Optional<Boolean> shiftPressed, Optional<Boolean> altPressed, HoverType type, CursorTool tool) {
        Optional<Boolean> _false = Optional.of(false);
        Optional<Boolean> _true = Optional.of(true);
        ctrlPressed.ifPresentOrElse(ctrl -> shiftPressed.ifPresentOrElse(shift -> altPressed.ifPresentOrElse(alt -> this.hoverContextTools.put((Pair<ModifierKeySpec, HoverType>)Pair.of((Object)new ModifierKeySpec((boolean)ctrl, (boolean)shift, (boolean)alt), (Object)((Object)type)), tool), () -> {
            this.addHoverContextTool(ctrlPressed, shiftPressed, _true, type, tool);
            this.addHoverContextTool(ctrlPressed, shiftPressed, _false, type, tool);
        }), () -> {
            this.addHoverContextTool(ctrlPressed, _true, altPressed, type, tool);
            this.addHoverContextTool(ctrlPressed, _false, altPressed, type, tool);
        }), () -> {
            this.addHoverContextTool(_true, shiftPressed, altPressed, type, tool);
            this.addHoverContextTool(_false, shiftPressed, altPressed, type, tool);
        });
    }

    private void updateTool() {
        Optional hover = this.hoveredElements.stream().findFirst();
        Supplier<CursorTool> quasiToolsOrDelegate = () -> Optional.ofNullable(this.hoverContextTools.get(Pair.of((Object)this.lastModifierState, null))).orElse(this.wrappedTool);
        Supplier<CursorTool> defaultOrInnerTool = () -> hover.map(h -> this.hoverContextTools.get(Pair.of((Object)this.defaultModifiers, (Object)((Object)h.getType())))).orElseGet(quasiToolsOrDelegate);
        CursorTool modifierToolOrDefault = hover.map(h -> this.hoverContextTools.get(Pair.of((Object)this.lastModifierState, (Object)((Object)h.getType())))).orElseGet(defaultOrInnerTool);
        this.setCurrentTool(modifierToolOrDefault);
    }

    private void setCurrentTool(CursorTool newTool) {
        if (this.currentTool != newTool) {
            boolean oldActive = this.currentTool.isActive();
            boolean newActive = newTool.isActive();
            if (oldActive) {
                this.currentTool.deactivate();
            }
            this.currentTool = newTool;
            if (oldActive && !newActive) {
                newTool.activate(this.getPanel());
            }
            this.getPanel().setCursor(newTool.getCursor());
        }
    }

    private void updateHoveredElements(java.awt.Point mousePos) throws NoninvertibleTransformException {
        if (mousePos == null || !this.enabled) {
            this.hoveredCoordinate.setCoordinate(new Coordinate(0.0, 0.0));
            this.hoveredElements.clear();
            return;
        }
        this.hoveredCoordinate.setCoordinate(this.snap(this.getPanel().getViewport().toModelCoordinate(mousePos)));
        Collection<Layer> candidateLayers = this.getPanel().getLayerManager().getLayers();
        Envelope env = this.getHotspot(this.hoveredCoordinate);
        Map<Layer, Collection<SimpleFeature>> layerToFeaturesInFenceMap = SpecifyFeaturesTool.layerToSpecifiedFeaturesMap(candidateLayers, env);
        this.hoveredElements = Optional.ofNullable(layerToFeaturesInFenceMap.keySet().stream().filter(Layer::isEditable).flatMap(layer -> ((Collection)layerToFeaturesInFenceMap.get(layer)).stream().map(element -> Pair.of((Object)layer, (Object)element))).map(pair -> this.mapToHoveredElement((SimpleFeature)pair.getRight(), env, this.hoveredCoordinate, (Layer)pair.getLeft())).filter(el -> el.getType() != HoverType.FEATURE).collect(Collectors.groupingBy(HoveredElement::getType, TreeMap::new, Collectors.toSet())).firstEntry()).map(Map.Entry::getValue).orElse(Collections.emptySet());
    }

    private HoveredElement mapToHoveredElement(SimpleFeature feature, Envelope env, Coordinate modelCoord, Layer layer) {
        Point hoveredGeometry;
        HoverType type;
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        ArrayList verticesHovered = new ArrayList();
        geometry.apply(coord -> {
            if (env.contains(coord)) {
                verticesHovered.add(coord);
            }
        });
        if (!verticesHovered.isEmpty()) {
            type = HoverType.VERTEX;
            hoveredGeometry = this.geometryFactory.createPoint((Coordinate)verticesHovered.get(0));
        } else {
            LineSegment segmentInRange = this.segmentUtilities.segmentInRange(geometry, modelCoord, this.getScaledHotspotRange());
            if (segmentInRange != null) {
                type = HoverType.LINE;
                Geometry[] combined = new Geometry[]{segmentInRange.toGeometry(this.geometryFactory), this.geometryFactory.createPoint(this.segmentUtilities.newVertex(segmentInRange, modelCoord, this.getPanel().getViewport().getScale()))};
                hoveredGeometry = this.geometryFactory.createGeometryCollection(combined);
            } else {
                hoveredGeometry = geometry;
                type = HoverType.FEATURE;
            }
        }
        return new HoveredElement(layer, feature, type, (Geometry)hoveredGeometry);
    }

    private Envelope getHotspot(Coordinate mousePosition) {
        double hotspot = this.getScaledHotspotRange();
        double minX = mousePosition.x - hotspot;
        double maxX = mousePosition.x + hotspot;
        double minY = mousePosition.y - hotspot;
        double maxY = mousePosition.y + hotspot;
        return new Envelope(minX, maxX, minY, maxY);
    }

    private double getScaledHotspotRange() {
        return 5.0 / this.getPanel().getViewport().getScale();
    }

    private void unselectNonHoveredElements() {
        SelectionManager selectionManager = this.getPanel().getSelectionManager();
        FeatureSelection selection = selectionManager.getFeatureSelection();
        Set hoveredFeatures = this.hoveredElements.stream().map(he -> he.getFeature()).collect(Collectors.toSet());
        selection.getLayersWithSelectedItems().stream().flatMap(layer -> selection.getFeaturesWithSelectedItems((Layer)layer).stream().map(f -> Pair.of((Object)layer, (Object)f))).filter(pair -> !hoveredFeatures.contains(pair.getRight())).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet()))).forEach(selection::unselectItems);
    }

    private void selectHoveredElements() {
        SelectionManager selectionManager = this.getPanel().getSelectionManager();
        FeatureSelection selection = selectionManager.getFeatureSelection();
        Collection<SimpleFeature> featuresWithSelectedItems = selection.getFeaturesWithSelectedItems();
        this.hoveredElements.stream().filter(h -> !featuresWithSelectedItems.contains(h.getFeature())).collect(Collectors.groupingBy(HoveredElement::getLayer, Collectors.mapping(HoveredElement::getFeature, Collectors.toSet()))).forEach(selection::selectItems);
    }

    private void updateToolAndRedraw() {
        try {
            CursorTool oldTool = this.currentTool;
            this.updateTool();
            if (this.enabled && oldTool != this.currentTool && (oldTool == this.wrappedTool || this.currentTool == this.wrappedTool)) {
                this.redrawShape();
            }
        }
        catch (Exception t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private void updateHoveringsAndRedraw(java.awt.Point mousePos) {
        try {
            this.updateHoveredElements(mousePos);
            this.updateTool();
            if (this.enabled) {
                this.redrawShape();
            }
        }
        catch (Exception t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        PersistentBlackboardPlugIn.get().put(ENABLE_CONTEXTUAL_HOVERING, enabled);
    }

    @Override
    public Icon getIcon() {
        return this.currentTool.getIcon();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.currentTool.deactivate();
        if (this.currentFrame != null) {
            this.currentFrame.removeEasyKeyListener(this.keyListener);
            this.currentFrame.removeWindowListener(this.windowListener);
        }
        this.getPanel().getRenderingManager().removeRenderingListener(this.renderingListener);
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        this.currentTool.activate(layerViewPanel);
        this.currentFrame = ContextualHoverTool.workbenchFrame(this.getPanel());
        if (this.currentFrame != null) {
            this.currentFrame.addEasyKeyListener(this.keyListener);
            this.currentFrame.addWindowListener(this.windowListener);
        }
        this.getPanel().getRenderingManager().addRenderingListener(this.renderingListener);
    }

    @Override
    protected Shape getShape() throws Exception {
        GeneralPath path = new GeneralPath();
        if (this.hoveredElements.isEmpty() || this.mouseDown || this.currentTool == this.wrappedTool) {
            return path;
        }
        Java2DConverter java2DConverter = this.getPanel().getJava2DConverter();
        for (HoveredElement h : this.hoveredElements) {
            path.append(java2DConverter.toShape(h.getHoveredGeometry()), false);
        }
        return path;
    }

    @Override
    protected void gestureFinished() throws Exception {
    }

    @Override
    public boolean isMiddleMouseButtonUsed() {
        return this.currentTool.isMiddleMouseButtonUsed();
    }

    @Override
    public boolean isRightMouseButtonUsed() {
        return this.currentTool.isRightMouseButtonUsed();
    }

    @Override
    public boolean isGestureInProgress() {
        return this.currentTool.isGestureInProgress();
    }

    @Override
    public Cursor getCursor() {
        return this.currentTool.getCursor();
    }

    @Override
    public boolean isActive() {
        return this.currentTool.isActive();
    }

    @Override
    public KeyListener getKeyListener() {
        return this.currentTool.getKeyListener();
    }

    @Override
    public JPanel getAssistentPanel() {
        return this.wrappedAssistantPanel.getAssistantPanel(this.currentTool.getAssistentPanel());
    }

    @Override
    public String getName() {
        return this.currentTool.getName();
    }

    @Override
    public void cancelGesture() {
        super.cancelGesture();
        this.currentTool.cancelGesture();
    }

    @Override
    public String getTooltip(Point2D mouseLocation) {
        return this.currentTool.getTooltip(mouseLocation);
    }

    @Override
    public boolean useTooltip() {
        return this.currentTool.useTooltip();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        this.currentTool.mouseMoved(e);
        this.updateHoveringsAndRedraw(e.getPoint());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.mouseDown = true;
        this.updateSelectionIfEditing(e);
        this.currentTool.mousePressed(e);
    }

    public void updateSelectionIfEditing(MouseEvent e) {
        boolean editorToolActive = this.editorTools.contains(this.currentTool);
        boolean forceKeepSelection = this.lastModifierState.isNeedsShift();
        boolean leftButtonPressed = SwingUtilities.isLeftMouseButton(e);
        if (!editorToolActive || !leftButtonPressed || forceKeepSelection) {
            return;
        }
        this.unselectNonHoveredElements();
        this.selectHoveredElements();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.currentTool.mouseReleased(e);
        this.mouseDown = false;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        this.currentTool.mouseExited(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        this.currentTool.mouseEntered(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        this.currentTool.mouseDragged(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        this.currentTool.mouseClicked(e);
        if (e.getClickCount() == 2 && this.currentTool != this.wrappedTool) {
            this.wrappedTool.mouseClicked(e);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        super.mouseWheelMoved(e);
        this.currentTool.mouseWheelMoved(e);
    }

    @Override
    public CursorTool getDelegate() {
        return this.currentTool;
    }

    @Override
    public void setDelegate(CursorTool delegate) {
        throw new UnsupportedOperationException("Setting the cursor tool from the outside is not allowed on the ContextualHoverTool.");
    }

    private class WrappedAssistantPanel {
        private final JCheckBox cboHoverToolEnabled = new JCheckBox(I18N.get("ui.cursortool.ContextualHoverTool.label-enable"));
        private final JPanel pnlHoverAndBoxedAssistant;

        public WrappedAssistantPanel() {
            this.cboHoverToolEnabled.setToolTipText(I18N.get("ui.cursortool.ContextualHoverTool.tooltip-enable"));
            this.cboHoverToolEnabled.addActionListener(e -> ContextualHoverTool.this.setEnabled(this.cboHoverToolEnabled.isSelected()));
            this.pnlHoverAndBoxedAssistant = new JPanel();
            this.pnlHoverAndBoxedAssistant.setLayout(new BorderLayout());
        }

        JPanel getAssistantPanel(JPanel wrappedComponent) {
            this.cboHoverToolEnabled.setSelected(ContextualHoverTool.this.isEnabled());
            this.pnlHoverAndBoxedAssistant.removeAll();
            this.pnlHoverAndBoxedAssistant.add((Component)this.cboHoverToolEnabled, "First");
            this.pnlHoverAndBoxedAssistant.add((Component)wrappedComponent, "Center");
            return this.pnlHoverAndBoxedAssistant;
        }
    }
}

