/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import java.awt.Cursor;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JPanel;

public abstract class CompositeTool
implements CursorTool {
    protected ArrayList cursorTools = new ArrayList();
    private LayerViewPanel panel = null;

    public CompositeTool(CursorTool[] cursorTools) {
        this.cursorTools = new ArrayList<CursorTool>(Arrays.asList(cursorTools));
    }

    @Override
    public void deactivate() {
        for (CursorTool tool : this.cursorTools) {
            tool.deactivate();
        }
    }

    @Override
    public boolean isActive() {
        Iterator i = this.cursorTools.iterator();
        if (i.hasNext()) {
            CursorTool tool = (CursorTool)i.next();
            return tool.isActive();
        }
        return false;
    }

    @Override
    public Cursor getCursor() {
        for (CursorTool cursorTool : this.cursorTools) {
            if (cursorTool.getCursor() == Cursor.getDefaultCursor()) continue;
            return cursorTool.getCursor();
        }
        return Cursor.getDefaultCursor();
    }

    @Override
    public boolean useTooltip() {
        for (CursorTool cursorTool : this.cursorTools) {
            if (!cursorTool.useTooltip()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTooltip(Point2D mouseLocation) {
        Object strTooltip = "";
        for (CursorTool cursorTool : this.cursorTools) {
            String strTemp = cursorTool.getTooltip(mouseLocation);
            if (strTemp == null) continue;
            if (((String)strTooltip).trim().length() > 0) {
                strTooltip = (String)strTooltip + "<br>";
            }
            strTooltip = (String)strTooltip + strTemp;
        }
        if (((String)strTooltip).trim().length() == 0) {
            strTooltip = null;
        }
        strTooltip = "<html>" + (String)strTooltip + "</html>";
        return strTooltip;
    }

    @Override
    public boolean isRightMouseButtonUsed() {
        for (CursorTool cursorTool : this.cursorTools) {
            if (!cursorTool.isRightMouseButtonUsed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMiddleMouseButtonUsed() {
        for (CursorTool cursorTool : this.cursorTools) {
            if (!cursorTool.isMiddleMouseButtonUsed()) continue;
            return true;
        }
        return false;
    }

    protected CursorTool firstCursorTool() {
        return (CursorTool)this.cursorTools.get(0);
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        this.panel = layerViewPanel;
        for (CursorTool tool : this.cursorTools) {
            tool.activate(layerViewPanel);
        }
    }

    public CompositeTool add(CursorTool tool) {
        this.cursorTools.add(tool);
        return this;
    }

    @Override
    public void cancelGesture() {
        for (CursorTool tool : this.cursorTools) {
            tool.cancelGesture();
        }
    }

    @Override
    public Icon getIcon() {
        for (CursorTool tool : this.cursorTools) {
            if (tool.getIcon() == null) continue;
            return tool.getIcon();
        }
        return null;
    }

    protected String getName(String delimiter) {
        Object name = "";
        for (int i = 0; i < this.cursorTools.size(); ++i) {
            if (i > 0) {
                name = (String)name + " " + delimiter + " ";
            }
            name = (String)name + ((CursorTool)this.cursorTools.get(i)).getName();
        }
        return name;
    }

    @Override
    public boolean isGestureInProgress() {
        for (CursorTool tool : this.cursorTools) {
            if (!tool.isGestureInProgress()) continue;
            return true;
        }
        return false;
    }

    public LayerViewPanel getPanel() {
        return this.panel;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public JPanel getAssistentPanel() {
        for (CursorTool tool : this.cursorTools) {
            if (tool.getAssistentPanel() == null) continue;
            return tool.getAssistentPanel();
        }
        return null;
    }

    @Override
    public KeyListener getKeyListener() {
        return null;
    }
}

