/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.ui.FlashOptions;
import com.vividsolutions.jump.workbench.ui.FlashStyle;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.buffer.BufferOp;

public class Animations {
    private static GeometryCollection drawRings(Collection<Point2D> centers, int radius, LayerViewPanel panel) {
        try {
            GeometryFactory gfac = JTSFactoryFinder.getGeometryFactory();
            Viewport viewport = panel.getViewport();
            Geometry[] circles = new Geometry[centers.size()];
            int current = 0;
            for (Point2D center : centers) {
                Point p = gfac.createPoint(viewport.toModelCoordinate(center));
                if (radius == 0) {
                    circles[current] = p;
                    continue;
                }
                Polygon circle = (Polygon)BufferOp.bufferOp((Geometry)p, (double)((double)radius / viewport.getScale()), (int)19);
                circles[current] = circle.getExteriorRing();
            }
            return gfac.createGeometryCollection(circles);
        }
        catch (NoninvertibleTransformException ex) {
            throw new IllegalStateException("Could not transform circles for animation", ex);
        }
    }

    public static void drawExpandingRing(Point2D center, boolean expanding, Color color, LayerViewPanel panel, float[] dash) {
        Animations.drawExpandingRings(Collections.singletonList(center), expanding, color, panel, dash);
    }

    public static void drawExpandingRings(Collection<Point2D> centers, boolean expanding, Color color, LayerViewPanel panel, float[] dash) {
        BasicStroke stroke = new BasicStroke(5.0f, 0, 1, 10.0f, dash, 0.0f);
        Stream<FlashStyle> keyframes = Animations.getFrameKeys(expanding).mapToObj(i -> new FlashStyle(Animations.drawRings(centers, i * 10, panel), color, stroke));
        panel.flash(FlashOptions.createKeyframedFlash(60, keyframes));
    }

    private static IntStream getFrameKeys(boolean expanding) {
        if (expanding) {
            return IntStream.rangeClosed(0, 2);
        }
        return IntStream.of(2, 1, 0);
    }

    private Animations() {
    }
}

