/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DelegatingCursorTool;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingSupport;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import com.vividsolutions.jump.workbench.ui.snap.SnapPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToFeaturesPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToGridPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToIntersectionPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToVerticesPolicy;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCursorTool
implements CursorTool {
    private static Logger LOG = LoggerFactory.getLogger(AbstractCursorTool.class);
    private static final GeometryFactory gfac = new GeometryFactory();
    private boolean active = false;
    private boolean snappingConfigured = false;
    private boolean configuringSnapping = false;
    private Object keyAntiAliasing = null;
    private boolean controlPressed;
    private boolean shiftPressed;
    private Color color = Color.BLUE;
    private boolean filling = false;
    private Shape lastShapeDrawn;
    private static final Lock lock = new ReentrantLock();
    private final LayerViewPanelListener layerViewPanelListener = new LayerViewPanelListener(){

        @Override
        public void cursorPositionChanged(String x, String y) {
        }

        @Override
        public void painted(Graphics graphics) {
            try {
                lock.lock();
                if (AbstractCursorTool.this.shapeOnScreen) {
                    AbstractCursorTool.this.setShapeOnScreen(false);
                    AbstractCursorTool.this.redrawShape((Graphics2D)graphics);
                }
            }
            catch (Throwable t) {
                AbstractCursorTool.this.panel.getContext().handleThrowable(t);
            }
            finally {
                lock.unlock();
            }
        }
    };
    private Color originalColor;
    private Stroke originalStroke;
    private LayerViewPanel panel;
    private boolean shapeOnScreen = false;
    private final SnapManager snapManager = new SnapManager();
    private Stroke stroke = new BasicStroke(1.0f);
    private final Collection<Listener> listeners = new ArrayList<Listener>();
    private Cursor cursor;
    private static Envelope delayedWheelZoomEnv = null;
    private static LayerViewPanel delayedWheelPanel = null;
    private static final Timer delayedWheelZoom = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                delayedWheelPanel.getViewport().zoom(delayedWheelZoomEnv);
                delayedWheelZoom.stop();
            }
            catch (Exception ex) {
                LOG.info("scrolling failed - " + ex.getMessage());
            }
        }
    });

    @Override
    public synchronized void mouseWheelMoved(MouseWheelEvent e) {
        delayedWheelZoom.stop();
        try {
            int i = e.getWheelRotation();
            if (i > 20) {
                i = 20;
            }
            if (i < -20) {
                i = -20;
            }
            double factor = (double)i * 0.2;
            Point2D ptMouse = this.getPanel().getViewport().toModelPoint(e.getPoint());
            Envelope env = this.panel.getViewport().getEnvelopeInModelCoordinates();
            double dblDX1 = ptMouse.getX() - env.getMinX();
            double dblDX2 = env.getMaxX() - ptMouse.getX();
            double dblDY1 = ptMouse.getY() - env.getMinY();
            double dblDY2 = env.getMaxY() - ptMouse.getY();
            dblDX1 += dblDX1 * factor;
            dblDX2 += dblDX2 * factor;
            dblDY1 += dblDY1 * factor;
            dblDY2 += dblDY2 * factor;
            env = new Envelope(ptMouse.getX() - dblDX1, ptMouse.getX() + dblDX2, ptMouse.getY() - dblDY1, ptMouse.getY() + dblDY2);
            if (Double.isNaN(env.getWidth()) || Double.isNaN(env.getHeight())) {
                return;
            }
            this.panel.getViewport().zoom(env, false);
            delayedWheelPanel = this.panel;
            delayedWheelZoomEnv = env;
            delayedWheelZoom.start();
        }
        catch (Exception ex) {
            LOG.info("scrolling failed - " + ex.getMessage());
        }
    }

    public void allowSnapping() {
        this.configuringSnapping = true;
    }

    @Override
    public boolean useTooltip() {
        return false;
    }

    @Override
    public String getTooltip(Point2D mouseLocation) {
        return null;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected boolean wasShiftPressed() {
        return this.shiftPressed;
    }

    protected boolean wasControlPressed() {
        return this.controlPressed;
    }

    public static Cursor createCursor(Image image) {
        return AbstractCursorTool.createCursor(image, new Point(image.getWidth(null) / 2, image.getHeight(null) / 2));
    }

    public static Cursor createCursor(Image image, Point hotSpot) {
        return GUIUtil.createCursor(image, hotSpot);
    }

    public Cursor createCursor() {
        return this.getIcon() instanceof ImageIcon ? GUIUtil.createCursorFromIcon(((ImageIcon)this.getIcon()).getImage()) : Cursor.getDefaultCursor();
    }

    @Override
    public Cursor getCursor() {
        if (this.cursor == null) {
            this.cursor = this.createCursor();
        }
        return this.cursor;
    }

    @Override
    public boolean isGestureInProgress() {
        return this.isShapeOnScreen();
    }

    @Override
    public boolean isRightMouseButtonUsed() {
        return false;
    }

    @Override
    public boolean isMiddleMouseButtonUsed() {
        return false;
    }

    public boolean isShapeOnScreen() {
        return this.shapeOnScreen;
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        if (AbstractCursorTool.workbenchFrame(layerViewPanel) != null) {
            AbstractCursorTool.workbenchFrame(layerViewPanel).log(I18N.get("ui.cursortool.AbstractCursorTool.activating") + " " + this.getName());
        }
        if (this.panel != null) {
            this.panel.removeListener(this.layerViewPanelListener);
        }
        this.panel = layerViewPanel;
        this.panel.addListener(this.layerViewPanelListener);
        if (this.configuringSnapping && !this.snappingConfigured) {
            this.getSnapManager().addPolicies(AbstractCursorTool.createStandardSnappingPolicies(PersistentBlackboardPlugIn.get()));
            this.snappingConfigured = true;
        }
        this.active = true;
    }

    public static WorkbenchFrame workbenchFrame(LayerViewPanel layerViewPanel) {
        Window window = SwingUtilities.windowForComponent(layerViewPanel);
        return window instanceof WorkbenchFrame ? (WorkbenchFrame)window : null;
    }

    public static List<SnapPolicy> createStandardSnappingPolicies(Blackboard blackboard) {
        return Arrays.asList(new SnapToVerticesPolicy(blackboard), new SnapToIntersectionPolicy(blackboard), new SnapToFeaturesPolicy(blackboard), new SnapToGridPolicy(blackboard));
    }

    protected boolean isRollingBackInvalidEdits() {
        return JUMPWorkbench.getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false);
    }

    @Override
    public void deactivate() {
        this.cancelGesture();
        this.active = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.controlPressed = e.isControlDown();
        this.shiftPressed = e.isShiftDown();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void setColor(Color color) {
        this.color = color;
    }

    protected void setFilling(boolean filling) {
        this.filling = filling;
    }

    @Deprecated
    protected void setStrokeWidth(int strokeWidth) {
        this.setStroke(new BasicStroke(strokeWidth));
    }

    protected void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    protected LayerViewPanel getPanel() {
        return this.panel;
    }

    protected abstract Shape getShape() throws Exception;

    private Graphics2D getGraphics2D() {
        Graphics2D g = (Graphics2D)this.panel.getGraphics();
        if (g != null) {
            RenderingSupport.setRenderingHints(g, RenderingSupport.RENDERHINTS_DEFAULT);
        }
        return g;
    }

    @Override
    public void cancelGesture() {
        this.clearShape();
        this.fireGestureCanceled();
    }

    protected void drawShapeXOR(Graphics2D g) throws Exception {
        Shape newShape = this.getShape();
        this.drawShapeXOR(newShape, g);
        this.lastShapeDrawn = newShape;
    }

    private void drawShapeXOR(Shape shape, Graphics2D graphics) {
        try {
            this.setup(graphics);
            if (shape != null) {
                if (this.isShapeOnScreen()) {
                    this.getPanel().superRepaint();
                }
                if (this.filling) {
                    graphics.fill(shape);
                } else {
                    graphics.draw(shape);
                }
            }
        }
        finally {
            this.cleanup(graphics);
        }
    }

    protected void setup(Graphics2D graphics) {
        this.originalColor = graphics.getColor();
        this.originalStroke = graphics.getStroke();
        this.keyAntiAliasing = graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics.setColor(this.color);
        graphics.setStroke(this.stroke);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void cleanup(Graphics2D graphics) {
        graphics.setColor(this.originalColor);
        graphics.setStroke(this.originalStroke);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.keyAntiAliasing);
    }

    protected Coordinate snap(Point2D viewPoint) throws NoninvertibleTransformException {
        return this.snap(this.getPanel().getViewport().toModelCoordinate(viewPoint));
    }

    protected Coordinate snap(Coordinate modelCoordinate) {
        return this.snapManager.snap(this.getPanel(), modelCoordinate);
    }

    private void setShapeOnScreen(boolean shapeOnScreen) {
        this.shapeOnScreen = shapeOnScreen;
    }

    private void clearShape(Graphics2D graphics) {
        if (!this.shapeOnScreen) {
            return;
        }
        this.drawShapeXOR(this.lastShapeDrawn, graphics);
        this.setShapeOnScreen(false);
    }

    protected void clearShape() {
        try {
            lock.lock();
            Graphics2D graphics2D = this.getGraphics2D();
            if (graphics2D != null) {
                this.clearShape(graphics2D);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void redrawShape(Graphics2D graphics) throws Exception {
        this.clearShape(graphics);
        this.drawShapeXOR(graphics);
        this.setShapeOnScreen(true);
    }

    protected void redrawShape() throws Exception {
        try {
            lock.lock();
            Graphics2D graphics2D = this.getGraphics2D();
            if (graphics2D != null) {
                this.redrawShape(graphics2D);
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected TaskFrame getTaskFrame() {
        return (TaskFrame)SwingUtilities.getAncestorOfClass(TaskFrame.class, this.getPanel());
    }

    public JUMPWorkbench getWorkbench() {
        return AbstractCursorTool.workbench(this.getPanel());
    }

    public static JUMPWorkbench workbench(LayerViewPanel panel) {
        return WorkbenchContext.getWorkbench();
    }

    public boolean isUndoable() {
        return true;
    }

    protected abstract void gestureFinished() throws Exception;

    protected void fireGestureFinished() throws Exception {
        WorkbenchFrame workbenchFrame;
        this.getPanel().getContext().setStatusMessage("");
        if (this.getTaskFrame() != null && (workbenchFrame = (WorkbenchFrame)SwingUtilities.getAncestorOfClass(WorkbenchFrame.class, this.getTaskFrame())) != null) {
            workbenchFrame.log(I18N.get("ui.cursortool.AbstractCursorTool.gesture-finished") + ": " + this.getName());
        }
        this.getPanel().getLayerManager().getUndoableEditReceiver().startReceiving();
        try {
            this.gestureFinished();
        }
        finally {
            this.getPanel().getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
        for (Listener listener : this.listeners) {
            listener.gestureFinished();
        }
    }

    protected void fireGestureCanceled() {
        for (Listener listener : this.listeners) {
            listener.gestureCanceled();
        }
    }

    public void add(Listener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public boolean remove(Listener listener) {
        if (this.listeners.contains(listener)) {
            return this.listeners.remove(listener);
        }
        return false;
    }

    protected void execute(UndoableCommand command) {
        AbstractPlugIn.execute(command, (LayerManagerProxy)this.getPanel(), this.isUndoable());
    }

    protected void execute(Collection<UndoableCommand> commands) {
        AbstractPlugIn.execute(commands, (LayerManagerProxy)this.getPanel(), this.isUndoable());
    }

    public String toString() {
        return this.getName();
    }

    public static CursorTool getDelegate(CursorTool tool) {
        if (tool instanceof DelegatingCursorTool) {
            return ((DelegatingCursorTool)tool).getInnerDelegate();
        }
        return tool;
    }

    @Override
    public String getName() {
        try {
            CursorTool tool = AbstractCursorTool.getDelegate(this);
            return I18N.get(tool.getClass().getName());
        }
        catch (MissingResourceException e) {
            LOG.error(e.getMessage() + " " + this.getClass().getName());
            return StringUtil.toFriendlyName(this.getClass().getName(), I18N.get("ui.cursortool.AbstractCursorTool.tool"));
        }
    }

    protected boolean check(EnableCheck check) {
        String warning = check.check(null);
        if (warning != null) {
            this.getPanel().getContext().warnUser(warning);
            return false;
        }
        return true;
    }

    public SnapManager getSnapManager() {
        return this.snapManager;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public JPanel getAssistentPanel() {
        return null;
    }

    @Override
    public KeyListener getKeyListener() {
        return null;
    }

    public void drawSnapCross(Coordinate middlePoint, GeneralPath path, LayerViewPanel panel) throws NoninvertibleTransformException {
        if (middlePoint == null) {
            return;
        }
        if (path == null) {
            return;
        }
        if (panel == null) {
            return;
        }
        if (this.snapManager.wasSnapCoordinateFound()) {
            Point2D pt = panel.getViewport().toViewPoint(middlePoint);
            path.moveTo(pt.getX(), pt.getY() - 5.0);
            path.lineTo(pt.getX(), pt.getY() + 5.0);
            path.moveTo(pt.getX() - 5.0, pt.getY());
            path.lineTo(pt.getX() + 5.0, pt.getY());
            path.moveTo(pt.getX(), pt.getY());
        }
    }

    static {
        delayedWheelZoom.setRepeats(false);
        delayedWheelZoom.setInitialDelay(500);
    }

    public static interface Listener {
        public void gestureFinished();

        public void gestureCanceled();
    }
}

