/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;

public abstract class AbstractClickSelectedLineStringsTool
extends SpecifyFeaturesTool {
    protected static final String NO_SELECTED_LINESTRINGS_HERE_MESSAGE = "No selected LineStrings here";

    public AbstractClickSelectedLineStringsTool() {
        this.setViewClickBuffer(10);
    }

    protected void warnLayerNotEditable(Layer layer) {
        JUMPWorkbench.getFrame().warnUser(layer.getName() + " is not editable");
    }

    @Override
    public String getName() {
        return super.getName().replaceAll("Line String", "LineString");
    }

    @Override
    protected Coordinate getModelSource() {
        return this.getModelDestination();
    }

    @Override
    protected Shape getShape(Point2D source, Point2D destination) {
        return null;
    }

    protected Point getModelClickPoint() {
        return new GeometryFactory().createPoint(this.getModelDestination());
    }

    @Override
    protected void gestureFinished() throws Exception {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        if (!this.check(checkFactory.createAtLeastNLayersMustBeEditableCheck(1))) {
            return;
        }
        if (!this.check(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
            return;
        }
        Collection<SimpleFeature> nearbyLineStringFeatures = CollectionUtil.select(CollectionUtil.concatenate(this.layerToSpecifiedFeaturesMap().values()), feature -> this.getPanel().getSelectionManager().getFeaturesWithSelectedItems().contains(feature) && feature.getDefaultGeometry() instanceof LineString ? Boolean.TRUE : Boolean.FALSE);
        if (nearbyLineStringFeatures.isEmpty()) {
            JUMPWorkbench.getFrame().warnUser(NO_SELECTED_LINESTRINGS_HERE_MESSAGE);
            return;
        }
        this.gestureFinished(nearbyLineStringFeatures);
    }

    protected abstract void gestureFinished(Collection<SimpleFeature> var1) throws NoninvertibleTransformException;

    protected Layer layer(SimpleFeature feature, Map<Layer, Collection<SimpleFeature>> layerToSpecifiedFeaturesMap) {
        for (Layer layer : layerToSpecifiedFeaturesMap.keySet()) {
            Collection<SimpleFeature> features = layerToSpecifiedFeaturesMap.get(layer);
            if (!features.contains(feature)) continue;
            return layer;
        }
        Assert.shouldNeverReachHere();
        return null;
    }
}

