/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components.menutree;

import de.riwagis.icons.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeCellRenderer;

public class MenuElementTreeCellRenderer
implements TreeCellRenderer {
    private final Color highlightBackground = UIManager.getColor("Tree.selectionBackground");
    private final Color highlightForeground = Color.white;
    private final JPanel panel;
    private final JLabel label;
    private final JLabel labelIcon;
    private final ImageIcon iconUp = IconLoader.svgIcon((String)"accordeon_collapse.svg", (int)9);
    private final ImageIcon iconDown = IconLoader.svgIcon((String)"accordeon_expand.svg", (int)9);
    private final JSeparator sep;

    public MenuElementTreeCellRenderer() {
        this.panel = new JPanel(new BorderLayout());
        this.labelIcon = new JLabel();
        this.labelIcon.setBorder(new EmptyBorder(0, 0, 0, 3));
        this.sep = new JSeparator();
        this.label = new JLabel();
        this.label.setBorder(new EmptyBorder(0, 2, 0, 0));
        this.label.setHorizontalAlignment(2);
        this.panel.add((Component)this.label, "Center");
        this.panel.add((Component)this.labelIcon, "East");
        this.panel.add((Component)this.sep, "South");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.sep.setVisible(false);
        this.labelIcon.setVisible(false);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.panel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, this.panel.getBackground()));
        if (selected) {
            this.panel.setOpaque(true);
            this.panel.setBackground(this.highlightBackground);
            this.label.setForeground(this.highlightForeground);
        } else {
            this.panel.setOpaque(false);
            this.panel.setBackground(this.label.getBackground());
            this.label.setForeground(tree.getForeground());
        }
        if (value instanceof JMenuBar) {
            this.panel.setPreferredSize(new Dimension(this.panel.getPreferredSize().width, 20));
            this.label.setText("root");
        } else if (value instanceof JMenu) {
            this.labelIcon.setVisible(true);
            if (expanded) {
                this.labelIcon.setIcon(this.iconUp);
            } else {
                this.labelIcon.setIcon(this.iconDown);
            }
            if (((JMenu)value).getParent() instanceof JMenuBar) {
                if (!selected) {
                    this.panel.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, this.label.getBackground()));
                    this.panel.setOpaque(true);
                    this.panel.setBackground(new Color(221, 221, 221));
                }
                this.panel.setPreferredSize(new Dimension(this.panel.getPreferredSize().width, 32));
            } else {
                this.panel.setPreferredSize(new Dimension(this.panel.getPreferredSize().width, 25));
            }
            this.label.setFont(this.label.getFont().deriveFont(1));
            this.label.setText(((JMenu)value).getText());
            this.label.setIcon(((JMenu)value).getIcon());
        } else if (value instanceof JMenuItem) {
            this.panel.setPreferredSize(new Dimension(this.panel.getPreferredSize().width, 22));
            this.label.setText(((JMenuItem)value).getText());
            this.label.setIcon(((JMenuItem)value).getIcon());
        } else if (value instanceof JSeparator) {
            this.label.setIcon(null);
            this.label.setText("");
            this.panel.setPreferredSize(new Dimension(this.panel.getPreferredSize().width, 3));
            this.sep.setVisible(true);
        }
        return this.panel;
    }
}

