/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components.menutree;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.MenuElement;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JMenuBarTreeModel
implements TreeModel {
    private JMenuBar menuBar = null;
    private final List<TreeModelListener> lstListeners = new ArrayList<TreeModelListener>();

    public JMenuBarTreeModel(JMenuBar menuBar) {
        this.menuBar = menuBar;
    }

    @Override
    public Object getRoot() {
        return this.menuBar;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof JMenu) {
            parent = ((JMenu)parent).getPopupMenu();
        }
        return ((Container)parent).getComponent(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof JMenu) {
            parent = ((JMenu)parent).getPopupMenu();
        }
        return ((Container)parent).getComponentCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("JMenuBarTreeModel is not editable");
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof JMenu) {
            parent = ((JMenu)parent).getPopupMenu();
        }
        Component[] arrComp = ((Container)parent).getComponents();
        int i = 0;
        for (Component elem : arrComp) {
            if (elem == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void fireTreeStructureChanged(MenuElement me) {
        TreeModelEvent e = new TreeModelEvent((Object)this, new TreePath(new Object[]{this.menuBar}));
        for (TreeModelListener l : this.lstListeners) {
            l.treeStructureChanged(e);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (!this.lstListeners.contains(l)) {
            this.lstListeners.add(l);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.lstListeners.remove(l);
    }
}

