/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components.menutree;

import de.riwagis.util.gui.highdpi.HighDpiSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class AnimatedWidthTreeUI
extends BasicTreeUI {
    private final boolean showLines;
    private BufferedImage _topImage;
    private BufferedImage _bottomImage;
    private BufferedImage _compositeImage;
    private int _offsetY;
    private int _subTreeHeight;
    private final Timer _timer;
    private final ActionListener _timerListener;
    private final List<ActionListener> animationListeners = new ArrayList<ActionListener>();
    private AnimationState _animationState = AnimationState.NOT_ANIMATING;
    private float _animationComplete = 0.0f;
    public static float ANIMATION_SPEED = 0.65f;

    public AnimatedWidthTreeUI(boolean showLines) {
        this._timerListener = new TimerListener();
        this._timer = new Timer(11, this._timerListener);
        this.showLines = showLines;
    }

    @Override
    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new BasicTreeUI.NodeDimensionsHandler(){

            @Override
            public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
                Rectangle dimensions = super.getNodeDimensions(value, row, depth, expanded, size);
                int width = 180;
                if (AnimatedWidthTreeUI.this.tree != null && AnimatedWidthTreeUI.this.tree.getParent() != null) {
                    width = AnimatedWidthTreeUI.this.tree.getParent().getWidth();
                }
                dimensions.width = width - this.getRowX(row, depth);
                return dimensions;
            }
        };
    }

    @Override
    protected boolean isLargeModel() {
        return true;
    }

    @Override
    protected int getRowHeight() {
        return -1;
    }

    @Override
    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        if (this.showLines) {
            super.paintHorizontalLine(g, c, y, left, right);
        }
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        if (this.showLines) {
            super.paintVerticalPartOfLeg(g, clipBounds, insets, path);
        }
    }

    @Override
    public void toggleExpandState(TreePath path) {
        boolean state;
        if (this.tree.getModel().isLeaf(path.getLastPathComponent())) {
            return;
        }
        if (this._animationState != AnimationState.NOT_ANIMATING) {
            return;
        }
        this._animationComplete = 1.0f;
        boolean bl = state = !this.tree.isExpanded(path);
        if (state) {
            super.toggleExpandState(path);
            this._subTreeHeight = this._getSubTreeHeight(path);
            this._createImages(path);
            this._animationState = AnimationState.EXPANDING;
        } else {
            this._subTreeHeight = this._getSubTreeHeight(path);
            this._createImages(path);
            super.toggleExpandState(path);
            this._animationState = AnimationState.COLLAPSING;
        }
        this._updateCompositeImage();
        this._timer.restart();
    }

    private BufferedImage createTreeImage(int w, int h) {
        BufferedImage alphaImage = new BufferedImage(w, h, 1);
        Graphics g = alphaImage.getGraphics();
        g.setColor(this.getTreeBackgroundColor());
        g.fillRect(0, 0, alphaImage.getWidth(), alphaImage.getHeight());
        return alphaImage;
    }

    private Color getTreeBackgroundColor() {
        if (this.tree.isOpaque()) {
            return this.tree.getBackground();
        }
        if (this.tree.getParent() != null) {
            return this.tree.getParent().getBackground();
        }
        return this.tree.getBackground();
    }

    private void _createImages(TreePath path) {
        GraphicsConfiguration graphicsConfiguration = this.tree.getGraphicsConfiguration();
        int h = HighDpiSupport.scale((GraphicsConfiguration)graphicsConfiguration, (int)this.tree.getPreferredSize().height);
        int w = HighDpiSupport.scale((GraphicsConfiguration)graphicsConfiguration, (int)this.tree.getPreferredSize().width);
        BufferedImage baseImage = this.createTreeImage(w, h);
        Graphics2D g = (Graphics2D)baseImage.getGraphics();
        double scale = HighDpiSupport.getDisplayScaleFactorForDevice((GraphicsConfiguration)graphicsConfiguration);
        g.scale(scale, scale);
        this.tree.paint(g);
        int row = this.tree.getRowForPath(path) + 1;
        this._offsetY = HighDpiSupport.scale((GraphicsConfiguration)graphicsConfiguration, (int)this.tree.getRowBounds((int)row).y);
        int treeWidth = HighDpiSupport.scale((GraphicsConfiguration)graphicsConfiguration, (int)this.tree.getWidth());
        this._topImage = this.createTreeImage(treeWidth, this._offsetY);
        Graphics topG = this._topImage.getGraphics();
        topG.drawImage(baseImage, 0, 0, w, this._offsetY, 0, 0, w, this._offsetY, null);
        this._bottomImage = this.createTreeImage(w, baseImage.getHeight() - this._offsetY);
        Graphics bottomG = this._bottomImage.getGraphics();
        bottomG.drawImage(baseImage, 0, 0, w, baseImage.getHeight() - this._offsetY, 0, this._offsetY, w, baseImage.getHeight(), null);
        this._compositeImage = this.createTreeImage(w, h);
        g.dispose();
        topG.dispose();
        bottomG.dispose();
    }

    public int getRowOffset(int row, int depth) {
        return super.getRowX(row, depth);
    }

    private void _updateCompositeImage() {
        Graphics g = this._compositeImage.getGraphics();
        g.setColor(this.getTreeBackgroundColor());
        g.fillRect(0, 0, this._compositeImage.getWidth(), this._compositeImage.getHeight());
        int yOff = (int)((float)this._subTreeHeight * this._animationComplete);
        if (this._animationState == AnimationState.COLLAPSING) {
            yOff = this._subTreeHeight - yOff;
        }
        int dy1 = this._offsetY - yOff;
        g.drawImage(this._bottomImage, 0, dy1, null);
        g.drawImage(this._topImage, 0, 0, null);
        g.dispose();
    }

    private boolean _isAnimationComplete() {
        switch (this._animationState.ordinal()) {
            case 0: 
            case 1: {
                return this._animationComplete * (float)this._offsetY < 1.3f;
            }
        }
        return true;
    }

    public int _getSubTreeHeight(TreePath path) {
        if (path.getParentPath() == null) {
            return 0;
        }
        Object origObj = path.getLastPathComponent();
        if (this.getModel().getChildCount(origObj) == 0) {
            return 0;
        }
        Object firstChild = this.getModel().getChild(origObj, 0);
        TreePath firstPath = path.pathByAddingChild(firstChild);
        TreePath lastPath = this.getLastVisibleChildren(path, origObj);
        int topFirst = this.getPathBounds((JTree)this.tree, (TreePath)firstPath).y;
        int bottomLast = this.getPathBounds((JTree)this.tree, (TreePath)lastPath).y + this.getPathBounds((JTree)this.tree, (TreePath)lastPath).height;
        int height = bottomLast - topFirst;
        return HighDpiSupport.scale((GraphicsConfiguration)this.tree.getGraphicsConfiguration(), (int)height);
    }

    private TreePath getLastVisibleChildren(TreePath path, Object origObj) {
        TreeModel model = this.getModel();
        while (!model.isLeaf(origObj) && !this.tree.isCollapsed(path)) {
            origObj = model.getChild(origObj, model.getChildCount(origObj) - 1);
            path = path.pathByAddingChild(origObj);
        }
        return path;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (this._animationState != AnimationState.NOT_ANIMATING) {
            if (c.getParent() instanceof JViewport) {
                JViewport vp = (JViewport)c.getParent();
                Rectangle visibleR = vp.getViewRect();
                g.setClip(visibleR.x, visibleR.y, visibleR.width, visibleR.height);
            } else {
                g.setClip(0, 0, this._compositeImage.getWidth(), this._compositeImage.getHeight());
            }
        }
        this.paint(g, c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this._timer.stop();
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this._animationState != AnimationState.NOT_ANIMATING) {
            double scale = 1.0 / HighDpiSupport.getDisplayScaleFactorForDevice((GraphicsConfiguration)c.getGraphicsConfiguration());
            ((Graphics2D)g).scale(scale, scale);
            g.drawImage(this._compositeImage, 0, 0, null);
            return;
        }
        super.paint(g, c);
    }

    public void addAnimationReadyListener(ActionListener listener) {
        if (!this.animationListeners.contains(listener)) {
            this.animationListeners.add(listener);
        }
    }

    public void removeAnimationReadyListener(ActionListener listener) {
        this.animationListeners.remove(listener);
    }

    private void fireAnimationReady() {
        ActionEvent ae = new ActionEvent(this.tree, 0, "animation_ready");
        for (ActionListener listener : this.animationListeners) {
            listener.actionPerformed(ae);
        }
    }

    private static enum AnimationState {
        EXPANDING,
        COLLAPSING,
        NOT_ANIMATING;

    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AnimatedWidthTreeUI.this._animationComplete *= ANIMATION_SPEED;
            if (AnimatedWidthTreeUI.this._isAnimationComplete()) {
                AnimatedWidthTreeUI.this._animationState = AnimationState.NOT_ANIMATING;
                AnimatedWidthTreeUI.this._timer.stop();
                SwingUtilities.invokeLater(() -> AnimatedWidthTreeUI.this.fireAnimationReady());
            } else {
                AnimatedWidthTreeUI.this._updateCompositeImage();
            }
            if (AnimatedWidthTreeUI.this.tree.getParent() != null) {
                AnimatedWidthTreeUI.this.tree.getParent().repaint();
            }
            AnimatedWidthTreeUI.this.tree.repaint();
        }
    }
}

