/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components.menutree;

import com.vividsolutions.jump.workbench.ui.components.menutree.AnimatedWidthTreeUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public class AnimatedWidthTree
extends JTree {
    private final List<ActionListener> animationListeners = new ArrayList<ActionListener>();
    private final boolean showLines;
    private final Icon expandedIcon;
    private final Icon collapsedIcon;
    private final int childIndent;
    private final ActionListener animationReadyListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AnimatedWidthTree.this.reactivateUI();
        }
    };

    public AnimatedWidthTree(Container parent, boolean showLines, Icon expandedIcon, Icon collapsedIcon, int childIndent) {
        this.reactivateUI();
        this.setLargeModel(true);
        this.setRowHeight(-1);
        this.setToggleClickCount(1);
        this.showLines = showLines;
        this.expandedIcon = expandedIcon;
        this.collapsedIcon = collapsedIcon;
        this.childIndent = childIndent;
        parent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AnimatedWidthTree.this.reactivateUI();
                AnimatedWidthTree.updateRendererOrEditorUI(AnimatedWidthTree.this.getCellEditor());
                AnimatedWidthTree.updateRendererOrEditorUI(AnimatedWidthTree.this.getCellRenderer());
            }
        });
    }

    protected void reactivateUI() {
        AnimatedWidthTreeUI aui = new AnimatedWidthTreeUI(this.showLines);
        aui.addAnimationReadyListener(this.animationReadyListener);
        for (ActionListener listener : this.animationListeners) {
            aui.addAnimationReadyListener(listener);
        }
        this.setUI(aui);
        aui.setLeftChildIndent(this.childIndent);
        aui.setRightChildIndent(this.childIndent);
        aui.setExpandedIcon(this.expandedIcon);
        aui.setCollapsedIcon(this.collapsedIcon);
    }

    protected static void updateRendererOrEditorUI(Object rendererOrEditor) {
        if (rendererOrEditor == null) {
            return;
        }
        Component component = null;
        if (rendererOrEditor instanceof Component) {
            component = (Component)rendererOrEditor;
        }
        if (rendererOrEditor instanceof DefaultCellEditor) {
            component = ((DefaultCellEditor)rendererOrEditor).getComponent();
        }
        if (component != null) {
            SwingUtilities.updateComponentTreeUI(component);
        }
    }

    public void addAnimationReadyListener(ActionListener listener) {
        if (!this.animationListeners.contains(listener)) {
            this.animationListeners.add(listener);
            if (this.getUI() instanceof AnimatedWidthTreeUI) {
                ((AnimatedWidthTreeUI)this.getUI()).addAnimationReadyListener(listener);
            }
        }
    }

    public void removeAnimationReadyListener(ActionListener listener) {
        this.animationListeners.remove(listener);
        if (this.getUI() instanceof AnimatedWidthTreeUI) {
            ((AnimatedWidthTreeUI)this.getUI()).removeAnimationReadyListener(listener);
        }
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null) {
            super.updateUI();
        } else {
            this.reactivateUI();
        }
    }
}

