/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.ui.editor;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.FilterableTableHeader;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.choices.Choice;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.choices.DateChoice;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.choices.DefaultChoice;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.choices.HistoryChoice;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.ui.IFilterEditor;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.ui.editor.FontChoiceRenderer;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.ui.editor.SortedComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class FilterEditor
extends JComponent
implements IFilterEditor {
    private final FilterableTableHeader filterableTableHeader;
    private final int modelIndex;
    private final Class modelClass;
    private final EditorComponent editor;
    private Object content;
    private int maxHistorySize;

    public FilterEditor(FilterableTableHeader filterableTableHeader, int modelIndex, Class<?> modelClass) {
        this.filterableTableHeader = filterableTableHeader;
        this.modelIndex = modelIndex;
        this.modelClass = modelClass;
        this.setLayout(new BorderLayout());
        this.editor = new EditorComponent();
        this.add((Component)this.editor, "Center");
    }

    @Override
    public int getModelIndex() {
        return this.modelIndex;
    }

    public Class getModelClass() {
        return this.modelClass;
    }

    @Override
    public void filter() {
        this.filterableTableHeader.filter();
    }

    @Override
    public void resetFilter() {
        JTextField editorComponent = (JTextField)this.editor.getEditor().getEditorComponent();
        editorComponent.setText("");
        this.setDefaultOutline();
        this.content = null;
    }

    @Override
    public Object getContent() {
        String filter;
        Object object;
        String value = ((JTextField)this.editor.getEditor().getEditorComponent()).getText();
        if (this.content != null && (object = this.content) instanceof Choice) {
            Choice choice = (Choice)object;
            filter = choice.getFilter(value);
        } else {
            filter = value;
        }
        return filter;
    }

    @Override
    public void setMaxHistorySize(int size) {
        this.maxHistorySize = size;
    }

    @Override
    public void addToHistory() {
        String value = ((JTextField)this.editor.getEditor().getEditorComponent()).getText();
        if (value.isEmpty()) {
            return;
        }
        HistoryChoice historyWithLowestPrecedence = null;
        int historyCounter = 0;
        int precedence = 0;
        boolean valueIsAlreadyInList = false;
        int size = this.editor.getItemCount();
        for (int i = 0; i < size; ++i) {
            Choice item = (Choice)this.editor.getItemAt(i);
            if (precedence == 0) {
                precedence = item.getPrecedence();
            } else if (precedence < item.getPrecedence()) {
                precedence = item.getPrecedence();
            }
            if (item.getRepresentation().equalsIgnoreCase(value)) {
                valueIsAlreadyInList = true;
            }
            if (!(item instanceof HistoryChoice)) continue;
            HistoryChoice history = (HistoryChoice)item;
            ++historyCounter;
            if (historyWithLowestPrecedence != null) continue;
            historyWithLowestPrecedence = history;
        }
        if (valueIsAlreadyInList) {
            return;
        }
        if (historyCounter >= this.maxHistorySize) {
            this.editor.removeItem(historyWithLowestPrecedence);
        }
        HistoryChoice hChoice = new HistoryChoice(value, precedence + 1);
        this.editor.addItem(hChoice);
        this.editor.setSelectedItem(hChoice);
        this.setDefaultProperties();
    }

    private void setErrorOutline() {
        this.editor.putClientProperty("JComponent.outline", "error");
    }

    private void setWarningOutline() {
        this.editor.putClientProperty("JComponent.outline", "warning");
    }

    private void setDefaultOutline() {
        this.editor.putClientProperty("JComponent.outline", "");
    }

    public void setErrorProperties() {
        this.setErrorOutline();
        ((JTextField)this.editor.getEditor().getEditorComponent()).setToolTipText(I18N.get("invalid-input"));
    }

    public void setWarningProperties() {
        this.setWarningOutline();
        ((JTextField)this.editor.getEditor().getEditorComponent()).setToolTipText(I18N.get("filter-not-active"));
    }

    public void setDefaultProperties() {
        this.setDefaultOutline();
        ((JTextField)this.editor.getEditor().getEditorComponent()).setToolTipText("");
    }

    class EditorComponent
    extends JComboBox<Choice> {
        public EditorComponent() {
            this.init();
        }

        private void init() {
            this.setMaximumRowCount(this.getMaximumRowCount() + FilterEditor.this.maxHistorySize);
            this.setFocusable(true);
            this.setEditable(true);
            this.setRenderer(new FontChoiceRenderer());
            if (FilterEditor.this.getModelClass() != null) {
                Comparable[] arr = FilterEditor.this.getModelClass().getSimpleName().equals(Date.class.getSimpleName()) ? (Choice[])Arrays.copyOf(DateChoice.getCustomChoices().toArray(), DateChoice.getCustomChoices().size(), Choice[].class) : (Choice[])Arrays.copyOf(DefaultChoice.getDefaultChoices().toArray(), DefaultChoice.getDefaultChoices().size(), Choice[].class);
                this.setModel(new SortedComboBoxModel(arr));
                this.setSelectedItem(null);
            }
            JTextField editorComponent = (JTextField)this.getEditor().getEditorComponent();
            editorComponent.putClientProperty("JTextField.showClearButton", true);
            editorComponent.putClientProperty("JTextField.clearCallback", textField -> {
                FilterEditor.this.resetFilter();
                if (FilterEditor.this.content != null) {
                    FilterEditor.this.setWarningProperties();
                }
                FilterEditor.this.content = null;
                this.setSelectedItem(null);
            });
            this.registerListener();
            this.registerEnterKey(editorComponent);
        }

        private void registerListener() {
            this.addActionListener(event -> {
                FilterEditor.this.setWarningProperties();
                FilterEditor.this.content = this.getSelectedItem();
            });
        }

        private void registerEnterKey(JTextField editorComponent) {
            String actionName = "KEY_ENTER";
            AbstractAction action = new AbstractAction(actionName){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterEditor.this.content = EditorComponent.this.getSelectedItem();
                    FilterEditor.this.filter();
                }
            };
            editorComponent.getActionMap().put(actionName, action);
            editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), actionName);
        }
    }
}

