/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.choices;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.choices.Choice;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.choices.DefaultChoice;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;

public class DateChoice
extends DefaultChoice {
    public static final String TODAY = I18N.get("today");

    public DateChoice(String representation, int precedence) {
        super(representation, precedence);
    }

    @Override
    public String getFilter(String value) {
        String filter2Use = super.getFilter(value);
        if (filter2Use != null) {
            return filter2Use;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        String dateToday = formatter.format(LocalDate.now());
        if (TODAY.equals(value)) {
            return value.replace(TODAY, dateToday + "-" + dateToday);
        }
        return value.replace(TODAY, dateToday);
    }

    public static Set<Choice> getCustomChoices() {
        HashSet<Choice> choices = new HashSet<Choice>();
        choices.addAll(DateChoice.getDefaultChoices());
        choices.add(new DateChoice(String.format("< %s", TODAY), choices.size()));
        choices.add(new DateChoice(TODAY, choices.size()));
        choices.add(new DateChoice(String.format("> %s", TODAY), choices.size()));
        return choices;
    }
}

