/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components.filtertabletableheader;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.FilterHelper;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.Filterable;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.ui.IFilterEditor;
import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.ui.editor.FilterEditor;
import com.vividsolutions.jump.workbench.ui.plugin.attributes.LayerTableModel;
import de.riwagis.guitools.Tasks;
import de.riwagis.riwajump.feature.PropertyCaseResolvingVisitor;
import de.riwagis.riwajump.model.attribute.AttributeProperty;
import de.riwagis.riwajump.model.search.WildcardSearchEnum;
import de.riwagis.riwajump.search.intelligence.SearchSupport;
import de.riwagis.util.exception.SystemException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;

public class FilterableTableHeader
extends JPanel
implements PropertyChangeListener,
LayerTableModel.TableRefreshListener {
    public static final CompoundBorder CONTROL_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3));
    private static final FilterPosition DEFAULT_FILTER_POSTION = FilterPosition.INLINE;
    private static final int MAX_HISTORY_ENTRIES = 3;
    private static final String PROPERTY_COMPONENT_ORIENTATION = "componentOrientation";
    private static final String PROPERTY_MODEL = "model";
    private final FilterHelper filterHelper = new FilterHelper(this);
    private JTable table;
    private FilterControlPanel filterControlPanel;
    private List<SimpleFeature> initialObjectInformationFeatures = null;
    private List<SimpleFeature> currentObjectInformationFeaturesState = null;
    private Map<Integer, JComponent> replacementFilterComponentMap = new HashMap<Integer, JComponent>();
    private final ComponentAdapter tableResizer = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            if (FilterableTableHeader.this.filterControlPanel != null) {
                FilterableTableHeader.this.filterControlPanel.revalidate();
            }
        }
    };

    public FilterableTableHeader(JTable table) {
        this(table, null);
    }

    public FilterableTableHeader(JTable table, Map<Integer, JComponent> replacementFilterComponentMap) {
        super(new BorderLayout());
        if (replacementFilterComponentMap != null) {
            this.replacementFilterComponentMap = replacementFilterComponentMap;
        }
        this.init(table);
    }

    private void init(JTable table) {
        this.setBackground(table.getBackground());
        this.setFilterPosition(DEFAULT_FILTER_POSTION);
        this.setTable(table);
        LayerTableModel layerTableModel = (LayerTableModel)this.getTable().getModel();
        if (!layerTableModel.isLoadDataFromDatabaseEnabled()) {
            this.initialObjectInformationFeatures = layerTableModel.getFeatures();
        }
    }

    public void setFilterPosition(FilterPosition position) {
        this.filterHelper.setFilterPosition(position);
    }

    public FilterPosition getFilterPosition() {
        return this.filterHelper.getFilterPosition();
    }

    public void setTable(JTable table) {
        this.table = table;
        JTable oldTable = this.getTable();
        this.filterHelper.updateTableProperties(oldTable, table);
        if (oldTable != null) {
            oldTable.removeComponentListener(this.tableResizer);
            oldTable.removePropertyChangeListener(PROPERTY_MODEL, this);
            oldTable.removePropertyChangeListener(PROPERTY_COMPONENT_ORIENTATION, this);
            ((LayerTableModel)oldTable.getModel()).setTableRefreshListener(null);
        }
        if (table == null) {
            this.removeControlPanel();
            this.revalidate();
        } else {
            this.recreateControlPanel();
            table.addComponentListener(this.tableResizer);
            table.addPropertyChangeListener(PROPERTY_MODEL, this);
            table.addPropertyChangeListener(PROPERTY_COMPONENT_ORIENTATION, this);
            ((LayerTableModel)table.getModel()).setTableRefreshListener(this);
        }
    }

    public JTable getTable() {
        return this.table;
    }

    void recreateControlPanel() {
        this.removeControlPanel();
        this.filterControlPanel = new FilterControlPanel();
        this.add((Component)this.filterControlPanel, "West");
        this.revalidate();
    }

    private boolean removeControlPanel() {
        if (this.filterControlPanel != null) {
            this.filterControlPanel.detach();
            this.remove(this.filterControlPanel);
            this.filterControlPanel = null;
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        this.filterHelper.headerVisibilityChanged(flag);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.filterHelper.filterHeaderAffiliationUpdated();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (PROPERTY_MODEL.equals(evt.getPropertyName())) {
            this.recreateControlPanel();
        } else if (PROPERTY_COMPONENT_ORIENTATION.equals(evt.getPropertyName())) {
            this.recreateControlPanel();
        }
    }

    @Override
    public void refreshTable() {
        this.filter();
    }

    public IFilterEditor getFilterEditor(int modelColumnIndex) {
        return this.filterControlPanel == null ? null : this.filterControlPanel.getFilterEditor(this.getTable().convertColumnIndexToView(modelColumnIndex));
    }

    public void filter() {
        if (this.filterControlPanel != null) {
            Filterable controlPanel = null;
            Layer layer = ((LayerTableModel)this.getTable().getModel()).getLayer();
            IncludeFilter filter = Filter.INCLUDE;
            for (FilterControlPanel.FilterColumnPanel filterColumnPanel : this.filterControlPanel.columns) {
                JComponent jComponent = filterColumnPanel.component;
                if (jComponent instanceof Filterable) {
                    Filterable filterable;
                    controlPanel = filterable = (Filterable)((Object)jComponent);
                    continue;
                }
                jComponent = filterColumnPanel.component;
                if (!(jComponent instanceof FilterEditor)) continue;
                FilterEditor filterEditor = (FilterEditor)jComponent;
                try {
                    String headerName = this.getTable().getColumnName(filterEditor.getModelIndex());
                    String columnName = this.chooseCorrectModelAttribute(headerName, layer);
                    filter = SearchSupport.appendFilter((Filter)filter, layer.getFeatureType().getTypeName(), columnName, filterEditor.getModelClass(), filterEditor.getContent(), WildcardSearchEnum.WILDCARD_TRAILING);
                    filterEditor.setDefaultProperties();
                    filterEditor.addToHistory();
                }
                catch (Exception ex) {
                    filterEditor.setErrorProperties();
                    return;
                }
            }
            filter = PropertyCaseResolvingVisitor.ignoreCaseOfProperties((Filter)filter, layer.getFMD());
            this.filter(layer, (Filter)filter);
            if (controlPanel != null) {
                controlPanel.fireTableFiltered(filter != Filter.INCLUDE);
            }
        }
    }

    private String chooseCorrectModelAttribute(String columnName, Layer layer) {
        if (columnName.equals("FID")) {
            if (layer.getFMD().getKeyAtt() == null) {
                return "_PrimaryKey";
            }
            return layer.getFMD().getKeyAtt();
        }
        for (AttributeProperty attrProp : layer.getAttributeTable().getAttributeProperties()) {
            if (!columnName.equals(attrProp.getAlias())) continue;
            return attrProp.getName();
        }
        return columnName;
    }

    private void filter(Layer layer, Filter filter) {
        ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
        LayerTableModel layerTableModel = (LayerTableModel)this.getTable().getModel();
        boolean result = true;
        if (layerTableModel.isLoadDataFromDatabaseEnabled()) {
            result = Tasks.submit(() -> {
                try {
                    FeatureIterator<SimpleFeature> fi;
                    if (!layer.getCacheAll() && layer.getFeatureCountForFilter(filter) >= 50000) {
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.getParent(), I18N.getMessage("ui.AttributeTab.OneLayerAttributeTab.to-many-features", 50000), I18N.get("common.message"), -1));
                    }
                    try (FeatureIterator<SimpleFeature> featureIterator = fi = layer.getFeatureIterator(filter, 50000);){
                        while (fi.hasNext()) {
                            lstFeatures.add((SimpleFeature)fi.next());
                        }
                    }
                }
                catch (Exception ex) {
                    throw new SystemException(this.getClass(), I18N.get("search-request-could-not-be-executed"), (Throwable)ex);
                }
            });
        } else {
            if (this.currentObjectInformationFeaturesState == null) {
                this.currentObjectInformationFeaturesState = new ArrayList<SimpleFeature>(this.initialObjectInformationFeatures);
            }
            if (!layerTableModel.getLayer().hasModifiedFeatures()) {
                this.currentObjectInformationFeaturesState = new ArrayList<SimpleFeature>(layerTableModel.getFeatures());
            }
            for (int i = 0; i < this.currentObjectInformationFeaturesState.size(); ++i) {
                SimpleFeature feature = this.currentObjectInformationFeaturesState.get(i);
                if (layerTableModel.getLayer().hasModifiedFeatures()) {
                    try {
                        SimpleFeature tableModelfeature = layerTableModel.getLayer().getFeatureByKey(feature.getID());
                        if (layerTableModel.isModifiedFeature(tableModelfeature)) {
                            this.currentObjectInformationFeaturesState.set(i, tableModelfeature);
                            feature = tableModelfeature;
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(FilterableTableHeader.class.getName()).log(Level.INFO, null, ex);
                    }
                }
                if (!filter.evaluate((Object)feature)) continue;
                lstFeatures.add(feature);
            }
        }
        if (result) {
            layerTableModel.clear();
            layerTableModel.addAll(lstFeatures);
        }
    }

    public void resetFilter() {
        if (this.filterControlPanel != null) {
            for (FilterControlPanel.FilterColumnPanel filterColumnPanel : this.filterControlPanel.columns) {
                JComponent jComponent = filterColumnPanel.component;
                if (!(jComponent instanceof FilterEditor)) continue;
                FilterEditor filterEditor = (FilterEditor)jComponent;
                filterEditor.resetFilter();
            }
            LayerTableModel layerTableModel = (LayerTableModel)this.getTable().getModel();
            if (layerTableModel.isLoadDataFromDatabaseEnabled()) {
                this.filter(layerTableModel.getLayer(), (Filter)Filter.INCLUDE);
            } else {
                layerTableModel.clear();
                layerTableModel.addAll(this.initialObjectInformationFeatures);
            }
        }
    }

    public static enum FilterPosition {
        TOP,
        INLINE,
        NONE;

    }

    private class FilterControlPanel
    extends JPanel
    implements TableColumnModelListener,
    Runnable {
        private final TableColumnModel tableColumnModel;
        private final TableModel tableModel;
        private LinkedList<FilterColumnPanel> columns;
        private Dimension preferredSize;
        private int guiThreadCounter;

        public FilterControlPanel() {
            super(null);
            this.tableColumnModel = FilterableTableHeader.this.getTable().getColumnModel();
            this.tableModel = FilterableTableHeader.this.getTable().getModel();
            this.init();
        }

        private void init() {
            this.setBackground(FilterableTableHeader.this.getTable().getBackground());
            this.columns = new LinkedList();
            int count = this.tableColumnModel.getColumnCount();
            for (int i = 0; i < count; ++i) {
                this.createColumnPanel(i);
            }
            this.preferredSize = new Dimension(0, count == 0 ? 0 : this.columns.get((int)0).columnHeight);
            this.arrangeComponents();
            this.tableColumnModel.addColumnModelListener(this);
        }

        private void createColumnPanel(int viewColumnIndex) {
            int modelColumnIndex = FilterableTableHeader.this.getTable().convertColumnIndexToModel(viewColumnIndex);
            FilterEditor editor = this.createEditor(modelColumnIndex);
            FilterColumnPanel column = FilterableTableHeader.this.replacementFilterComponentMap.containsKey(viewColumnIndex) ? new FilterColumnPanel(this.tableColumnModel.getColumn(viewColumnIndex), FilterableTableHeader.this.replacementFilterComponentMap.get(viewColumnIndex)) : new FilterColumnPanel(this.tableColumnModel.getColumn(viewColumnIndex), editor);
            this.columns.add(column);
            this.add(column);
        }

        private FilterEditor createEditor(int modelColumnIndex) {
            FilterEditor filterEditor = new FilterEditor(FilterableTableHeader.this, modelColumnIndex, FilterableTableHeader.this.getTable().getModel().getColumnClass(modelColumnIndex));
            filterEditor.setMaxHistorySize(3);
            return filterEditor;
        }

        public void detach() {
            for (FilterColumnPanel column : this.columns) {
                column.detach();
            }
            this.tableColumnModel.removeColumnModelListener(this);
        }

        public FilterEditor getFilterEditor(int viewColumn) {
            JComponent comp;
            if (this.columns.size() > viewColumn && (comp = this.columns.get((int)viewColumn).component) instanceof FilterEditor) {
                FilterEditor filterEditor = (FilterEditor)comp;
                return filterEditor;
            }
            return null;
        }

        public void updateHeight() {
            int height = 0;
            for (FilterColumnPanel filterColumnPanel : this.columns) {
                height = Math.max(height, filterColumnPanel.columnHeight);
            }
            this.preferredSize.height = height;
            this.arrangeComponents();
            this.repaint();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            this.arrangeComponents();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            JTableHeader header;
            TableColumn tableColumn;
            if (e.getFromIndex() != e.getToIndex()) {
                FilterColumnPanel fcp = this.columns.remove(e.getFromIndex());
                this.columns.add(e.getToIndex(), fcp);
                this.arrangeComponents();
            }
            if ((tableColumn = (header = FilterableTableHeader.this.getTable().getTableHeader()).getDraggedColumn()) != null) {
                boolean rightToLeft = FilterableTableHeader.this.getTable().getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT;
                Iterator<FilterColumnPanel> it = rightToLeft ? this.columns.descendingIterator() : this.columns.iterator();
                FilterColumnPanel previousFilterColumnPanel = null;
                while (it.hasNext()) {
                    FilterColumnPanel filterColumnPanel = it.next();
                    if (filterColumnPanel.tableColumn == tableColumn) {
                        boolean overPreviousDragging;
                        Rectangle rect = null;
                        double x = 0.0;
                        if (previousFilterColumnPanel != null) {
                            rect = previousFilterColumnPanel.getBounds();
                            x = rect.getX() + rect.getWidth();
                        }
                        rect = filterColumnPanel.getBounds(rect);
                        rect.translate((int)(x - rect.getX() + (double)header.getDraggedDistance()), 0);
                        filterColumnPanel.setBounds(rect);
                        if (rightToLeft) {
                            FilterColumnPanel filterColumnPanel2 = previousFilterColumnPanel = it.hasNext() ? it.next() : null;
                        }
                        if (previousFilterColumnPanel == null) break;
                        int prevZOrder = this.getComponentZOrder(previousFilterColumnPanel);
                        int zOrder = this.getComponentZOrder(filterColumnPanel);
                        boolean bl = rightToLeft ? header.getDraggedDistance() > 0 : (overPreviousDragging = header.getDraggedDistance() < 0);
                        if (overPreviousDragging == zOrder < prevZOrder) break;
                        this.setComponentZOrder(previousFilterColumnPanel, zOrder);
                        this.setComponentZOrder(filterColumnPanel, prevZOrder);
                        break;
                    }
                    previousFilterColumnPanel = filterColumnPanel;
                }
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            if (this.hasTableModelChanged()) {
                this.createColumnPanel(e.getToIndex());
                this.update();
            }
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            if (this.hasTableModelChanged()) {
                FilterColumnPanel filterColumnPanel = this.columns.remove(e.getFromIndex());
                filterColumnPanel.detach();
                this.remove(filterColumnPanel);
                this.update();
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        private boolean hasTableModelChanged() {
            return FilterableTableHeader.this.getTable() != null && this.tableModel == FilterableTableHeader.this.getTable().getModel();
        }

        private void update() {
            ++this.guiThreadCounter;
            if (SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this);
            } else {
                this.run();
            }
        }

        @Override
        public void run() {
            if (--this.guiThreadCounter == 0 && FilterableTableHeader.this.getTable() != null) {
                this.updateHeight();
            }
        }

        void arrangeComponents() {
            Iterator<FilterColumnPanel> it;
            int x = 0;
            Iterator<FilterColumnPanel> iterator = it = FilterableTableHeader.this.getTable().getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? this.columns.descendingIterator() : this.columns.iterator();
            while (it.hasNext()) {
                FilterColumnPanel filterColumnPanel = it.next();
                filterColumnPanel.setBounds(x, 0, filterColumnPanel.columnWidth, this.preferredSize.height);
                x += filterColumnPanel.columnWidth;
            }
            this.revalidate();
        }

        @Override
        public Dimension getPreferredSize() {
            JTable table = FilterableTableHeader.this.getTable();
            if (table != null) {
                this.preferredSize.width = table.getWidth();
            }
            return this.preferredSize;
        }

        private class FilterColumnPanel
        extends JPanel
        implements PropertyChangeListener {
            private final TableColumn tableColumn;
            private final JComponent component;
            int columnWidth;
            int columnHeight;

            public FilterColumnPanel(TableColumn tableColumn, JComponent component) {
                this.tableColumn = tableColumn;
                this.component = component;
                this.init();
            }

            private void init() {
                this.setBackground(FilterableTableHeader.this.getTable().getBackground());
                this.setLayout(new GridBagLayout());
                if (this.component != null) {
                    JComponent jComponent = this.component;
                    if (jComponent instanceof JPanel) {
                        JPanel panel = (JPanel)jComponent;
                        panel.setBackground(FilterableTableHeader.this.getTable().getBackground());
                    }
                    this.component.setBorder(CONTROL_BORDER);
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.anchor = 23;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.weightx = 1.0;
                    this.add((Component)this.component, gridBagConstraints);
                }
                this.columnWidth = this.tableColumn.getWidth();
                this.columnHeight = this.getPreferredSize().height;
                this.tableColumn.addPropertyChangeListener(this);
            }

            public void detach() {
                if (this.component != null) {
                    this.remove(this.component);
                }
                this.tableColumn.removePropertyChangeListener(this);
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int newWidth = this.tableColumn.getWidth();
                if (this.columnWidth != newWidth) {
                    this.columnWidth = newWidth;
                    FilterControlPanel.this.arrangeComponents();
                }
            }
        }
    }
}

