/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components.filtertabletableheader;

import com.vividsolutions.jump.workbench.ui.components.filtertabletableheader.FilterableTableHeader;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;

class FilterHelper
implements PropertyChangeListener {
    private final FilterableTableHeader filterableTableHeader;
    private FilterableTableHeader.FilterPosition filterPosition;
    private JViewport headerViewport;
    private Component previousTableViewport;

    public FilterHelper(FilterableTableHeader filterableTableHeader) {
        this.filterableTableHeader = filterableTableHeader;
    }

    public void setFilterPosition(FilterableTableHeader.FilterPosition location) {
        this.filterPosition = location;
        JTable table = this.filterableTableHeader.getTable();
        this.updateTableProperties(table, table);
    }

    public FilterableTableHeader.FilterPosition getFilterPosition() {
        return this.filterPosition;
    }

    public void headerVisibilityChanged(boolean visible) {
        JTable table = this.filterableTableHeader.getTable();
        this.updateTableProperties(table, null);
        if (visible && table != null) {
            this.updateTableProperties(null, table);
        }
    }

    public void updateTableProperties(JTable oldTable, JTable newTable) {
        if (oldTable != null) {
            oldTable.removePropertyChangeListener("ancestor", this);
        }
        this.cleanUp();
        if (newTable != null) {
            newTable.addPropertyChangeListener("ancestor", this);
            this.trySetUp(newTable);
        }
    }

    public void filterHeaderAffiliationUpdated() {
        if (!this.canFilterPositionBeManaged()) {
            this.cleanUp();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.previousTableViewport != evt.getNewValue() || evt.getSource() != this.filterableTableHeader.getTable()) {
            this.previousTableViewport = null;
            this.cleanUp();
            this.trySetUp(this.filterableTableHeader.getTable());
        }
    }

    private boolean canFilterPositionBeManaged() {
        if (this.filterPosition == FilterableTableHeader.FilterPosition.NONE) {
            return false;
        }
        Container parent = this.filterableTableHeader.getParent();
        return parent == null || parent == this.headerViewport;
    }

    private void trySetUp(JTable table) {
        JScrollPane scrollPane;
        JViewport viewport;
        Container gp;
        Container p;
        if (table != null && table.isVisible() && this.canFilterPositionBeManaged() && this.filterableTableHeader.isVisible() && (p = table.getParent()) instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane && (viewport = (scrollPane = (JScrollPane)gp).getViewport()) != null && viewport.getView() == table) {
            this.setUp(scrollPane);
            this.previousTableViewport = p;
        }
    }

    private void setUp(JScrollPane scrollPane) {
        Component view;
        this.headerViewport = new JViewport(){

            @Override
            public void setView(Component view) {
                if (view instanceof JTableHeader) {
                    this.removeTableHeader();
                    FilterHelper.this.filterableTableHeader.add(view, FilterHelper.this.filterPosition == FilterableTableHeader.FilterPosition.INLINE ? "North" : "South");
                    FilterHelper.this.filterableTableHeader.revalidate();
                    super.setView(FilterHelper.this.filterableTableHeader);
                }
            }

            private Component removeTableHeader() {
                Component tableHeader = FilterHelper.this.getTableHeader();
                if (tableHeader != null) {
                    FilterHelper.this.filterableTableHeader.remove(tableHeader);
                }
                return tableHeader;
            }
        };
        JViewport currentColumnHeader = scrollPane.getColumnHeader();
        if (currentColumnHeader != null && (view = currentColumnHeader.getView()) != null) {
            this.headerViewport.setView(view);
        }
        scrollPane.setColumnHeader(this.headerViewport);
    }

    private void cleanUp() {
        JViewport currentViewport = this.headerViewport;
        this.headerViewport = null;
        if (currentViewport != null) {
            JScrollPane scrollPane;
            currentViewport.remove(this.filterableTableHeader);
            Container parent = currentViewport.getParent();
            if (parent instanceof JScrollPane && (scrollPane = (JScrollPane)parent).getColumnHeader() == currentViewport) {
                Component tableHeader = this.getTableHeader();
                JViewport newView = tableHeader == null ? null : this.createCleanViewport(tableHeader);
                scrollPane.setColumnHeader(newView);
            }
        }
    }

    private Component getTableHeader() {
        for (Component component : this.filterableTableHeader.getComponents()) {
            if (!(component instanceof JTableHeader)) continue;
            return component;
        }
        return null;
    }

    private JViewport createCleanViewport(Component tableHeader) {
        JViewport viewport = new JViewport();
        viewport.setView(tableHeader);
        return viewport;
    }
}

