/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components.dnd;

import com.vividsolutions.jump.workbench.ui.components.dnd.DnDTabData;
import com.vividsolutions.jump.workbench.ui.components.dnd.DnDTabbedPane;
import com.vividsolutions.jump.workbench.ui.components.dnd.GhostGlassPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class TabTransferHandler
extends TransferHandler {
    protected final DataFlavor localObjectFlavor = new DataFlavor(DnDTabData.class, DnDTabData.class.getSimpleName());
    protected DnDTabbedPane sourceTabbedPane;

    @Override
    protected Transferable createTransferable(JComponent component) {
        if (component instanceof DnDTabbedPane) {
            DnDTabbedPane dnDTabbedPane;
            this.sourceTabbedPane = dnDTabbedPane = (DnDTabbedPane)component;
        }
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{TabTransferHandler.this.localObjectFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return Objects.equals(TabTransferHandler.this.localObjectFlavor, flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.isDataFlavorSupported(flavor)) {
                    return new DnDTabData(TabTransferHandler.this.sourceTabbedPane);
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean inArea;
        if (!support.isDrop() || !support.isDataFlavorSupported(this.localObjectFlavor)) {
            return false;
        }
        support.setDropAction(2);
        TransferHandler.DropLocation tdl = support.getDropLocation();
        Point pt = tdl.getDropPoint();
        DnDTabbedPane target = (DnDTabbedPane)support.getComponent();
        DnDTabbedPane.DropLocation dl = target.tabDropLocationForPoint(pt);
        int idx = dl.getIndex();
        boolean bl = inArea = target.getTabAreaBounds().contains(pt) && idx >= 0;
        boolean canDrop = target.equals(this.sourceTabbedPane) ? inArea && idx != target.dragTabIndex && idx != target.dragTabIndex + 1 : Optional.ofNullable(this.sourceTabbedPane).map(c -> !c.isAncestorOf(target)).orElse(false) != false && inArea;
        Cursor cursor = canDrop ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop;
        Component glassPane = target.getRootPane().getGlassPane();
        glassPane.setCursor(cursor);
        target.setCursor(cursor);
        support.setShowDropLocation(canDrop);
        target.updateTabDropLocation(dl, canDrop);
        return canDrop;
    }

    private BufferedImage makeDragTabImage(DnDTabbedPane tabbedPane) {
        Rectangle rect = tabbedPane.getBoundsAt(tabbedPane.dragTabIndex);
        int w = tabbedPane.getWidth();
        int h = tabbedPane.getHeight();
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g = img.createGraphics();
        tabbedPane.paint(g);
        g.dispose();
        if (rect.x < 0) {
            rect.translate(-rect.x, 0);
        }
        if (rect.y < 0) {
            rect.translate(0, -rect.y);
        }
        if (rect.x + rect.width > img.getWidth()) {
            rect.width = img.getWidth() - rect.x;
        }
        if (rect.y + rect.height > img.getHeight()) {
            rect.height = img.getHeight() - rect.y;
        }
        return img.getSubimage(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public int getSourceActions(JComponent component) {
        if (component instanceof DnDTabbedPane) {
            DnDTabbedPane targetTabbedPane = (DnDTabbedPane)component;
            component.getRootPane().setGlassPane(new GhostGlassPane(targetTabbedPane));
            if (targetTabbedPane.dragTabIndex < 0) {
                return 0;
            }
            this.setDragImage(this.makeDragTabImage(targetTabbedPane));
            component.getRootPane().getGlassPane().setVisible(true);
            return 2;
        }
        return 0;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        DnDTabbedPane targetTabbedPane = (DnDTabbedPane)support.getComponent();
        DnDTabbedPane.DropLocation dl = targetTabbedPane.getDropLocation();
        try {
            DnDTabData data = (DnDTabData)support.getTransferable().getTransferData(this.localObjectFlavor);
            DnDTabbedPane srcTabbedPane = data.tabbedPane;
            int index = dl.getIndex();
            if (targetTabbedPane.equals(srcTabbedPane)) {
                srcTabbedPane.convertTab(srcTabbedPane.dragTabIndex, index);
            } else {
                srcTabbedPane.exportTab(srcTabbedPane.dragTabIndex, targetTabbedPane, index);
            }
            return true;
        }
        catch (UnsupportedFlavorException | IOException ex) {
            return false;
        }
    }

    @Override
    protected void exportDone(JComponent component, Transferable data, int action) {
        DnDTabbedPane srcTabbedPane = (DnDTabbedPane)component;
        srcTabbedPane.getRootPane().getGlassPane().setVisible(false);
        srcTabbedPane.updateTabDropLocation(null, false);
        srcTabbedPane.repaint();
        srcTabbedPane.setCursor(Cursor.getDefaultCursor());
    }
}

