/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components.dnd;

import com.vividsolutions.jump.workbench.ui.components.CloseableTabbedPane;
import com.vividsolutions.jump.workbench.ui.components.dnd.GhostGlassPane;
import com.vividsolutions.jump.workbench.ui.components.dnd.TabDropTargetAdapter;
import com.vividsolutions.jump.workbench.ui.components.dnd.TabTransferHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.Optional;
import java.util.TooManyListenersException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.TransferHandler;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnDTabbedPane
extends CloseableTabbedPane {
    private static final Logger LOG = LoggerFactory.getLogger(DnDTabbedPane.class);
    private static final String PROP_CHANGE_DROP_LOCATION = "dropLocation";
    protected static final Rectangle RECT_LINE = new Rectangle();
    private static final int LINE_SZ = 3;
    protected int dragTabIndex = -1;
    private transient DropLocation dropLocation;

    public DnDTabbedPane() {
        this.init();
    }

    private void init() {
        Handler handler = new Handler();
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        this.addPropertyChangeListener(handler);
        TabDropTargetAdapter dropTargetListener = new TabDropTargetAdapter();
        TabTransferHandler transferHandler = new TabTransferHandler();
        this.setTransferHandler(transferHandler);
        try {
            this.getDropTarget().addDropTargetListener(dropTargetListener);
        }
        catch (TooManyListenersException ex) {
            LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    public DropLocation tabDropLocationForPoint(Point p) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getBoundsAt(i).contains(p)) continue;
            return new DropLocation(p, i);
        }
        if (this.getTabAreaBounds().contains(p)) {
            return new DropLocation(p, this.getTabCount());
        }
        return new DropLocation(p, -1);
    }

    public final DropLocation getDropLocation() {
        return this.dropLocation;
    }

    public void updateTabDropLocation(DropLocation location, boolean forDrop) {
        DropLocation old = this.dropLocation;
        this.dropLocation = Objects.isNull(location) || !forDrop ? new DropLocation(new Point(), -1) : location;
        this.firePropertyChange(PROP_CHANGE_DROP_LOCATION, old, this.dropLocation);
    }

    public void exportTab(int dragIndex, JTabbedPane target, int targetIndex) {
        Component cmp = this.getComponentAt(dragIndex);
        String title = this.getTitleAt(dragIndex);
        Icon icon = this.getIconAt(dragIndex);
        String toolTipText = this.getToolTipTextAt(dragIndex);
        boolean isEnabled = this.isEnabledAt(dragIndex);
        Component tab = this.getTabComponentAt(dragIndex);
        this.remove(dragIndex);
        target.insertTab(title, icon, cmp, toolTipText, targetIndex);
        target.setEnabledAt(targetIndex, isEnabled);
        target.setTabComponentAt(targetIndex, tab);
        target.setSelectedIndex(targetIndex);
        if (tab instanceof JComponent) {
            JComponent jComponent = (JComponent)tab;
            jComponent.scrollRectToVisible(tab.getBounds());
        }
    }

    public void convertTab(int prev, int next) {
        Component cmp = this.getComponentAt(prev);
        Component tab = this.getTabComponentAt(prev);
        String title = this.getTitleAt(prev);
        Icon icon = this.getIconAt(prev);
        String tip = this.getToolTipTextAt(prev);
        boolean isEnabled = this.isEnabledAt(prev);
        int targetIndex = prev > next ? next : next - 1;
        this.remove(prev);
        this.insertTab(title, icon, cmp, tip, targetIndex);
        this.setEnabledAt(targetIndex, isEnabled);
        if (isEnabled) {
            this.setSelectedIndex(targetIndex);
        }
        this.setTabComponentAt(targetIndex, tab);
    }

    public Optional<Rectangle> getDropLineRect() {
        int index = Optional.ofNullable(this.getDropLocation()).map(DropLocation::getIndex).orElse(-1);
        if (index < 0) {
            RECT_LINE.setBounds(0, 0, 0, 0);
            return Optional.empty();
        }
        int a = Math.min(index, 1);
        Rectangle r = this.getBoundsAt(a * (index - 1));
        if (DnDTabbedPane.isTopBottomTabPlacement(this.getTabPlacement())) {
            RECT_LINE.setBounds(r.x - 1 + r.width * a, r.y, 3, r.height);
        } else {
            RECT_LINE.setBounds(r.x, r.y - 1 + r.height * a, r.width, 3);
        }
        return Optional.of(RECT_LINE);
    }

    public Rectangle getTabAreaBounds() {
        Rectangle tabbedRect = this.getBounds();
        int xx = tabbedRect.x;
        int yy = tabbedRect.y;
        Rectangle compRect = Optional.ofNullable(this.getSelectedComponent()).map(Component::getBounds).orElseGet(Rectangle::new);
        int tabPosition = this.getTabPlacement();
        if (DnDTabbedPane.isTopBottomTabPlacement(tabPosition)) {
            tabbedRect.height -= compRect.height;
            if (tabPosition == 3) {
                tabbedRect.y += compRect.y + compRect.height;
            }
        } else {
            tabbedRect.width -= compRect.width;
            if (tabPosition == 4) {
                tabbedRect.x += compRect.x + compRect.width;
            }
        }
        tabbedRect.translate(-xx, -yy);
        return tabbedRect;
    }

    public static boolean isTopBottomTabPlacement(int tabPlacement) {
        return tabPlacement == 1 || tabPlacement == 3;
    }

    private class Handler
    extends MouseAdapter
    implements PropertyChangeListener {
        private Point startPoint;
        private final int dragThreshold = DragSource.getDragThreshold();

        private Handler() {
        }

        private void repaintDropLocation() {
            Component c = DnDTabbedPane.this.getRootPane().getGlassPane();
            if (c instanceof GhostGlassPane) {
                GhostGlassPane glassPane = (GhostGlassPane)c;
                glassPane.setTargetTabbedPane(DnDTabbedPane.this);
                glassPane.repaint();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (DnDTabbedPane.PROP_CHANGE_DROP_LOCATION.equals(propertyName)) {
                this.repaintDropLocation();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            boolean isOnlyOneTab;
            DnDTabbedPane srcTabbedPane = (DnDTabbedPane)e.getComponent();
            boolean bl = isOnlyOneTab = srcTabbedPane.getTabCount() <= 1;
            if (isOnlyOneTab) {
                this.startPoint = null;
                return;
            }
            Point tabPoint = e.getPoint();
            int idx = srcTabbedPane.indexAtLocation(tabPoint.x, tabPoint.y);
            boolean flag = idx < 0 || !srcTabbedPane.isEnabledAt(idx) || Objects.isNull(srcTabbedPane.getComponentAt(idx));
            this.startPoint = flag ? null : tabPoint;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point tabPoint = e.getPoint();
            if (Objects.nonNull(this.startPoint) && this.startPoint.distance(tabPoint) > (double)this.dragThreshold) {
                DnDTabbedPane srcTabbedPane = (DnDTabbedPane)e.getComponent();
                TransferHandler th = srcTabbedPane.getTransferHandler();
                int idx = srcTabbedPane.indexAtLocation(tabPoint.x, tabPoint.y);
                int selectedIdx = srcTabbedPane.getSelectedIndex();
                boolean isRotateTabRuns = !(srcTabbedPane.getUI() instanceof MetalTabbedPaneUI) && srcTabbedPane.getTabLayoutPolicy() == 0 && idx != selectedIdx;
                DnDTabbedPane.this.dragTabIndex = isRotateTabRuns ? selectedIdx : idx;
                th.exportAsDrag(srcTabbedPane, e, 2);
                RECT_LINE.setBounds(0, 0, 0, 0);
                srcTabbedPane.getRootPane().getGlassPane().setVisible(true);
                srcTabbedPane.updateTabDropLocation(new DropLocation(tabPoint, -1), true);
                this.startPoint = null;
            }
        }
    }

    public static final class DropLocation
    extends TransferHandler.DropLocation {
        private final int index;

        private DropLocation(Point p, int index) {
            super(p);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

