/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.WindowVisibleKeeper;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.icons.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class UndockablePanel
extends JPanel {
    public static final String CHANGE_PROP_DOCK_PANEL = "DOCK_PANEL";
    public static final String CHANGE_PROP_CLOSE_PANEL = "CLOSE_PANEL";
    public static final String IS_WINDOW_UNDOCKED_KEY = "_DRAG_WINDOW_UNDOCKED";
    public static final String UNDOCKED_WINDOW_DIM_KEY = "_UNDOCKED_WINDOW_DIM";
    public static final String UNDOCKED_WINDOW_POS_KEY = "_UNDOCKED_WINDOW_POS";
    private static final ImageIcon ICON_CLOSE = IconLoader.svgIcon((String)"close.svg", (int)14);
    private static final ImageIcon ICON_DOCKED = IconLoader.svgIcon((String)"dock.svg", (int)14);
    private static final ImageIcon ICON_UNDOCKED = IconLoader.svgIcon((String)"undock.svg", (int)14);
    private static final String TOOLTIP_CLOSE = I18N.get("ui.DesktopPanel.close-tooltip");
    private static final String TOOLTIP_DOCKED = I18N.get("ui.UndockablePanel.dock-tooltip");
    private static final String TOOLTIP_UNDOCKED = I18N.get("ui.UndockablePanel.undock-tooltip");
    private String title;
    private Component parent;
    private String uniqueBlackboardKey;
    private boolean isUndocked = false;
    private JFrame frame;
    private JButton btnClose;
    private JButton btnUndock;
    private JLabel lblTitle;
    private JPanel pnlButtons;
    private JPanel pnlControl;

    public UndockablePanel() {
        if (!Beans.isDesignTime()) {
            throw new IllegalStateException("This constructor is only allowed in designer mode.");
        }
        this.title = "Undockable content";
        this.initComponents();
        this.init();
    }

    public <T extends Component> UndockablePanel(String title, T parent, String uniqueBlackboardKey) {
        this.title = title;
        this.parent = parent;
        this.uniqueBlackboardKey = uniqueBlackboardKey;
        this.initComponents();
        this.init();
        this.addPropertyChangeListener((PropertyChangeListener)((Object)parent));
    }

    private void init() {
        this.lblTitle.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.lblTitle.setText(this.title);
        this.btnUndock.setIcon(ICON_UNDOCKED);
        this.btnUndock.setToolTipText(TOOLTIP_UNDOCKED);
        this.btnClose.setIcon(ICON_CLOSE);
        this.btnClose.setToolTipText(TOOLTIP_CLOSE);
        this.btnUndock.putClientProperty("JButton.buttonType", "borderless");
        this.btnClose.putClientProperty("JButton.buttonType", "borderless");
    }

    private JFrame getFrame() {
        if (this.frame == null) {
            this.frame = new JFrame(this.title);
            this.frame.setIconImages(WorkbenchContext.getFrame().getIconImages());
            this.frame.setDefaultCloseOperation(2);
            this.frame.setLayout(new BorderLayout());
            WindowVisibleKeeper.keepFrameVisibleOnDeviceChanges(this.frame);
            Dimension lastDragWindowSize = (Dimension)PersistentBlackboardPlugIn.get().get(this.uniqueBlackboardKey + UNDOCKED_WINDOW_DIM_KEY, new Dimension(1024, 768));
            Object lastDragWindowPosition = PersistentBlackboardPlugIn.get().get(this.uniqueBlackboardKey + UNDOCKED_WINDOW_POS_KEY);
            this.frame.setSize(lastDragWindowSize);
            if (lastDragWindowPosition == null) {
                this.frame.setLocationRelativeTo(this.parent);
            } else {
                this.frame.setLocation((Point)lastDragWindowPosition);
            }
            this.frame.getRootPane().addHierarchyBoundsListener(new HierarchyBoundsListener(){

                @Override
                public void ancestorMoved(HierarchyEvent evt) {
                    PersistentBlackboardPlugIn.get().put(UndockablePanel.this.uniqueBlackboardKey + UndockablePanel.UNDOCKED_WINDOW_POS_KEY, UndockablePanel.this.frame.getLocation());
                }

                @Override
                public void ancestorResized(HierarchyEvent evt) {
                    PersistentBlackboardPlugIn.get().put(UndockablePanel.this.uniqueBlackboardKey + UndockablePanel.UNDOCKED_WINDOW_DIM_KEY, UndockablePanel.this.frame.getSize());
                }
            });
            JMenuBar menuBar = new JMenuBar();
            JButton dockButton = new JButton();
            dockButton.setIcon(ICON_DOCKED);
            dockButton.setToolTipText(TOOLTIP_DOCKED);
            dockButton.putClientProperty("JButton.buttonType", "borderless");
            dockButton.putClientProperty("toolBarButton", true);
            dockButton.setFocusable(false);
            dockButton.addActionListener(e -> this.handleDockUndockBehavior());
            menuBar.add(Box.createGlue());
            menuBar.add(dockButton);
            this.frame.setJMenuBar(menuBar);
            this.frame.setDefaultCloseOperation(0);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    UndockablePanel.this.firePropertyChange(UndockablePanel.CHANGE_PROP_CLOSE_PANEL, false, true);
                    UndockablePanel.this.frame.setVisible(false);
                    UndockablePanel.this.frame.dispose();
                }
            });
        }
        return this.frame;
    }

    private void handleDockUndockBehavior() {
        this.isUndocked = !this.isUndocked;
        PersistentBlackboardPlugIn.get().put(this.uniqueBlackboardKey + IS_WINDOW_UNDOCKED_KEY, this.isUndocked);
        this.showUndockedFrame(this.isUndocked);
        if (!this.isUndocked) {
            this.firePropertyChange(CHANGE_PROP_DOCK_PANEL, this, null);
        }
    }

    public void showUndockedFrame(boolean isVisible) {
        JFrame detachedFrame = this.getFrame();
        if (isVisible) {
            this.pnlControl.setVisible(false);
            this.btnUndock.setIcon(ICON_DOCKED);
            this.btnUndock.setToolTipText(TOOLTIP_DOCKED);
            detachedFrame.add(this);
            detachedFrame.setState(0);
            detachedFrame.setVisible(true);
            detachedFrame.requestFocus();
        } else {
            this.pnlControl.setVisible(true);
            this.btnUndock.setIcon(ICON_UNDOCKED);
            this.btnUndock.setToolTipText(TOOLTIP_UNDOCKED);
            detachedFrame.dispose();
            detachedFrame.setVisible(false);
        }
    }

    private void initComponents() {
        this.pnlControl = new JPanel();
        this.lblTitle = new JLabel();
        this.pnlButtons = new JPanel();
        this.btnUndock = new JButton();
        this.btnClose = new JButton();
        this.setLayout(new BorderLayout());
        this.pnlControl.setLayout(new BorderLayout());
        this.lblTitle.setFont(new Font("Segoe UI", 1, 12));
        this.lblTitle.setText("Title");
        this.pnlControl.add((Component)this.lblTitle, "West");
        this.pnlButtons.setLayout(new FlowLayout(2));
        this.btnUndock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UndockablePanel.this.btnUndockActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.btnUndock);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UndockablePanel.this.btnCloseActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.btnClose);
        this.pnlControl.add((Component)this.pnlButtons, "East");
        this.add((Component)this.pnlControl, "North");
    }

    private void btnUndockActionPerformed(ActionEvent evt) {
        this.handleDockUndockBehavior();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.firePropertyChange(CHANGE_PROP_CLOSE_PANEL, false, true);
    }
}

