/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components;

import com.vividsolutions.jump.workbench.ui.components.RecordChangedListener;
import de.riwagis.icons.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class RecordPanel<T>
extends JPanel {
    public static final Map<String, String> NO_ATTRIBUTES = Collections.emptyMap();
    private final List<T> records = new ArrayList<T>();
    private final Collection<RecordChangedListener> recordChangedListeners = new LinkedHashSet<RecordChangedListener>();
    private final JButton startButton = new JButton();
    private final JButton prevButton = new JButton();
    private final JTextField textField = new JTextField(8);
    private final JButton nextButton = new JButton();
    private final JButton endButton = new JButton();
    private final Map<T, Integer> recordToIndex = new HashMap<T, Integer>();
    private int currentIndex = -1;
    private JComponent recordComponent;
    private JToolBar toolBar;

    public RecordPanel() {
        this.initialize();
    }

    public JComponent getRecordComponent() {
        return this.recordComponent;
    }

    public void setRecordComponent(JComponent recordComponent) {
        if (this.recordComponent != null) {
            this.remove(this.recordComponent);
        }
        this.recordComponent = recordComponent;
        if (this.recordComponent != null) {
            this.add((Component)this.recordComponent, "Center");
        }
    }

    private void setIcon(JButton button, String filename) {
        button.setIcon(IconLoader.svgIcon((String)filename));
    }

    protected void updateAppearance() {
        this.startButton.setEnabled(this.getCurrentIndex() > 0);
        this.prevButton.setEnabled(this.getCurrentIndex() > 0);
        this.nextButton.setEnabled(this.getCurrentIndex() < this.getRecordCount() - 1);
        this.endButton.setEnabled(this.getCurrentIndex() < this.getRecordCount() - 1);
        this.textField.setText(this.getCurrentIndex() + 1 + " / " + this.getRecordCount());
    }

    protected void nextButton_actionPerformed(ActionEvent e) {
        this.setCurrentIndex(this.getCurrentIndex() + 1);
        this.updateAppearance();
    }

    protected void endButton_actionPerformed(ActionEvent e) {
        this.setCurrentIndex(this.getRecordCount() - 1);
        this.updateAppearance();
    }

    protected void prevButton_actionPerformed(ActionEvent e) {
        this.setCurrentIndex(this.getCurrentIndex() - 1);
        this.updateAppearance();
    }

    protected void startButton_actionPerformed(ActionEvent e) {
        this.setCurrentIndex(0);
        this.updateAppearance();
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int index) {
        this.currentIndex = index;
        this.fireRecordChanged(this.currentIndex);
    }

    public int setCurrentRecord(T record) {
        Integer index = this.recordToIndex.get(record);
        if (index == null) {
            return -1;
        }
        this.setCurrentIndex(index);
        return index;
    }

    public void removeAllRecords() {
        this.currentIndex = -1;
        this.records.clear();
        this.recordToIndex.clear();
        this.updateAppearance();
        this.fireRecordChanged(this.currentIndex);
    }

    private void initialize() {
        this.startButton.addActionListener(this::startButton_actionPerformed);
        this.startButton.setMargin(new Insets(0, 0, 0, 0));
        this.prevButton.addActionListener(this::prevButton_actionPerformed);
        this.prevButton.setMargin(new Insets(0, 0, 0, 0));
        this.nextButton.addActionListener(this::nextButton_actionPerformed);
        this.nextButton.setMargin(new Insets(0, 0, 0, 0));
        this.endButton.addActionListener(this::endButton_actionPerformed);
        this.endButton.setMargin(new Insets(0, 0, 0, 0));
        this.textField.setEditable(false);
        this.textField.setHorizontalAlignment(4);
        this.textField.setMaximumSize(this.textField.getPreferredSize());
        this.textField.setMargin(new Insets(0, 0, 0, 0));
        this.setIcon(this.startButton, "show_first.svg");
        this.setIcon(this.prevButton, "show_previous.svg");
        this.setIcon(this.nextButton, "show_next.svg");
        this.setIcon(this.endButton, "show_last.svg");
        this.updateAppearance();
        this.toolBar = new JToolBar();
        this.toolBar.add(this.startButton);
        this.toolBar.add(this.prevButton);
        this.toolBar.add(this.textField);
        this.toolBar.add(this.nextButton);
        this.toolBar.add(this.endButton);
        this.toolBar.add(Box.createHorizontalGlue());
        this.toolBar.setFloatable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
    }

    public void addToNavigationBar(JComponent component) {
        this.toolBar.add(component);
    }

    public void showNavigationControls(boolean visible) {
        this.toolBar.setVisible(visible);
    }

    private void gotToLatestRecord() {
        this.setCurrentIndex(this.records.size() - 1);
    }

    public int addRecord(T record) {
        this.records.add(record);
        if (this.records.size() == 1) {
            this.gotToLatestRecord();
        }
        this.updateAppearance();
        int recordIndex = this.records.size() - 1;
        this.recordToIndex.put(record, recordIndex);
        return recordIndex;
    }

    public void setRecord(int index, T record) {
        this.records.set(index, record);
        for (Map.Entry<T, Integer> entry : this.recordToIndex.entrySet()) {
            if (entry.getValue() != index) continue;
            this.recordToIndex.remove(entry.getKey());
            break;
        }
        this.recordToIndex.put(record, index);
        if (index == this.currentIndex) {
            this.fireRecordChanged(index);
        }
    }

    public T getRecord(int index) {
        return this.records.get(index);
    }

    public T getCurrentRecord() {
        return this.records.get(this.getCurrentIndex());
    }

    public int getRecordCount() {
        return this.records.size();
    }

    public void addRecordChangeListener(RecordChangedListener listener) {
        this.recordChangedListeners.add(listener);
    }

    public void removeRecordChangeListener(RecordChangedListener listener) {
        this.recordChangedListeners.remove(listener);
    }

    public void removeAllRecordChangeListener() {
        this.recordChangedListeners.clear();
    }

    private void fireRecordChanged(int changedIndex) {
        for (RecordChangedListener currActionListener : this.recordChangedListeners) {
            currActionListener.recordChanged(changedIndex);
        }
    }
}

