/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components;

import com.vividsolutions.jump.I18N;
import java.awt.Toolkit;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IntegerTextField
extends JTextField {
    private long maxValue = Integer.MAX_VALUE;
    private long minValue = Integer.MIN_VALUE;
    private int maxLength = String.valueOf(this.maxValue).length();
    private boolean isIPField = false;

    @Override
    protected Document createDefaultModel() {
        return new IntegerDocument();
    }

    public void setMinValue(long value) {
        this.minValue = value;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setIPField(boolean value) {
        this.isIPField = value;
    }

    public boolean getIPField() {
        return this.isIPField;
    }

    public void setMaxValue(long value) {
        this.maxValue = value;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxLength(int value) {
        this.maxLength = value;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    private class IntegerDocument
    extends PlainDocument {
        private IntegerDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            long typedValue = -1L;
            StringBuffer textBuffer = new StringBuffer(IntegerTextField.this.getText().trim());
            if (offs >= 0 && offs <= textBuffer.length()) {
                textBuffer.insert(offs, str);
                String textValue = textBuffer.toString();
                if (textBuffer.length() > IntegerTextField.this.maxLength) {
                    JOptionPane.showMessageDialog(IntegerTextField.this, I18N.get("ui.IntegerTextField.tolong") + " " + IntegerTextField.this.getMaxLength(), I18N.get("ui.IntegerTextField.error"), 0);
                    return;
                }
                if (textValue == null || textValue.equals("")) {
                    this.remove(0, this.getLength());
                    super.insertString(0, "", null);
                    return;
                }
                if (textValue.equals("-") && IntegerTextField.this.minValue < 0L) {
                    super.insertString(offs, new String(str), a);
                    return;
                }
                if (str.equals(".") && IntegerTextField.this.isIPField) {
                    super.insertString(offs, new String(str), a);
                    return;
                }
                try {
                    typedValue = Long.parseLong(textValue);
                    if (typedValue > IntegerTextField.this.maxValue || typedValue < IntegerTextField.this.minValue) {
                        JOptionPane.showMessageDialog(IntegerTextField.this, I18N.get("ui.IntegerTextField.wrongnumber") + " " + IntegerTextField.this.getMinValue() + " - " + IntegerTextField.this.getMaxValue(), I18N.get("ui.IntegerTextField.error"), 0);
                    } else {
                        super.insertString(offs, new String(str), a);
                    }
                }
                catch (NumberFormatException ex) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(IntegerTextField.this, I18N.get("ui.IntegerTextField.onlynumeric"), I18N.get("ui.IntegerTextField.error"), 0);
                }
            }
        }
    }
}

