/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.HtmlBuilder;
import com.vividsolutions.jump.workbench.ui.components.RecordPanel;
import de.riwagis.browser.BrowserPanel;
import de.riwagis.browser.WindowManager;
import de.riwagis.browser.util.BrowserSupport;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.OSFile;
import java.awt.Color;
import java.io.File;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLPanel
extends RecordPanel<Record> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HTMLPanel.class);
    private JButton linkButton;
    private BrowserPanel browserPanel;

    public HTMLPanel() {
        this.setRecordComponent(this.createRecordComponent());
        this.addRecordChangeListener(index -> {
            if (index != -1) {
                this.updateRecordComponent();
            }
        });
        this.initialize();
    }

    private void initialize() {
        this.linkButton = new JButton();
        this.linkButton.setIcon(IconLoader.svgIcon((String)"show_link.svg"));
        this.linkButton.setToolTipText(I18N.get("ui.components.HTMLPanel.link-browser"));
        this.linkButton.addActionListener(e -> {
            if (this.getRecordCount() <= 0) {
                return;
            }
            String documentURL = this.browserPanel.getURL();
            if (documentURL == null || documentURL.isEmpty() || documentURL.equals("about:blank")) {
                documentURL = ((Record)this.getCurrentRecord()).getLink();
            }
            if (documentURL.toLowerCase().startsWith("http")) {
                BrowserSupport.openBrowser((String)documentURL);
            } else {
                OSFile.showFile((File)new File(documentURL), (boolean)false);
            }
        });
        this.addToNavigationBar(this.linkButton);
    }

    private JComponent createRecordComponent() {
        this.browserPanel = WindowManager.getInstance().createBrowserPanel();
        this.browserPanel.setOpenLinkExternal(true);
        return this.browserPanel;
    }

    private void updateRecordComponent() {
        String document = ((Record)this.getCurrentRecord()).getContent();
        String documentURL = ((Record)this.getCurrentRecord()).getLink();
        SwingUtilities.invokeLater(() -> {
            if (document == null || document.isEmpty()) {
                this.browserPanel.navigate(documentURL);
            } else {
                this.browserPanel.setHTML(document);
            }
            this.linkButton.setVisible(documentURL != null && documentURL.length() > 0);
        });
    }

    public Color getBackgroundColor() {
        return this.browserPanel.getBackground();
    }

    public void setBackgroundColor(Color color) {
        this.browserPanel.setBackground(color);
    }

    public void createNewDocument(String content, String uri) {
        this.addRecord(new Record(new HtmlBuilder(content).build(), uri));
    }

    public void refresh(boolean updateContent) {
        if (this.getCurrentIndex() == -1) {
            return;
        }
        if (updateContent) {
            this.updateRecordComponent();
        } else {
            this.browserPanel.refresh();
        }
    }

    public void dispose() {
        if (this.browserPanel != null) {
            this.browserPanel.dispose();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public static class Record {
        private final String content;
        private final String url;

        public Record(String content, String url) {
            this.content = content;
            this.url = url;
        }

        public String getContent() {
            return this.content;
        }

        public String getLink() {
            return this.url;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.url);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Record other = (Record)obj;
            return Objects.equals(this.url, other.url);
        }
    }
}

