/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import lombok.Generated;

public class ErrorListDialog
extends JOptionPane {
    private static final long serialVersionUID = -4581656099734994482L;
    private static final String SHOW_DETAILS = I18N.get("ui.ErrorDialog.show-details");
    private static final String HIDE_DETAILS = I18N.get("ui.ErrorDialog.hide-details");
    public static final String CANCEL = I18N.get("ui.ErrorDialog.cancel");
    private static final int MIN_DIALOG_WIDTH = 500;
    private List<String> messages;
    private boolean showCancel;
    private String confirmButtonText = I18N.get("common.ok");

    public ErrorListDialog() {
        super(I18N.get("ui.ErrorDialog.message"), 0, -1);
    }

    private void addDetailPanel(final JDialog dialog, final JButton detailButton) {
        final JPanel panel = new JPanel(new GridBagLayout());
        final JScrollPane scrollPane = new JScrollPane();
        JList<String> list = new JList<String>();
        list.setModel(new DefaultComboBoxModel<String>((String[])this.messages.toArray(String[]::new)));
        list.setOpaque(false);
        list.setFont(UIManager.getFont("TextArea.font"));
        scrollPane.setOpaque(false);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.getViewport().add(list);
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        detailButton.addActionListener(new ActionListener(){
            private boolean showingDetails = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.showingDetails) {
                    dialog.remove(panel);
                    detailButton.setText(SHOW_DETAILS);
                } else {
                    scrollPane.setPreferredSize(new Dimension(dialog.getWidth(), 200));
                    dialog.getContentPane().add((Component)panel, "South");
                    detailButton.setText(HIDE_DETAILS);
                }
                this.showingDetails = !this.showingDetails;
                dialog.pack();
            }
        });
    }

    private void setMessages(List<String> messages) {
        this.messages = messages;
    }

    @Override
    public JDialog createDialog(Component parentComponent, String title) {
        JButton okButton = new JButton(this.getConfirmButtonText());
        JButton detailButton = new JButton(SHOW_DETAILS);
        JButton cancelButton = new JButton(CANCEL);
        if (this.showCancel) {
            cancelButton.addActionListener(e -> this.setValue(CANCEL));
            this.setOptions(new Object[]{okButton, detailButton, cancelButton});
        } else {
            this.setOptions(new Object[]{okButton, detailButton});
        }
        JDialog dialog = super.createDialog(parentComponent, title);
        this.addDetailPanel(dialog, detailButton);
        okButton.addActionListener(e -> {
            this.setValue(this.confirmButtonText);
            dialog.setVisible(false);
        });
        if (this.showCancel) {
            cancelButton.addActionListener(e -> {
                this.setValue(CANCEL);
                dialog.setVisible(false);
            });
        }
        JPanel horizontalStrut = new JPanel();
        horizontalStrut.setPreferredSize(new Dimension(500, 0));
        horizontalStrut.setMinimumSize(horizontalStrut.getPreferredSize());
        horizontalStrut.setMaximumSize(horizontalStrut.getPreferredSize());
        dialog.getContentPane().add((Component)horizontalStrut, "North");
        dialog.pack();
        if (parentComponent != null) {
            GUIUtil.centreOnWindow(dialog);
        }
        dialog.setResizable(false);
        return dialog;
    }

    public static Object show(Component parentComponent, String title, String message, List<String> detailList) {
        return ErrorListDialog.show(parentComponent, title, null, message, detailList, false);
    }

    public static Object show(Component parentComponent, String title, String confirmButtonText, String message, List<String> detailList, boolean showCancel) {
        ErrorListDialog dialog = new ErrorListDialog();
        dialog.setMessage(message);
        dialog.setMessages(detailList);
        if (confirmButtonText != null) {
            dialog.setConfirmButtonText(confirmButtonText);
        }
        dialog.showCancel = showCancel;
        JDialog dlg = dialog.createDialog(parentComponent, title);
        dlg.setVisible(true);
        dlg.dispose();
        return dialog.getValue();
    }

    @Generated
    public void setConfirmButtonText(String confirmButtonText) {
        this.confirmButtonText = confirmButtonText;
    }

    @Generated
    public String getConfirmButtonText() {
        return this.confirmButtonText;
    }
}

