/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.locationtech.jts.util.Assert;

public abstract class ColumnBasedTableModel
implements TableModel {
    private final ArrayList<Column> columns = new ArrayList();
    private final ArrayList<TableModelListener> listeners = new ArrayList();
    private boolean firingEvents = true;

    protected Column getColumn(int column) {
        if (column == -1) {
            column = this.columns.size() - 1;
        }
        return this.columns.get(column);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumn(columnIndex).getName();
    }

    public String getColumnAttributeName(int columnIndex) {
        return this.getColumn(columnIndex).getAttributeName();
    }

    public int indexOfColumn(String name) {
        for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            if (!column.getName().equals(name)) continue;
            return i;
        }
        Assert.shouldNeverReachHere((String)name);
        return -1;
    }

    protected void setColumns(Collection<Column> columns) {
        this.columns.clear();
        this.columns.addAll(columns);
    }

    public Class getColumnClass(int columnIndex) {
        return this.getColumn(columnIndex).getDataClass();
    }

    protected void setFiringEvents(boolean firingEvents) {
        this.firingEvents = firingEvents;
    }

    protected boolean isFiringEvents() {
        return this.firingEvents;
    }

    protected void fireTableChanged(TableModelEvent e) {
        if (!this.firingEvents) {
            return;
        }
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(e);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getColumn(columnIndex).getValueAt(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.getColumn(columnIndex).setValueAt(aValue, rowIndex);
    }

    public abstract class Column {
        private final String name;
        private final Class<?> dataClass;
        private final String attributeName;

        public Column(ColumnBasedTableModel this$0, String name, Class<?> dataClass) {
            this(this$0, name, dataClass, name);
        }

        public Column(ColumnBasedTableModel this$0, String name, Class<?> dataClass, String attributeName) {
            this.name = name;
            this.dataClass = dataClass;
            this.attributeName = attributeName;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getDataClass() {
            return this.dataClass;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public abstract Object getValueAt(int var1);

        public abstract void setValueAt(Object var1, int var2);
    }
}

