/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class ColorPanel
extends JPanel {
    private Color fillColor = Color.red;
    private int margin = 0;
    private static final BasicStroke fillStroke = new BasicStroke(1.0f);
    private Color lineBaseColor = Color.green;
    private int lineBaseWidth = 3;
    private BasicStroke lineBaseStroke = new BasicStroke(this.lineBaseWidth);
    private Color lineForegroundColor = null;
    private int lineForegroundWidth = 1;
    private BasicStroke lineForegroundStroke = new BasicStroke(this.lineForegroundWidth);
    private Color lineBackgroundColor = null;
    private int lineBackgroundWidth = 5;
    private BasicStroke lineBackgroundStroke = new BasicStroke(this.lineBackgroundWidth);

    public ColorPanel() {
        this.setBackground(Color.white);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isEnabled()) {
            return;
        }
        Color originalColor = g.getColor();
        g.setColor(this.getBackground());
        ((Graphics2D)g).setStroke(fillStroke);
        g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.setColor(this.fillColor);
        g.fillRect(this.margin, this.margin, this.getWidth() - 1 - this.margin - this.margin, this.getHeight() - 1 - this.margin - this.margin);
        float inset = 1.0f;
        if (this.lineBackgroundColor != null) {
            g.setColor(this.lineBackgroundColor);
            ((Graphics2D)g).setStroke(this.lineBackgroundStroke);
            inset = (float)this.lineBackgroundWidth / 2.0f;
            g.drawRect(this.margin, this.margin, this.getWidth() - (int)inset - this.margin - this.margin, this.getHeight() - 1 - this.margin - this.margin);
        }
        if (this.lineBaseColor != null) {
            g.setColor(this.lineBaseColor);
            ((Graphics2D)g).setStroke(this.lineBaseStroke);
            inset = Math.max(inset, (float)this.lineBaseWidth / 2.0f);
            g.drawRect(this.margin, this.margin, this.getWidth() - (int)inset - this.margin - this.margin, this.getHeight() - 1 - this.margin - this.margin);
        }
        if (this.lineForegroundColor != null) {
            g.setColor(this.lineForegroundColor);
            ((Graphics2D)g).setStroke(this.lineForegroundStroke);
            g.drawRect(this.margin, this.margin, this.getWidth() - (int)inset - this.margin - this.margin, this.getHeight() - 1 - this.margin - this.margin);
        }
        g.setColor(originalColor);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.validate();
    }

    public void setFillColor(Color newFillColor) {
        this.fillColor = newFillColor;
    }

    public void setMargin(int newMargin) {
        this.margin = newMargin;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setLineBaseColor(Color newLineBaseColor) {
        this.lineBaseColor = newLineBaseColor;
    }

    public Color getLineBaseColor() {
        return this.lineBaseColor;
    }

    public void setLineBaseWidth(int newLineBaseWidth) {
        this.lineBaseStroke = new BasicStroke(newLineBaseWidth);
        this.lineBaseWidth = newLineBaseWidth;
    }

    public int getLineBaseWidth() {
        return this.lineBaseWidth;
    }

    public void setLineForegroundColor(Color newLineForegroundColor) {
        this.lineForegroundColor = newLineForegroundColor;
    }

    public Color getForegroundLineColor() {
        return this.lineForegroundColor;
    }

    public void setLineForegroundWidth(int newLineForegroundWidth) {
        this.lineForegroundStroke = new BasicStroke(newLineForegroundWidth);
        this.lineForegroundWidth = newLineForegroundWidth;
    }

    public int getLineForegroundWidth() {
        return this.lineForegroundWidth;
    }

    public void setLineBackgroundColor(Color newLineBackgroundColor) {
        this.lineBackgroundColor = newLineBackgroundColor;
    }

    public Color getLineBackgroundColor() {
        return this.lineBackgroundColor;
    }

    public void setLineBackgroundWidth(int newLineBackgroundWidth) {
        this.lineBackgroundStroke = new BasicStroke(newLineBackgroundWidth);
        this.lineBackgroundWidth = newLineBackgroundWidth;
    }

    public int getLineBackgroundWidth() {
        return this.lineBackgroundWidth;
    }
}

