/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components;

import java.awt.Component;
import java.util.Map;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;

class CheckBoxListRenderer<T>
extends JCheckBox
implements ListCellRenderer<T> {
    private static final long serialVersionUID = 5823082636102416078L;
    private final Border FOCUS_BORDER = UIManager.getBorder("List.focusCellHighlightBorder");
    private final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private final Map<T, Boolean> selectionState;
    private final Function<T, String> textResolver;

    public CheckBoxListRenderer(Map<T, Boolean> selectionState, Function<T, String> textResolver) {
        this.selectionState = selectionState;
        this.textResolver = textResolver;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean hasFocus) {
        boolean selected = this.selectionState.getOrDefault(value, false);
        this.setFocusPainted(false);
        this.setBorderPainted(true);
        this.setEnabled(list.isEnabled());
        this.setSelected(selected);
        this.setFont(list.getFont());
        this.setBackground(selected ? list.getSelectionBackground() : list.getBackground());
        this.setForeground(selected ? list.getSelectionForeground() : list.getForeground());
        this.setBorder(selected ? this.FOCUS_BORDER : this.NO_FOCUS_BORDER);
        this.setText(this.textResolver.apply(value));
        return this;
    }
}

