/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.components;

import com.vividsolutions.jump.workbench.ui.components.CheckBoxListRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public final class CheckBoxList<T>
extends JList<T> {
    private static final long serialVersionUID = -7585960782229581080L;
    private final Map<T, Boolean> selectionState = new HashMap<T, Boolean>();

    public CheckBoxList(Collection<T> values, Function<T, String> textResolver) {
        super(new DefaultListModel());
        ((DefaultListModel)this.getModel()).addAll(values);
        this.setCellRenderer(new CheckBoxListRenderer<T>(this.selectionState, textResolver));
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = CheckBoxList.this.locationToIndex(e.getPoint());
                if (index != -1) {
                    Object target = CheckBoxList.this.getModel().getElementAt(index);
                    CheckBoxList.this.selectionState.compute(target, (k, v) -> v == null || v == false);
                    CheckBoxList.this.repaint();
                }
            }
        });
    }

    public Set<T> getCheckedValues() {
        return this.selectionState.entrySet().stream().filter(e -> (Boolean)e.getValue() == true).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
    }
}

