/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.addremove;

import com.vividsolutions.jump.workbench.ui.InputChangedFirer;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemoveList;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemoveListModel;
import com.vividsolutions.jump.workbench.ui.addremove.TreeAddRemoveListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeAddRemoveList<M>
extends JPanel
implements AddRemoveList<M> {
    private static final Logger LOG = LoggerFactory.getLogger(TreeAddRemoveList.class);
    private static final long serialVersionUID = 1389962531683393710L;
    private final BorderLayout borderLayout1 = new BorderLayout();
    private TreeAddRemoveListModel<M> model = this.createEmptyModel();
    private final InputChangedFirer inputChangedFirer = new InputChangedFirer();
    private final JTree tree = new JTree();

    @Override
    public void add(MouseListener listener) {
        this.tree.addMouseListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tree.setEnabled(enabled);
    }

    public TreeAddRemoveList() {
        this.tree.getSelectionModel().addTreeSelectionListener(e -> this.inputChangedFirer.fire());
        this.tree.setModel(this.model.getTreeModel());
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LOG.error("Error initializing Panel", (Throwable)ex);
        }
        ToolTipManager.sharedInstance().registerComponent(this.tree);
    }

    @Override
    public void setSelectedItems(Collection<M> items) {
        throw new UnsupportedOperationException();
    }

    public void setModel(TreeAddRemoveListModel<M> model) {
        this.model = model != null ? model : this.createEmptyModel();
        this.tree.setModel(this.model.getTreeModel());
        this.inputChangedFirer.fire();
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    final void jbInit() {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.tree, "Center");
    }

    @Override
    public AddRemoveListModel<M> getModel() {
        return this.model;
    }

    @Override
    public List<M> getSelectedItems() {
        ArrayList<Object> selectedNodes = new ArrayList<Object>();
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return selectedNodes;
        }
        for (TreePath selectionPath : selectionPaths) {
            Object currPathComponent = selectionPath.getLastPathComponent();
            selectedNodes.add(currPathComponent);
        }
        return selectedNodes;
    }

    @Override
    public void addSelectionListener(EventListener selListener) {
        this.tree.addTreeSelectionListener((TreeSelectionListener)selListener);
    }

    private TreeAddRemoveListModel<M> createEmptyModel() {
        return new TreeAddRemoveListModel(new DefaultTreeModel(new DefaultMutableTreeNode("")));
    }
}

