/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.addremove;

import com.vividsolutions.jump.workbench.ui.addremove.AddRemoveListModel;
import de.riwagis.util.lang.StringComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class DefaultAddRemoveListModel<M>
implements AddRemoveListModel<M> {
    private final DefaultListModel<M> listModel;
    private boolean sorted = false;
    private final StringComparator sComp = new StringComparator();

    public DefaultAddRemoveListModel(DefaultListModel<M> listModel) {
        this.listModel = listModel;
    }

    public ListModel<M> getListModel() {
        return this.listModel;
    }

    @Override
    public void add(M item) {
        if (this.sorted && !this.listModel.isEmpty()) {
            int insertIndex = this.findInsertionIndex(item);
            this.listModel.add(insertIndex, item);
        } else {
            this.listModel.addElement(item);
        }
    }

    private int findInsertionIndex(M item) {
        for (int i = 0; i < this.listModel.size(); ++i) {
            if (this.sComp.compare(item, this.listModel.get(i)) > 0) continue;
            return i;
        }
        return this.listModel.size();
    }

    private void setItemsWithoutSorting(Collection<M> items) {
        this.listModel.clear();
        Iterator<M> i = items.iterator();
        while (i.hasNext()) {
            this.listModel.addElement(i.next());
        }
    }

    @Override
    public void setItems(Collection<M> items) {
        this.setItemsWithoutSorting(items);
        if (this.sorted) {
            this.sort();
        }
    }

    private void sort() {
        ArrayList<M> items = new ArrayList<M>(this.getItems());
        Collections.sort(items, this.sComp);
        this.setItemsWithoutSorting(items);
    }

    @Override
    public List<M> getItems() {
        return Arrays.asList(this.listModel.toArray());
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
        this.sort();
    }

    @Override
    public void remove(M item) {
        this.listModel.removeElement(item);
    }
}

