/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.addremove;

import com.vividsolutions.jump.workbench.ui.InputChangedFirer;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.JListTypeAheadKeyListener;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemoveList;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemoveListModel;
import com.vividsolutions.jump.workbench.ui.addremove.DefaultAddRemoveListModel;
import com.vividsolutions.jump.workbench.ui.addremove.JListWithElementTooltips;
import java.awt.BorderLayout;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAddRemoveList<M>
extends JPanel
implements AddRemoveList<M> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAddRemoveList.class);
    private static final long serialVersionUID = 3640971510871553643L;
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final JList<M> list = new JListWithElementTooltips();
    private final DefaultAddRemoveListModel<M> model;
    private final InputChangedFirer inputChangedFirer = new InputChangedFirer();

    public DefaultAddRemoveList() {
        this(new DefaultListModel());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.list.setEnabled(enabled);
    }

    @Override
    public void add(MouseListener listener) {
        this.list.addMouseListener(listener);
    }

    public DefaultAddRemoveList(DefaultListModel<M> listModel) {
        this.model = new DefaultAddRemoveListModel<M>(listModel);
        this.list.setModel(listModel);
        this.list.addKeyListener(new JListTypeAheadKeyListener(this.list));
        this.list.getSelectionModel().addListSelectionListener(e -> this.inputChangedFirer.fire());
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LOG.error("Error init dialog", (Throwable)ex);
        }
    }

    @Override
    public void setSelectedItems(Collection<M> items) {
        ArrayList<Integer> indicesToSelect = new ArrayList<Integer>();
        for (M item : items) {
            int index = this.getModel().getItems().indexOf(item);
            if (index == -1) continue;
            indicesToSelect.add(index);
        }
        int[] indexArray = new int[indicesToSelect.size()];
        for (int i = 0; i < indicesToSelect.size(); ++i) {
            indexArray[i] = (Integer)indicesToSelect.get(i);
        }
        this.list.setSelectedIndices(indexArray);
    }

    @Override
    public AddRemoveListModel<M> getModel() {
        return this.model;
    }

    @Override
    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    @Override
    public void addSelectionListener(EventListener selListener) {
        this.list.addListSelectionListener((ListSelectionListener)selListener);
    }

    public JList<M> getList() {
        return this.list;
    }

    @Override
    public List<M> getSelectedItems() {
        return this.list.getSelectedValuesList();
    }

    final void jbInit() {
        this.setLayout(this.borderLayout1);
        this.add(this.list, "Center");
    }
}

