/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.ui.EnableableToolBar;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DelegatingCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import org.locationtech.jts.util.Assert;

public class WorkbenchToolBar
extends EnableableToolBar {
    private final Map<Class, ToolConfig> toolConfigs = new HashMap<Class, ToolConfig>();
    private LayerViewPanelProxy layerViewPanelProxy;
    private TaskMonitorManager taskMonitorManager = new TaskMonitorManager();
    private ButtonGroup cursorToolButtonGroup;

    public WorkbenchToolBar(LayerViewPanelProxy layerViewPanelProxy) {
        this(layerViewPanelProxy, new ButtonGroup());
    }

    public WorkbenchToolBar(LayerViewPanelProxy layerViewPanelProxy, ButtonGroup cursorToolButtonGroup) {
        this.cursorToolButtonGroup = cursorToolButtonGroup;
        this.layerViewPanelProxy = layerViewPanelProxy;
    }

    public void setTaskMonitorManager(TaskMonitorManager taskMonitorManager) {
        this.taskMonitorManager = taskMonitorManager;
    }

    public ToolConfig addCursorTool(final CursorTool cursorTool, EnableCheck enableCheck) {
        return this.addCursorTool(cursorTool.getName(), cursorTool, new JToggleButton(){

            @Override
            public String getToolTipText(MouseEvent event) {
                return cursorTool.getName();
            }
        }, enableCheck);
    }

    public ToolConfig addCursorTool(String tooltip, CursorTool cursorTool, EnableCheck enableCheck) {
        JToggleButton button = new JToggleButton();
        return this.addCursorTool(tooltip, cursorTool, button, enableCheck);
    }

    private ToolConfig addCursorTool(String tooltip, CursorTool cursorTool, JToggleButton button, EnableCheck enableCheck) {
        this.cursorToolButtonGroup.add(button);
        final QuasimodeTool quasimodeTool = QuasimodeTool.addStandardQuasimodes(cursorTool);
        this.add(button, tooltip, cursorTool.getIcon(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WorkbenchToolBar.this.layerViewPanelProxy.getLayerViewPanel() != null) {
                    WorkbenchToolBar.this.layerViewPanelProxy.getLayerViewPanel().setCurrentCursorTool(quasimodeTool);
                }
            }
        }, enableCheck);
        if (this.cursorToolButtonGroup.getButtonCount() == 1) {
            this.cursorToolButtonGroup.setSelected(button.getModel(), true);
            this.reClickSelectedCursorToolButton();
        }
        ToolConfig tc = new ToolConfig(button, quasimodeTool);
        Class<?> ctClass = cursorTool.getClass();
        if (cursorTool instanceof DelegatingCursorTool) {
            ctClass = ((DelegatingCursorTool)cursorTool).getInnerDelegate().getClass();
        }
        this.toolConfigs.put(ctClass, tc);
        return tc;
    }

    public ButtonGroup getButtonGroup() {
        return this.cursorToolButtonGroup;
    }

    public JToggleButton getSelectedCursorToolButton() {
        Enumeration<AbstractButton> e = this.cursorToolButtonGroup.getElements();
        while (e.hasMoreElements()) {
            JToggleButton button = (JToggleButton)e.nextElement();
            if (button.getModel() != this.cursorToolButtonGroup.getSelection()) continue;
            return button;
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public void reClickSelectedCursorToolButton() {
        if (this.cursorToolButtonGroup.getButtonCount() == 0) {
            return;
        }
        this.getSelectedCursorToolButton().doClick();
    }

    public AbstractButton addPlugIn(Icon icon, PlugIn plugIn, EnableCheck enableCheck, WorkbenchContext workbenchContext) {
        return this.addPlugIn(icon, plugIn, enableCheck, workbenchContext, false);
    }

    public AbstractButton addPlugIn(Icon icon, PlugIn plugIn, EnableCheck enableCheck, WorkbenchContext workbenchContext, boolean isToggleable) {
        if (!plugIn.isAvailable()) {
            return null;
        }
        AbstractButton button = isToggleable ? new JToggleButton() : new JButton();
        this.add(button, plugIn.getName(), icon, AbstractPlugIn.toActionListener(plugIn, workbenchContext, this.taskMonitorManager), enableCheck);
        return button;
    }

    public ToolConfig getToolConfig4Class(Class clazz) {
        return this.toolConfigs.get(clazz);
    }

    public static class ToolConfig {
        private final JToggleButton button;
        private final QuasimodeTool quasimodeTool;

        public ToolConfig(JToggleButton button, QuasimodeTool quasimodeTool) {
            this.button = button;
            this.quasimodeTool = quasimodeTool;
        }

        public JToggleButton getButton() {
            return this.button;
        }

        public QuasimodeTool getQuasimodeTool() {
            return this.quasimodeTool;
        }
    }
}

