/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.util.UserFriendlyException;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CadLayer;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.DimLayer;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.HasName;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.RasterImageLayer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.model.WMTSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableStateListener;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.ui.ApplicationExitHandler;
import com.vividsolutions.jump.workbench.ui.DesktopPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.LoadTaskTransferHandler;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.Priorizable;
import com.vividsolutions.jump.workbench.ui.RecursiveKeyListener;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameChangedListener;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.WindowVisibleKeeper;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.components.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DummyTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectFeaturesTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPanel;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.selection.SelectionListener;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import com.vividsolutions.jump.workbench.ui.tools.ScreenScale;
import com.vividsolutions.jump.workbench.ui.workbenchframe.WBFLayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.zoom.NavigationPanel;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToScalePlugIn;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.gis.context.GisContext;
import de.riwagis.gis.context.module.ModuleAppContext;
import de.riwagis.icons.IconLoader;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.gui.dialogs.ExpandableDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import lombok.Generated;
import org.apache.commons.text.WordUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchFrame
extends JFrame
implements LayerViewPanelContext,
ViewportListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkbenchFrame.class);
    public static final String RIGHT_PANE_SELECTED_COMPONENT_KEY = "RIGHT_PANE_SELECTED_COMPONENT";
    private final AtomicBoolean bolInInfo = new AtomicBoolean();
    private final List<String> lstNextInfos = new ArrayList<String>();
    public static final String WINDOW_DIM_KEY = "WMFRAME_DIM";
    public static final String WINDOW_POS_KEY = "WMFRAME_POS";
    public static final String WINDOW_SCREEN_KEY = "WMFRAME_SCREEN";
    public static final String WINDOW_MAXIMIZED_KEY = "WMFRAME_MAXIMIZED";
    private final LayoutManager borderLayout1 = new BorderLayout();
    private final JMenuBar jMenuBar = new JMenuBar(){

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            Object[] obj = WorkbenchFrame.this.keyCodeAndModifiersToPlugInAndEnableCheckMap.get(e.getKeyCode() + ":" + e.getModifiersEx());
            if (obj != null) {
                return false;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }
    };
    private final Map<String, Object[]> keyCodeAndModifiersToPlugInAndEnableCheckMap = new HashMap<String, Object[]>();
    private final JMenu fileMenu = (JMenu)FeatureInstaller.installMnemonic(new JMenu(MenuNames.FILE), this.jMenuBar);
    private final JMenuItem exitMenuItem = FeatureInstaller.installMnemonic(new JMenuItem(I18N.get("ui.WorkbenchFrame.exit")), this.fileMenu);
    private final LayoutManager gridBagLayout1 = new GridBagLayout();
    private final JLabel coordinateLabel = new JLabel();
    private final JLabel crsLabel = new JLabel();
    private final JComboBox<Object> scaleCombo = new JComboBox();
    private boolean bolBlockScaleEvent = false;
    private final StringBuilder sbCurrentScale = new StringBuilder();
    private final JLabel messageLabel = new JLabel();
    private final JLabel projectReductionLabel = new JLabel();
    private final JPanel statusPanel = new JPanel();
    private final JLabel versionLabel = new JLabel();
    private final JXBusyLabel busyLabel = new JXBusyLabel(new Dimension(21, 21));
    private final WorkbenchToolBar toolBar;
    private final JMenu windowMenu = (JMenu)FeatureInstaller.installMnemonic(new JMenu(MenuNames.WINDOW), this.jMenuBar);
    private int intWindowMenuCount = -1;
    private final DesktopPanel desktopPanel = new DesktopPanel();
    private final LayerNamePanelListener layerNamePanelListener = this::updateEnabledState;
    private final WBFLayerViewPanelListener layerViewPanelListener = new WBFLayerViewPanelListener(this, this.coordinateLabel);
    private int taskSequence = 1;
    private final WorkbenchContext workbenchContext;
    private final JLabel memoryLabel = new JLabel();
    private final ReadWriteLock easyKeyListenersLock = new ReentrantReadWriteLock();
    private final List<KeyListener> easyKeyListeners = new ArrayList<KeyListener>();
    private int iFramePositionIndex = -1;
    private final List<EnableStateListener> lstEnableStateListener = new ArrayList<EnableStateListener>();
    private JSplitPane splitPane = new JSplitPane();
    private int dividerSize;
    private int dividerPos = -1;
    private final List<TaskFrameChangedListener> taskFrameChangedListeners = new ArrayList<TaskFrameChangedListener>();
    private final ApplicationExitHandler applicationExitHandler = new DefaultApplicationExitHandler();
    private final TitledPopupMenu categoryPopupMenu = this.initializeTitledPopUpMenu(Category.class, "ui.WorkbenchFrame.categories-selected");
    private final TitledPopupMenu categoryPopupMenuBuildIn = this.initializeTitledPopUpMenu(Category.class, "ui.WorkbenchFrame.categories-selected");
    private final TitledPopupMenu layerNamePopupMenu = this.createDefaultTitledPopupMenu();
    private final TitledPopupMenu layerNamePopupMenuBuildIn = this.createDefaultTitledPopupMenu();
    private final TitledPopupMenu labelLayerNamePopupMenu = this.createDefaultTitledPopupMenu();
    private final TitledPopupMenu labelLayerNamePopupMenuBuildIn = this.createDefaultTitledPopupMenu();
    private final TitledPopupMenu dimLayerNamePopupMenu = this.createDefaultTitledPopupMenu();
    private final TitledPopupMenu dimLayerNamePopupMenuBuildIn = this.createDefaultTitledPopupMenu();
    private final TitledPopupMenu cadLayerNamePopupMenu = this.createDefaultTitledPopupMenu();
    private final TitledPopupMenu cadLayerNamePopupMenuBuildIn = this.createDefaultTitledPopupMenu();
    private final TitledPopupMenu redlineLayerNamePopupMenu = this.createDefaultTitledPopupMenu();
    private final TitledPopupMenu wmsLayerNamePopupMenu = this.initializeTitledPopUpMenu(WMSLayer.class, "ui.WorkbenchFrame.wms-layers-selected");
    private final TitledPopupMenu wmsLayerNamePopupMenuBuildIn = this.initializeTitledPopUpMenu(WMSLayer.class, "ui.WorkbenchFrame.wms-layers-selected");
    private final TitledPopupMenu wmtsLayerNamePopupMenu = this.initializeTitledPopUpMenu(WMTSLayer.class, "ui.WorkbenchFrame.wmts-layers-selected");
    private final TitledPopupMenu wmtsLayerNamePopupMenuBuildIn = this.initializeTitledPopUpMenu(WMTSLayer.class, "ui.WorkbenchFrame.wmts-layers-selected");
    private final TitledPopupMenu rasterLayerNamePopupMenu = this.initializeTitledPopUpMenu(RasterImageLayer.class);
    private final TitledPopupMenu rasterLayerNamePopupMenuBuildIn = this.initializeTitledPopUpMenu(RasterImageLayer.class);
    private final Map<Class<?>, Object> nodeClassToLayerNamePopupMenuMap = Map.of(Layer.class, this.layerNamePopupMenu, LabelLayer.class, this.labelLayerNamePopupMenu, RedlineLayer.class, this.redlineLayerNamePopupMenu, DimLayer.class, this.dimLayerNamePopupMenu, CadLayer.class, this.cadLayerNamePopupMenu, WMSLayer.class, this.wmsLayerNamePopupMenu, WMTSLayer.class, this.wmtsLayerNamePopupMenu, Category.class, this.categoryPopupMenu, RasterImageLayer.class, this.rasterLayerNamePopupMenu);
    private final Map<Class<?>, Object> nodeClassToLayerNamePopupMenuMapBuildIn = Map.of(Layer.class, this.layerNamePopupMenuBuildIn, LabelLayer.class, this.labelLayerNamePopupMenuBuildIn, RedlineLayer.class, this.redlineLayerNamePopupMenu, DimLayer.class, this.dimLayerNamePopupMenuBuildIn, CadLayer.class, this.cadLayerNamePopupMenuBuildIn, WMSLayer.class, this.wmsLayerNamePopupMenuBuildIn, WMTSLayer.class, this.wmtsLayerNamePopupMenuBuildIn, Category.class, this.categoryPopupMenuBuildIn, RasterImageLayer.class, this.rasterLayerNamePopupMenuBuildIn);

    public WorkbenchFrame(String title, WorkbenchContext workbenchContext) {
        super(WorkbenchFrame.getDeviceByScreenID());
        this.setTitle(title);
        this.workbenchContext = workbenchContext;
        this.toolBar = new WorkbenchToolBar(workbenchContext);
        this.toolBar.setFloatable(false);
        this.toolBar.setTaskMonitorManager(new TaskMonitorManager());
        this.setDefaultCloseOperation(0);
        WindowVisibleKeeper.keepFrameVisibleOnDeviceChanges(this);
        try {
            this.jbInit();
            this.createScaleCombo();
            this.configureStatusLabel(this.messageLabel, 230);
            this.configureStatusLabel(this.projectReductionLabel, 150);
            this.configureStatusLabel(this.coordinateLabel, 280);
            this.configureStatusLabel(this.crsLabel, 200);
            this.versionLabel.setFont(this.versionLabel.getFont().deriveFont(9.0f));
        }
        catch (Exception e) {
            log.warn("Error initializing WorkbenchFrame", (Throwable)e);
        }
        new RecursiveKeyListener(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyTyped(KeyEvent e) {
                WorkbenchFrame.this.easyKeyListenersLock.readLock().lock();
                try {
                    for (KeyListener l : WorkbenchFrame.this.easyKeyListeners) {
                        l.keyTyped(e);
                    }
                }
                finally {
                    WorkbenchFrame.this.easyKeyListenersLock.readLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e) {
                WorkbenchFrame.this.easyKeyListenersLock.readLock().lock();
                try {
                    for (KeyListener l : WorkbenchFrame.this.easyKeyListeners) {
                        l.keyPressed(e);
                    }
                }
                finally {
                    WorkbenchFrame.this.easyKeyListenersLock.readLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyReleased(KeyEvent e) {
                WorkbenchFrame.this.easyKeyListenersLock.readLock().lock();
                try {
                    for (KeyListener l : WorkbenchFrame.this.easyKeyListeners) {
                        l.keyReleased(e);
                    }
                }
                finally {
                    WorkbenchFrame.this.easyKeyListenersLock.readLock().unlock();
                }
            }
        };
        this.installKeyboardShortcutListener();
        this.installEnableStateListener();
        Dimension lastFrameSize = (Dimension)PersistentBlackboardPlugIn.get().get(WINDOW_DIM_KEY, new Dimension(1024, 768));
        Point lastFramePosition = (Point)PersistentBlackboardPlugIn.get().get(WINDOW_POS_KEY, new Point(0, 0));
        boolean lastFrameMaximized = PersistentBlackboardPlugIn.get().get(WINDOW_MAXIMIZED_KEY, false);
        if (lastFrameMaximized) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
        this.setSize(lastFrameSize);
        this.setLocation(lastFramePosition);
    }

    private void createScaleCombo() {
        this.scaleCombo.setEditable(false);
        this.scaleCombo.setFont(this.scaleCombo.getFont().deriveFont(11.0f));
        String strChooseScale = I18N.get("ui.DesktopPanel.choose-scale") + "...";
        String[] arrScales = I18N.get("ui.DesktopPanel.scales").split(",");
        this.scaleCombo.addItem(this.sbCurrentScale);
        this.scaleCombo.addItem(strChooseScale);
        for (String arrScale : arrScales) {
            this.scaleCombo.addItem("1 : " + arrScale);
        }
        this.scaleCombo.addActionListener(e -> this.changeScale(arrScales));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeScale(String[] arrScales) {
        if (this.bolBlockScaleEvent) {
            return;
        }
        this.bolBlockScaleEvent = true;
        try {
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)WorkbenchContext.getFrame(), (String)I18N.get("common.wait"), () -> {});
            Runnable work = () -> {
                try {
                    if (WorkbenchContext.getFrame() == null || WorkbenchContext.getFrame().getActiveInternalFrame() == null || !(WorkbenchContext.getFrame().getActiveInternalFrame() instanceof TaskFrame)) {
                        return;
                    }
                    if (this.scaleCombo.getSelectedIndex() == 0) {
                        return;
                    }
                    if (this.scaleCombo.getSelectedIndex() == 1) {
                        JUMPWorkbench.getBuiltInPlugIn(ZoomToScalePlugIn.class).execute(WorkbenchContext.getInstance().createPlugInContext());
                    } else {
                        WorkbenchContext.getMapAppContext().getActiveMap().zoomScale(Double.parseDouble(arrScales[this.scaleCombo.getSelectedIndex() - 2]));
                    }
                }
                catch (Exception e12) {
                    dlgWait.setError(e12);
                }
            };
            dlgWait.addWorkToDo(work);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                throw dlgWait.getError();
            }
        }
        catch (Exception e1) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e1, (String)"riwagis");
        }
        finally {
            this.scaleCombo.setSelectedIndex(0);
            this.bolBlockScaleEvent = false;
        }
    }

    public void activateDefaultCT() {
        JInternalFrame frm;
        JInternalFrame[] frames = this.getInternalFrames();
        boolean bolTaskFrameFound = false;
        for (JInternalFrame frm2 : frames) {
            if (!(frm2 instanceof TaskFrame)) continue;
            bolTaskFrameFound = true;
            break;
        }
        if (bolTaskFrameFound && (frm = this.getActiveInternalFrame()) instanceof TaskFrame) {
            LayerViewPanel lvp = ((TaskFrame)frm).getLayerViewPanel();
            CursorTool ct = AbstractCursorTool.getDelegate(lvp.getCurrentCursorTool());
            if (ct instanceof SelectFeaturesTool) {
                lvp.setCurrentCursorTool(new DummyTool());
            }
            SwingUtilities.invokeLater(() -> {
                WorkbenchToolBar.ToolConfig tc = this.getToolBar().getToolConfig4Class(SelectFeaturesTool.class);
                tc.getButton().setSelected(true);
                lvp.setCurrentCursorTool(tc.getQuasimodeTool());
            });
        }
    }

    private void installEnableStateListener() {
        this.addEnableStateListener(this.toolBar);
        this.addEnableStateListener(this.desktopPanel);
    }

    public void addEnableStateListener(EnableStateListener l) {
        this.lstEnableStateListener.add(l);
    }

    public void addEasyKeyListener(KeyListener l) {
        Runnable doAddListener = () -> {
            if (!this.easyKeyListeners.contains(l)) {
                this.easyKeyListeners.add(l);
            }
        };
        if (this.easyKeyListenersLock.writeLock().tryLock()) {
            try {
                doAddListener.run();
            }
            finally {
                this.easyKeyListenersLock.writeLock().unlock();
            }
        } else {
            SwingUtilities.invokeLater(doAddListener);
        }
    }

    public void removeEasyKeyListener(KeyListener l) {
        Runnable doRemoveListener = () -> this.easyKeyListeners.remove(l);
        if (this.easyKeyListenersLock.writeLock().tryLock()) {
            try {
                doRemoveListener.run();
            }
            finally {
                this.easyKeyListenersLock.writeLock().unlock();
            }
        } else {
            SwingUtilities.invokeLater(doRemoveListener);
        }
    }

    public void updateEnabledState() {
        for (EnableStateListener l : this.lstEnableStateListener) {
            l.updateEnabledState();
        }
    }

    public void log(String message) {
        log.info(message);
    }

    @Override
    public void setStatusMessage(String message) {
        this.setStatusBarText(message);
        this.setStatusBarTextHighlighted(false, null);
    }

    private void setStatusBarText(String message) {
        this.messageLabel.setText(Objects.toString(message, "").length() == 0 ? " " : message);
        this.messageLabel.setToolTipText("<html>" + WordUtils.wrap((String)message, (int)150, (String)"<br/>", (boolean)true) + "</html>");
    }

    public void setMemoryMessage(String message) {
        this.memoryLabel.setText(message);
    }

    private void setStatusBarTextHighlighted(boolean highlighted, Color color) {
        this.messageLabel.setForeground(highlighted ? Color.black : this.coordinateLabel.getForeground());
        this.messageLabel.setBackground(highlighted ? color : this.coordinateLabel.getBackground());
    }

    public void displayProjectionReductionLabel(boolean show) {
        if (show) {
            this.projectReductionLabel.setText(I18N.get("common.projection-reduction-activ"));
        } else {
            this.projectReductionLabel.setText("");
        }
    }

    public JInternalFrame getActiveInternalFrame() {
        return this.getDesktopPane().getSelectedFrame();
    }

    public JInternalFrame[] getInternalFrames() {
        return this.getDesktopPane().getAllFrames();
    }

    public TaskFrame getTaskFrameByTask(Task task) {
        JInternalFrame[] arrFrames;
        for (JInternalFrame arrFrame : arrFrames = this.getInternalFrames()) {
            if (!(arrFrame instanceof TaskFrame) || ((TaskFrame)arrFrame).getTask() != task) continue;
            return (TaskFrame)arrFrame;
        }
        return null;
    }

    public WorkbenchContext getContext() {
        return this.workbenchContext;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPanel.getDesktopPane();
    }

    public DesktopPanel getDesktopPanel() {
        return this.desktopPanel;
    }

    public TitledPopupMenu getCategoryPopupMenu(boolean bolBuildIn) {
        return bolBuildIn ? this.categoryPopupMenuBuildIn : this.categoryPopupMenu;
    }

    public TitledPopupMenu getLayerNamePopupMenu(boolean bolBuildIn) {
        return bolBuildIn ? this.layerNamePopupMenuBuildIn : this.layerNamePopupMenu;
    }

    public TitledPopupMenu getLabelLayerNamePopupMenu(boolean bolBuildIn) {
        return bolBuildIn ? this.labelLayerNamePopupMenuBuildIn : this.labelLayerNamePopupMenu;
    }

    public TitledPopupMenu getDimLayerNamePopupMenu(boolean bolBuildIn) {
        return bolBuildIn ? this.dimLayerNamePopupMenuBuildIn : this.dimLayerNamePopupMenu;
    }

    public TitledPopupMenu getCadLayerNamePopupMenu(boolean bolBuildIn) {
        return bolBuildIn ? this.cadLayerNamePopupMenuBuildIn : this.cadLayerNamePopupMenu;
    }

    public TitledPopupMenu getRedlineLayerNamePopupMenu() {
        return this.redlineLayerNamePopupMenu;
    }

    public TitledPopupMenu getRasterImageLayerNamePopupMenu(boolean bolBuildIn) {
        return bolBuildIn ? this.rasterLayerNamePopupMenuBuildIn : this.rasterLayerNamePopupMenu;
    }

    public TitledPopupMenu getWMSLayerNamePopupMenu(boolean bolBuildIn) {
        return bolBuildIn ? this.wmsLayerNamePopupMenuBuildIn : this.wmsLayerNamePopupMenu;
    }

    public JPopupMenu getWMTSLayerNamePopupMenu(boolean bolBuildIn) {
        return bolBuildIn ? this.wmtsLayerNamePopupMenuBuildIn : this.wmtsLayerNamePopupMenu;
    }

    public LayerViewPanelListener getLayerViewPanelListener() {
        return this.layerViewPanelListener;
    }

    public SelectionListener getSelectionListener() {
        return this.layerViewPanelListener;
    }

    public Map<Class<?>, Object> getNodeClassToPopupMenuMap(boolean bolBuildIn) {
        return bolBuildIn ? this.nodeClassToLayerNamePopupMenuMapBuildIn : this.nodeClassToLayerNamePopupMenuMap;
    }

    public LayerNamePanelListener getLayerNamePanelListener() {
        return this.layerNamePanelListener;
    }

    public WorkbenchToolBar getToolBar() {
        return this.toolBar;
    }

    public void activateFrame(JInternalFrame frame) {
        try {
            if (this.getState() == 1) {
                this.setState(0);
            }
            if (frame.isIcon()) {
                frame.setIcon(false);
            }
            frame.moveToFront();
            if (!(frame instanceof TaskFrame)) {
                frame.setMaximum(false);
            }
            if (!frame.isSelected()) {
                frame.setSelected(true);
            }
        }
        catch (PropertyVetoException e) {
            this.warnUser(StringUtil.stackTrace(e));
        }
    }

    private void addInternalFrame(JInternalFrame internalFrame, boolean alwaysOnTop, boolean autoUpdateToolBar) {
        internalFrame.setFrameIcon(new ImageIcon(IconLoader.class.getResource("icon-project.png")));
        internalFrame.setVisible(true);
        this.getDesktopPane().add((Component)internalFrame, alwaysOnTop ? JLayeredPane.PALETTE_LAYER : JLayeredPane.DEFAULT_LAYER);
        if (autoUpdateToolBar) {
            internalFrame.addInternalFrameListener(new InternalFrameListener(){

                @Override
                public void internalFrameActivated(InternalFrameEvent e) {
                    WorkbenchFrame.this.onInternalFrameChanged(e);
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    WorkbenchFrame.this.onInternalFrameChanged(e);
                }

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    WorkbenchFrame.this.onInternalFrameChanged(e);
                }

                @Override
                public void internalFrameDeactivated(InternalFrameEvent e) {
                    WorkbenchFrame.this.onInternalFrameChanged(e);
                }

                @Override
                public void internalFrameDeiconified(InternalFrameEvent e) {
                    WorkbenchFrame.this.onInternalFrameChanged(e);
                }

                @Override
                public void internalFrameIconified(InternalFrameEvent e) {
                    WorkbenchFrame.this.onInternalFrameChanged(e);
                }

                @Override
                public void internalFrameOpened(InternalFrameEvent e) {
                    WorkbenchFrame.this.onInternalFrameChanged(e);
                }
            });
            this.activateFrame(internalFrame);
            this.position(internalFrame);
        }
    }

    private void onInternalFrameChanged(InternalFrameEvent e) {
        this.updateEnabledState();
        if (e.getID() == 25554) {
            this.toolBar.reClickSelectedCursorToolButton();
            this.setStatusBarScale();
            this.setStatusBarSelection();
            this.setCoordinateInfo();
            JInternalFrame jInternalFrame = e.getInternalFrame();
            if (jInternalFrame instanceof TaskFrame) {
                TaskFrame taskFrame = (TaskFrame)jInternalFrame;
                for (TaskFrameChangedListener listener : this.taskFrameChangedListeners) {
                    listener.taskFrameChanged(taskFrame);
                }
            }
        }
    }

    public void setCoordinateInfo() {
        if (this.getActiveInternalFrame() instanceof TaskFrame) {
            TaskFrame tFrame = (TaskFrame)this.getActiveInternalFrame();
            DrawingUnit du = tFrame.getTask().getDrawingUnit();
            String strUnitName = du.getUnitName();
            this.layerViewPanelListener.setDrawingUnit(du);
            CRSDefinition crsDefinition = tFrame.getTask().getCRSDefinition();
            String strCrsName = Objects.toString(crsDefinition.getName(), "");
            this.crsLabel.setText(strCrsName);
            this.crsLabel.setToolTipText("<html>" + I18N.get("common.crs") + ": <b>" + strCrsName + "</b><br>" + Objects.toString(crsDefinition.getCode(), "") + "</html>");
            this.coordinateLabel.setToolTipText("<html>" + I18N.get("common.drawing-units") + ": <b>" + strUnitName + "</b><br>" + strCrsName + "</html>");
            this.scaleCombo.repaint();
        }
    }

    public void setStatusBarScale() {
        if (this.getActiveInternalFrame() instanceof TaskFrame) {
            TaskFrame tFrame = (TaskFrame)this.getActiveInternalFrame();
            Viewport vPort = tFrame.getLayerViewPanel().getViewport();
            double screenScale = ScreenScale.getHorizontalMapScale(vPort, tFrame.getTask().getDrawingUnit());
            this.sbCurrentScale.delete(0, this.sbCurrentScale.length());
            this.sbCurrentScale.append("1:").append(Math.round(screenScale));
            this.scaleCombo.repaint();
        }
    }

    public void setStatusBarSelection() {
        if (this.getActiveInternalFrame() instanceof TaskFrame) {
            TaskFrame tFrame = (TaskFrame)this.getActiveInternalFrame();
            Collection<Layer> col1 = tFrame.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
            Collection<Geometry> col2 = tFrame.getLayerViewPanel().getSelectionManager().getSelectedItems();
            StringBuilder sbMessage = new StringBuilder(col2.size() + " ");
            if (col1.size() == 1) {
                sbMessage.append(col1.toArray()[0]);
            } else {
                sbMessage.append(I18N.get("ui.WorkbenchFrame.selected-objects"));
            }
            sbMessage.append(" ").append(I18N.get("ui.WorkbenchFrame.selected"));
            this.memoryLabel.setText(sbMessage.toString());
        }
    }

    public TaskFrame addTaskFrame() {
        return this.addTaskFrame(this.createTask());
    }

    public Task createTask() {
        Task task = new Task();
        task.getLayerManager().addCategory(StandardCategoryNames.WORKING);
        task.getLayerManager().addCategory(StandardCategoryNames.SYSTEM);
        task.setName(I18N.get("ui.WorkbenchFrame.task") + " " + this.taskSequence);
        task.resetModifiedObjects();
        ++this.taskSequence;
        return task;
    }

    public TaskFrame addTaskFrame(Task task) {
        TaskFrame frmTsk = new TaskFrame(task, this.workbenchContext);
        frmTsk = this.addTaskFrame(frmTsk);
        return frmTsk;
    }

    public TaskFrame addTaskFrame(TaskFrame taskFrame) {
        taskFrame.getTask().getLayerManager().addLayerListener(new LayerListener(){

            @Override
            public void featuresChanged(FeatureEvent e) {
            }

            @Override
            public void categoryChanged(CategoryEvent e) {
                SwingUtilities.invokeLater(WorkbenchFrame.this::updateEnabledState);
            }

            @Override
            public void layerChanged(LayerEvent layerEvent) {
                SwingUtilities.invokeLater(WorkbenchFrame.this::updateEnabledState);
            }
        });
        this.addInternalFrame(taskFrame, false, true);
        taskFrame.getLayerViewPanel().getLayerManager().getUndoableEditReceiver().add(new UndoableEditReceiver.Listener(){

            @Override
            public void undoHistoryChanged() {
                SwingUtilities.invokeLater(WorkbenchFrame.this::updateEnabledState);
            }

            @Override
            public void undoHistoryTruncated() {
                SwingUtilities.invokeLater(WorkbenchFrame.this::updateEnabledState);
                WorkbenchFrame.this.log(I18N.get("ui.WorkbenchFrame.undo-history-was-truncated"));
            }
        });
        try {
            taskFrame.setMaximum(true);
            taskFrame.getLayerViewPanel().setRepaint(true);
            Envelope defaultExtent = NavigationPanel.getDefaultExtent();
            if (defaultExtent != null) {
                taskFrame.getLayerViewPanel().getViewport().zoom(defaultExtent);
                this.infoUser(I18N.get("ui.zoom.ZoomTool.NavigationPanel.default-used"));
                taskFrame.getLayerViewPanel().setViewportInitialized(true);
            } else {
                taskFrame.getLayerViewPanel().zoomToFullExtent();
            }
        }
        catch (Exception e) {
            log.error("Error maximizing TaskFrame", (Throwable)e);
        }
        return taskFrame;
    }

    private void flashStatusMessage(final String message, final Color color) {
        new Timer(100, new ActionListener(){
            private int tickCount = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                ++this.tickCount;
                WorkbenchFrame.this.setStatusBarText(message);
                WorkbenchFrame.this.setStatusBarTextHighlighted(this.tickCount % 2 == 0, color);
                if (this.tickCount == 4) {
                    Timer timer = (Timer)e.getSource();
                    timer.stop();
                }
            }
        }).start();
    }

    @Override
    public void handleThrowable(Throwable t) {
        log.error(t.getMessage(), t);
        Window parent = this;
        for (Window ownedWindow : this.getOwnedWindows()) {
            if (!(ownedWindow instanceof Dialog) || !ownedWindow.isVisible() || !((Dialog)ownedWindow).isModal()) continue;
            parent = ownedWindow;
            break;
        }
        WorkbenchFrame.handleThrowable(t, parent);
    }

    public static void handleThrowable(Throwable t, Component parent) {
        log.error(t.getMessage(), t);
        ExpandableDialog.show((Component)parent, (String)I18N.get("ui.WorkbenchFrame.exception"), (String)I18N.getMessage("ui.WorkbenchFrame.exception-message", t.getClass().getSimpleName()), (String)WorkbenchFrame.toDisplayMessage(t), (String)StringUtil.stackTrace(t), (ExpandableDialog.Type)ExpandableDialog.Type.ERROR, (boolean)false);
    }

    private static String toDisplayMessage(Throwable t) {
        if (t instanceof UserFriendlyException) {
            return t.getLocalizedMessage();
        }
        if (t.getLocalizedMessage() == null) {
            return I18N.get("ui.WorkbenchFrame.no-description-was-provided");
        }
        Object message = t.getLocalizedMessage();
        if (t.getLocalizedMessage().toLowerCase().contains(I18N.get("ui.WorkbenchFrame.side-location-conflict"))) {
            message = (String)message + " -- " + I18N.get("ui.WorkbenchFrame.check-for-invalid-geometries");
        }
        message = WorkbenchFrame.removeClassPrefix((String)message, t);
        message = WorkbenchFrame.removeClassPrefix((String)message, t.getCause());
        return message;
    }

    private static String removeClassPrefix(String message, Throwable excp) {
        if (excp == null) {
            return message;
        }
        String prefix = excp.getClass().getName() + ": ";
        if (message.startsWith(prefix)) {
            return message.substring(prefix.length());
        }
        return message;
    }

    public static String toMessage(Throwable t) {
        Object message = t.getLocalizedMessage() == null ? I18N.get("ui.WorkbenchFrame.no-description-was-provided") : (t.getLocalizedMessage().toLowerCase().contains(I18N.get("ui.WorkbenchFrame.side-location-conflict")) ? t.getLocalizedMessage() + " -- " + I18N.get("ui.WorkbenchFrame.check-for-invalid-geometries") : t.getLocalizedMessage());
        if (t instanceof UserFriendlyException) {
            return message;
        }
        return String.format("%s (%s)", message, StringUtil.toFriendlyName(t.getClass().getName()));
    }

    public boolean hasInternalFrame(JInternalFrame internalFrame) {
        JInternalFrame[] frames;
        for (JInternalFrame frame : frames = this.getDesktopPane().getAllFrames()) {
            if (frame != internalFrame) continue;
            return true;
        }
        return false;
    }

    public void removeInternalFrame(JInternalFrame internalFrame) {
        this.getDesktopPane().getDesktopManager().closeFrame(internalFrame);
    }

    @Override
    public void warnUser(String warning) {
        log.error(I18N.get("ui.WorkbenchFrame.warning") + ": " + warning);
        this.flashStatusMessage(warning, Color.yellow);
        new Timer(10000, e -> {
            this.setStatusBarText("");
            this.setStatusBarTextHighlighted(false, Color.YELLOW);
            Timer timer = (Timer)e.getSource();
            timer.stop();
        }).start();
    }

    public synchronized void infoUser(String info) {
        if (this.bolInInfo.get()) {
            this.lstNextInfos.add(info);
            return;
        }
        this.bolInInfo.set(true);
        this.log(I18N.get("common.message") + ": " + info);
        this.flashStatusMessage(info, Color.GREEN);
        new Timer(3000, e -> {
            this.setStatusBarText("");
            this.setStatusBarTextHighlighted(false, Color.GREEN);
            Timer timer = (Timer)e.getSource();
            timer.stop();
            this.bolInInfo.set(false);
            if (!this.lstNextInfos.isEmpty()) {
                this.infoUser(this.lstNextInfos.remove(0));
            }
        }).start();
    }

    @Override
    public void zoomChanged(Viewport vPort) {
        this.updateEnabledState();
        this.setStatusBarScale();
    }

    private void updateFrameState() {
        try {
            this.updateEnabledState();
            this.desktopPanel.setDefaultRightDividerLocation();
            this.desktopPanel.setDefaultLeftDividerLocation();
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
    }

    private void updateMenuState() {
        JInternalFrame[] frames = this.getDesktopPane().getAllFrames();
        int allItems = this.windowMenu.getItemCount();
        if (this.intWindowMenuCount == -1) {
            this.intWindowMenuCount = this.windowMenu.getItemCount();
        }
        int loopsdone = 0;
        for (int itemIdx = this.intWindowMenuCount; itemIdx < allItems; ++itemIdx) {
            try {
                this.windowMenu.remove(itemIdx - loopsdone);
                ++loopsdone;
                continue;
            }
            catch (Exception exc) {
                log.warn("WorkbenchFrame: exception in windowMenu_Selected() ", (Throwable)exc);
            }
        }
        for (JInternalFrame frame : frames) {
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText(GUIUtil.truncateString(frame.getTitle(), 40));
            this.associate(menuItem, frame);
            this.windowMenu.add(menuItem);
        }
    }

    private void associate(JMenuItem menuItem, JInternalFrame frame) {
        menuItem.addActionListener(e -> {
            try {
                this.activateFrame(frame);
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
        });
    }

    private void closeApplication() {
        this.applicationExitHandler.exitApplication(this);
    }

    private void configureStatusLabel(JComponent label, int width) {
        label.setMaximumSize(new Dimension(width, (int)label.getMaximumSize().getHeight()));
        label.setPreferredSize(new Dimension(width, (int)label.getPreferredSize().getHeight()));
    }

    private void jbInit() {
        this.setDefaultCloseOperation(0);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                WorkbenchFrame.this.updateFrameState();
            }
        });
        this.getContentPane().setLayout(this.borderLayout1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WorkbenchFrame.this.closeApplication();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                WorkbenchFrame.this.repaint();
            }
        });
        this.setJMenuBar(this.jMenuBar);
        this.messageLabel.setOpaque(true);
        this.memoryLabel.setText("jLabel1");
        this.exitMenuItem.addActionListener(e -> this.closeApplication());
        this.windowMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                WorkbenchFrame.this.updateMenuState();
            }
        });
        Border defaultBorder = BorderFactory.createEmptyBorder();
        this.crsLabel.setBorder(defaultBorder);
        this.busyLabel.setBusy(false);
        this.busyLabel.setForeground(Color.BLUE.darker().darker());
        this.busyLabel.setBorder(defaultBorder);
        this.busyLabel.getBusyPainter().setHighlightColor(Color.BLUE.darker().darker());
        this.crsLabel.setText(" ");
        this.coordinateLabel.setBorder(defaultBorder);
        this.coordinateLabel.setText(" ");
        this.statusPanel.setLayout(this.gridBagLayout1);
        this.statusPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.messageLabel.setBorder(defaultBorder);
        this.messageLabel.setText(" ");
        this.projectReductionLabel.setBorder(defaultBorder);
        this.projectReductionLabel.setText(I18N.get("common.projection-reduction-activ"));
        this.versionLabel.setText(I18N.get("common.version") + " " + JUMPWorkbench.getDisplayVersion());
        this.memoryLabel.setBorder(defaultBorder);
        this.memoryLabel.setText(" ");
        this.jMenuBar.add(this.fileMenu);
        this.jMenuBar.add(this.windowMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenuItem);
        this.statusPanel.add((Component)this.versionLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.statusPanel.add((Component)this.messageLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.memoryLabel, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 4, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.projectReductionLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 4, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.coordinateLabel, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.crsLabel, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
        this.statusPanel.add(this.scaleCombo, new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.busyLabel, new GridBagConstraints(8, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 2, 0, 0), 0, 0));
        this.desktopPanel.getDesktopPane().setTransferHandler(new LoadTaskTransferHandler());
        JPanel panel2d = new JPanel(new BorderLayout());
        panel2d.add((Component)this.toolBar, "North");
        panel2d.add((Component)this.desktopPanel, "Center");
        panel2d.add((Component)this.statusPanel, "South");
        panel2d.setBorder(BorderFactory.createEmptyBorder());
        this.dividerSize = this.splitPane.getDividerSize();
        this.splitPane.setLeftComponent(panel2d);
        this.splitPane.setRightComponent(null);
        this.splitPane.setDividerSize(0);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.getContentPane().add((Component)this.splitPane, "Center");
    }

    public void setRightSplitComponent(JComponent component) {
        if (component != null) {
            this.splitPane.setDividerSize(this.dividerSize);
            this.splitPane.setRightComponent(component);
            if (this.dividerPos == -1) {
                this.splitPane.setDividerLocation(0.5);
            } else {
                this.splitPane.setDividerLocation(this.dividerPos);
            }
        } else {
            this.splitPane.setDividerSize(0);
            this.splitPane.setRightComponent(null);
            this.dividerPos = this.splitPane.getDividerLocation();
        }
    }

    public boolean isSplitViewVisible() {
        return this.splitPane.getRightComponent() != null;
    }

    private void position(JInternalFrame internalFrame) {
        int STEP = 5;
        ++this.iFramePositionIndex;
        int offset = this.iFramePositionIndex % 5 * 5;
        GUIUtil.Location location = new GUIUtil.Location(offset, false, offset, false);
        GUIUtil.setLocation(internalFrame, location, this.getDesktopPane());
    }

    public void activateProgressBar() {
        this.busyLabel.setBusy(true);
    }

    public void deactivateProgressBar() {
        this.busyLabel.setBusy(false);
    }

    public void addKeyboardShortcut(int keyCode, int modifiers, PlugIn plugIn, EnableCheck enableCheck) {
        this.keyCodeAndModifiersToPlugInAndEnableCheckMap.put(keyCode + ":" + modifiers, new Object[]{plugIn, enableCheck});
    }

    public void addKeyboardShortcutForMap(int keyCode, int modifiers, PlugIn plugIn, EnableCheck enableCheck) {
        MultiEnableCheck mapCheck = new MultiEnableCheck().add(WorkbenchFrame.createNoTextFieldFocusedEnableCheck()).add(enableCheck);
        this.addKeyboardShortcut(keyCode, modifiers, plugIn, mapCheck);
    }

    private static EnableCheck createNoTextFieldFocusedEnableCheck() {
        return c -> {
            Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (comp instanceof JTextComponent) {
                return "Focused text component. Skipping.";
            }
            return null;
        };
    }

    private void installKeyboardShortcutListener() {
        this.addEasyKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                Object[] plugInAndEnableCheck = WorkbenchFrame.this.keyCodeAndModifiersToPlugInAndEnableCheckMap.get(e.getKeyCode() + ":" + e.getModifiersEx());
                if (plugInAndEnableCheck == null) {
                    return;
                }
                PlugIn plugIn = (PlugIn)plugInAndEnableCheck[0];
                EnableCheck enableCheck = (EnableCheck)plugInAndEnableCheck[1];
                if (enableCheck != null && enableCheck.check(null) != null) {
                    return;
                }
                AbstractPlugIn.toActionListener(plugIn, WorkbenchFrame.this.workbenchContext, new TaskMonitorManager()).actionPerformed(null);
            }
        });
    }

    public void activateDefaultRightPane() {
        JTabbedPane parentComponent = this.getDesktopPanel().getRightTabbedPane();
        String defaultTab = this.getComponentNameWithHighestPriority(parentComponent).orElse(null);
        String userTab = PersistentBlackboardPlugIn.get().get(RIGHT_PANE_SELECTED_COMPONENT_KEY, defaultTab);
        for (Component component : parentComponent.getComponents()) {
            if (!Objects.equals(component.getName(), userTab)) continue;
            parentComponent.setSelectedComponent(component);
            return;
        }
        log.error("Right Tab Component '{}' not found");
    }

    private Optional<String> getComponentNameWithHighestPriority(JComponent parentComponent) {
        return Arrays.stream(parentComponent.getComponents()).max(Comparator.comparingInt(c -> {
            if (c instanceof Priorizable) {
                return ((Priorizable)((Object)c)).getPriority();
            }
            return 0;
        })).map(Component::getName);
    }

    public List<TaskFrameChangedListener> getTaskFrameChangedListeners() {
        return Collections.unmodifiableList(this.taskFrameChangedListeners);
    }

    public void addTaskFrameChangedListener(TaskFrameChangedListener listener) {
        this.taskFrameChangedListeners.add(listener);
    }

    public boolean removeTaskFrameChangedListener(TaskFrameChangedListener listener) {
        return this.taskFrameChangedListeners.remove(listener);
    }

    private int getCurrentScreen() {
        GraphicsDevice device = this.getGraphicsConfiguration().getDevice();
        GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i = 0; i < screenDevices.length; ++i) {
            if (screenDevices[i] != device) continue;
            return i;
        }
        return 0;
    }

    private static GraphicsConfiguration getDeviceByScreenID() {
        int id;
        GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (screenDevices.length > (id = Integer.valueOf(PersistentBlackboardPlugIn.get().get(WINDOW_SCREEN_KEY, 0)).intValue())) {
            return screenDevices[id].getDefaultConfiguration();
        }
        return null;
    }

    private TitledPopupMenu createDefaultTitledPopupMenu() {
        return this.initializeTitledPopUpMenu(Layer.class, "ui.WorkbenchFrame.layers-selected");
    }

    private <T extends HasName> TitledPopupMenu initializeTitledPopUpMenu(Class<T> layerableClass, String i18n) {
        return this.initializeTitledPopUpMenu((LayerNamePanel panel) -> {
            if (panel.selectedNodes(layerableClass).size() != 1) {
                return String.format("(%d %s)", panel.selectedNodes(layerableClass).size(), I18N.get(i18n));
            }
            return ((HasName)panel.selectedNodes(layerableClass).iterator().next()).getName();
        });
    }

    private <T extends HasName> TitledPopupMenu initializeTitledPopUpMenu(Class<T> layerableClass) {
        return this.initializeTitledPopUpMenu((LayerNamePanel panel) -> ((HasName)panel.selectedNodes(layerableClass).iterator().next()).getName());
    }

    private TitledPopupMenu initializeTitledPopUpMenu(final Function<LayerNamePanel, String> titleSupplier) {
        TitledPopupMenu newMenu = new TitledPopupMenu();
        newMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                LayerNamePanel panel = ((LayerNamePanelProxy)((Object)WorkbenchFrame.this.getActiveInternalFrame())).getLayerNamePanel();
                ((TitledPopupMenu)e.getSource()).setTitle((String)titleSupplier.apply(panel));
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        return newMenu;
    }

    private final class DefaultApplicationExitHandler
    implements ApplicationExitHandler {
        private DefaultApplicationExitHandler() {
        }

        @Override
        public void exitApplication(JFrame mainFrame) {
            JInternalFrame[] arrFrames;
            EditingPanel.instanceOf().persistDefaultLayer();
            for (JInternalFrame iFrm : arrFrames = WorkbenchFrame.this.getInternalFrames()) {
                if (!(iFrm instanceof TaskFrame) || ((TaskFrame)iFrm).closeTaskFrame(false)) continue;
                return;
            }
            PersistentBlackboardPlugIn.get().put(WorkbenchFrame.WINDOW_DIM_KEY, WorkbenchFrame.this.getSize());
            PersistentBlackboardPlugIn.get().put(WorkbenchFrame.WINDOW_POS_KEY, WorkbenchFrame.this.getLocation());
            PersistentBlackboardPlugIn.get().put(WorkbenchFrame.WINDOW_SCREEN_KEY, WorkbenchFrame.this.getCurrentScreen());
            PersistentBlackboardPlugIn.get().put(WorkbenchFrame.WINDOW_MAXIMIZED_KEY, (WorkbenchFrame.this.getExtendedState() & 6) != 0);
            PersistentBlackboardPlugIn.get().put(WorkbenchFrame.RIGHT_PANE_SELECTED_COMPONENT_KEY, WorkbenchFrame.this.getDesktopPanel().getRightTabbedPane().getSelectedComponent().getName());
            for (JInternalFrame frm : arrFrames) {
                frm.setVisible(false);
            }
            JUMPWorkbench.getPlugInManager().closeAllConfigurations();
            try {
                Thread shutDownConnMngr = new Thread(WorkbenchFrame.this.workbenchContext::closeHttpClient);
                shutDownConnMngr.start();
                shutDownConnMngr.join(5000L);
            }
            catch (InterruptedException eatit) {
                log.warn("Error while waiting", (Throwable)eatit);
                Thread.currentThread().interrupt();
            }
            JUMPWorkbench.getGisContext().map(GisContext::getModuleApp).ifPresent(ModuleAppContext::close);
            WorkbenchFrame.this.setVisible(false);
            SwingUtilities.invokeLater(() -> System.exit(0));
        }
    }
}

